/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.os.Trace;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.alibaba.android.vlayout.ExposeLinearLayoutManagerEx;
import com.alibaba.android.vlayout.LayoutHelper;
import com.alibaba.android.vlayout.LayoutHelperFinder;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.LayoutView;
import com.alibaba.android.vlayout.LayoutViewFactory;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.Range;
import com.alibaba.android.vlayout.RangeLayoutHelperFinder;
import com.alibaba.android.vlayout.extend.LayoutManagerCanScrollListener;
import com.alibaba.android.vlayout.extend.PerformanceMonitor;
import com.alibaba.android.vlayout.extend.ViewLifeCycleHelper;
import com.alibaba.android.vlayout.extend.ViewLifeCycleListener;
import com.alibaba.android.vlayout.layout.BaseLayoutHelper;
import com.alibaba.android.vlayout.layout.DefaultLayoutHelper;
import com.alibaba.android.vlayout.layout.FixAreaAdjuster;
import com.alibaba.android.vlayout.layout.FixAreaLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VirtualLayoutManager
extends ExposeLinearLayoutManagerEx
implements LayoutManagerHelper {
    protected static final String TAG = "VirtualLayoutManager";
    private static final String PHASE_MEASURE = "measure";
    private static final String PHASE_LAYOUT = "layout";
    private static final String TRACE_LAYOUT = "VLM onLayoutChildren";
    private static final String TRACE_SCROLL = "VLM scroll";
    public static boolean sDebuggable = false;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected OrientationHelperEx mOrientationHelper;
    protected OrientationHelperEx mSecondaryOrientationHelper;
    private RecyclerView mRecyclerView;
    private boolean mNoScrolling = false;
    private boolean mNestedScrolling = false;
    private boolean mCanScrollHorizontally;
    private boolean mCanScrollVertically;
    private LayoutManagerCanScrollListener layoutManagerCanScrollListener;
    private boolean mEnableMarginOverlapping = false;
    private int mMaxMeasureSize = -1;
    private PerformanceMonitor mPerformanceMonitor;
    private ViewLifeCycleHelper mViewLifeCycleHelper;
    private Comparator<Pair<Range<Integer>, Integer>> mRangeComparator = new Comparator<Pair<Range<Integer>, Integer>>(){

        @Override
        public int compare(Pair<Range<Integer>, Integer> a, Pair<Range<Integer>, Integer> b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            Range lr = (Range)a.first;
            Range rr = (Range)b.first;
            return (Integer)lr.getLower() - (Integer)rr.getLower();
        }
    };
    private LayoutHelperFinder mHelperFinder;
    private FixAreaAdjuster mFixAreaAdjustor = FixAreaAdjuster.mDefaultAdjuster;
    private HashMap<Integer, LayoutHelper> newHelpersSet = new HashMap();
    private HashMap<Integer, LayoutHelper> oldHelpersSet = new HashMap();
    private BaseLayoutHelper.LayoutViewBindListener mLayoutViewBindListener;
    private AnchorInfoWrapper mTempAnchorInfoWrapper = new AnchorInfoWrapper();
    private int mNested = 0;
    private LayoutStateWrapper mTempLayoutStateWrapper = new LayoutStateWrapper();
    private List<Pair<Range<Integer>, Integer>> mRangeLengths = new ArrayList<Pair<Range<Integer>, Integer>>();
    private static LayoutHelper DEFAULT_LAYOUT_HELPER = new DefaultLayoutHelper();
    private LayoutHelper mDefaultLayoutHelper = DEFAULT_LAYOUT_HELPER;
    private LayoutViewFactory mLayoutViewFatory = new LayoutViewFactory(){

        @Override
        public View generateLayoutView(@NonNull Context context) {
            return new LayoutView(context);
        }
    };
    private Rect mDecorInsets = new Rect();
    private static final int MAX_NO_SCROLLING_SIZE = 0x7FFFFFF;
    private boolean mSpaceMeasured = false;
    private int mMeasuredFullSpace = 0;
    private boolean mSpaceMeasuring = false;

    public static void enableDebugging(boolean isDebug) {
        sDebuggable = isDebug;
    }

    public VirtualLayoutManager(@NonNull Context context) {
        this(context, 1);
    }

    public VirtualLayoutManager(@NonNull Context context, int orientation) {
        this(context, orientation, false);
    }

    public VirtualLayoutManager(@NonNull Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
        this.mOrientationHelper = OrientationHelperEx.createOrientationHelper(this, orientation);
        this.mSecondaryOrientationHelper = OrientationHelperEx.createOrientationHelper(this, orientation == 1 ? 0 : 1);
        this.mCanScrollVertically = super.canScrollVertically();
        this.mCanScrollHorizontally = super.canScrollHorizontally();
        this.setHelperFinder(new RangeLayoutHelperFinder());
    }

    public void setPerformanceMonitor(PerformanceMonitor performanceMonitor) {
        this.mPerformanceMonitor = performanceMonitor;
    }

    public void setNoScrolling(boolean noScrolling) {
        this.mNoScrolling = noScrolling;
        this.mSpaceMeasured = false;
        this.mMeasuredFullSpace = 0;
        this.mSpaceMeasuring = false;
    }

    public void setCanScrollVertically(boolean canScrollVertically) {
        this.mCanScrollVertically = canScrollVertically;
    }

    public void setCanScrollHorizontally(boolean canScrollHorizontally) {
        this.mCanScrollHorizontally = canScrollHorizontally;
    }

    public void setLayoutManagerCanScrollListener(LayoutManagerCanScrollListener layoutManagerCanScrollListener) {
        this.layoutManagerCanScrollListener = layoutManagerCanScrollListener;
    }

    public void setNestedScrolling(boolean nestedScrolling) {
        this.setNestedScrolling(nestedScrolling, -1);
    }

    public void setNestedScrolling(boolean nestedScrolling, int maxMeasureSize) {
        this.mNestedScrolling = nestedScrolling;
        this.mSpaceMeasured = false;
        this.mSpaceMeasuring = false;
        this.mMeasuredFullSpace = 0;
    }

    public void setHelperFinder(@NonNull LayoutHelperFinder finder) {
        if (finder == null) {
            throw new IllegalArgumentException("finder is null");
        }
        LinkedList<LayoutHelper> helpers = new LinkedList<LayoutHelper>();
        if (this.mHelperFinder != null) {
            List<LayoutHelper> layoutHelpers = this.mHelperFinder.getLayoutHelpers();
            Iterator<LayoutHelper> iterator = layoutHelpers.iterator();
            LayoutHelper layoutHelper = null;
            while (iterator.hasNext()) {
                layoutHelper = iterator.next();
                helpers.add(layoutHelper);
            }
        }
        this.mHelperFinder = finder;
        if (helpers.size() > 0) {
            this.mHelperFinder.setLayouts(helpers);
        }
        this.mSpaceMeasured = false;
        this.requestLayout();
    }

    public void setFixOffset(int left, int top, int right, int bottom) {
        this.mFixAreaAdjustor = new FixAreaAdjuster(left, top, right, bottom);
    }

    public void setLayoutHelpers(@Nullable List<LayoutHelper> helpers) {
        List<LayoutHelper> layoutHelpers = this.mHelperFinder.getLayoutHelpers();
        for (LayoutHelper helper : layoutHelpers) {
            this.oldHelpersSet.put(System.identityHashCode(helper), helper);
        }
        if (helpers != null) {
            int start = 0;
            for (LayoutHelper helper : helpers) {
                if (helper instanceof FixAreaLayoutHelper) {
                    ((FixAreaLayoutHelper)helper).setAdjuster(this.mFixAreaAdjustor);
                }
                if (helper instanceof BaseLayoutHelper && this.mLayoutViewBindListener != null) {
                    ((BaseLayoutHelper)helper).setLayoutViewBindListener(this.mLayoutViewBindListener);
                }
                if (helper.getItemCount() > 0) {
                    helper.setRange(start, start + helper.getItemCount() - 1);
                } else {
                    helper.setRange(-1, -1);
                }
                start += helper.getItemCount();
            }
        }
        this.mHelperFinder.setLayouts(helpers);
        layoutHelpers = this.mHelperFinder.getLayoutHelpers();
        for (LayoutHelper layoutHelper : layoutHelpers) {
            this.newHelpersSet.put(System.identityHashCode(layoutHelper), layoutHelper);
        }
        Iterator<Map.Entry<Integer, LayoutHelper>> it = this.oldHelpersSet.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, LayoutHelper> entry = it.next();
            Integer key = entry.getKey();
            if (!this.newHelpersSet.containsKey(key)) continue;
            this.newHelpersSet.remove(key);
            it.remove();
        }
        for (LayoutHelper helper : this.oldHelpersSet.values()) {
            helper.clear(this);
        }
        if (!this.oldHelpersSet.isEmpty() || !this.newHelpersSet.isEmpty()) {
            this.mSpaceMeasured = false;
        }
        this.oldHelpersSet.clear();
        this.newHelpersSet.clear();
        this.requestLayout();
    }

    @NonNull
    public List<LayoutHelper> getLayoutHelpers() {
        return this.mHelperFinder.getLayoutHelpers();
    }

    public void setEnableMarginOverlapping(boolean enableMarginOverlapping) {
        this.mEnableMarginOverlapping = enableMarginOverlapping;
    }

    @Override
    public boolean isEnableMarginOverLap() {
        return this.mEnableMarginOverlapping;
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    @Override
    public void setOrientation(int orientation) {
        this.mOrientationHelper = OrientationHelperEx.createOrientationHelper(this, orientation);
        super.setOrientation(orientation);
    }

    public void setReverseLayout(boolean reverseLayout) {
        if (reverseLayout) {
            throw new UnsupportedOperationException("VirtualLayoutManager does not support reverse layout in current version.");
        }
        super.setReverseLayout(false);
    }

    public void setStackFromEnd(boolean stackFromEnd) {
        if (stackFromEnd) {
            throw new UnsupportedOperationException("VirtualLayoutManager does not support stack from end.");
        }
        super.setStackFromEnd(false);
    }

    @Override
    public void onAnchorReady(RecyclerView.State state, ExposeLinearLayoutManagerEx.AnchorInfo anchorInfo) {
        super.onAnchorReady(state, anchorInfo);
        boolean changed = true;
        while (changed) {
            this.mTempAnchorInfoWrapper.position = anchorInfo.mPosition;
            this.mTempAnchorInfoWrapper.coordinate = anchorInfo.mCoordinate;
            this.mTempAnchorInfoWrapper.layoutFromEnd = anchorInfo.mLayoutFromEnd;
            LayoutHelper layoutHelper = this.mHelperFinder.getLayoutHelper(anchorInfo.mPosition);
            if (layoutHelper != null) {
                layoutHelper.checkAnchorInfo(state, this.mTempAnchorInfoWrapper, this);
            }
            if (this.mTempAnchorInfoWrapper.position == anchorInfo.mPosition) {
                changed = false;
            } else {
                anchorInfo.mPosition = this.mTempAnchorInfoWrapper.position;
            }
            anchorInfo.mCoordinate = this.mTempAnchorInfoWrapper.coordinate;
            this.mTempAnchorInfoWrapper.position = -1;
        }
        this.mTempAnchorInfoWrapper.position = anchorInfo.mPosition;
        this.mTempAnchorInfoWrapper.coordinate = anchorInfo.mCoordinate;
        List<LayoutHelper> layoutHelpers = this.mHelperFinder.getLayoutHelpers();
        Iterator<LayoutHelper> iterator = layoutHelpers.iterator();
        LayoutHelper layoutHelper = null;
        while (iterator.hasNext()) {
            layoutHelper = iterator.next();
            layoutHelper.onRefreshLayout(state, this.mTempAnchorInfoWrapper, this);
        }
    }

    public LayoutHelper findNeighbourNonfixLayoutHelper(LayoutHelper layoutHelper, boolean isLayoutEnd) {
        int next;
        if (layoutHelper == null) {
            return null;
        }
        List<LayoutHelper> layoutHelpers = this.mHelperFinder.getLayoutHelpers();
        int index = layoutHelpers.indexOf(layoutHelper);
        if (index == -1) {
            return null;
        }
        int n = next = isLayoutEnd ? index - 1 : index + 1;
        if (next >= 0 && next < layoutHelpers.size()) {
            LayoutHelper helper = layoutHelpers.get(next);
            if (helper != null) {
                if (helper.isFixLayout()) {
                    return null;
                }
                return helper;
            }
            return null;
        }
        return null;
    }

    @Override
    protected int computeAlignOffset(View child, boolean isLayoutEnd, boolean useAnchor) {
        return this.computeAlignOffset(this.getPosition(child), isLayoutEnd, useAnchor);
    }

    @Override
    protected int computeAlignOffset(int position, boolean isLayoutEnd, boolean useAnchor) {
        LayoutHelper helper;
        if (position != -1 && (helper = this.mHelperFinder.getLayoutHelper(position)) != null) {
            return helper.computeAlignOffset(position - helper.getRange().getLower(), isLayoutEnd, useAnchor, this);
        }
        return 0;
    }

    public int obtainExtraMargin(View child, boolean isLayoutEnd) {
        return this.obtainExtraMargin(child, isLayoutEnd, true);
    }

    public int obtainExtraMargin(View child, boolean isLayoutEnd, boolean useAnchor) {
        if (child != null) {
            return this.computeAlignOffset(child, isLayoutEnd, useAnchor);
        }
        return 0;
    }

    private void runPreLayout(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mNested == 0) {
            List<LayoutHelper> reverseLayoutHelpers = this.mHelperFinder.reverse();
            Iterator<LayoutHelper> iterator = reverseLayoutHelpers.iterator();
            LayoutHelper layoutHelper = null;
            while (iterator.hasNext()) {
                layoutHelper = iterator.next();
                layoutHelper.beforeLayout(recycler, state, this);
            }
        }
        ++this.mNested;
    }

    private void runPostLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int scrolled) {
        --this.mNested;
        if (this.mNested <= 0) {
            this.mNested = 0;
            int startPosition = this.findFirstVisibleItemPosition();
            int endPosition = this.findLastVisibleItemPosition();
            List<LayoutHelper> layoutHelpers = this.mHelperFinder.getLayoutHelpers();
            Iterator<LayoutHelper> iterator = layoutHelpers.iterator();
            LayoutHelper layoutHelper = null;
            while (iterator.hasNext()) {
                layoutHelper = iterator.next();
                try {
                    layoutHelper.afterLayout(recycler, state, startPosition, endPosition, scrolled, this);
                }
                catch (Exception e) {
                    if (!sDebuggable) continue;
                    throw e;
                }
            }
            if (null != this.mViewLifeCycleHelper) {
                this.mViewLifeCycleHelper.checkViewStatusInScreen();
            }
        }
    }

    public void runAdjustLayout() {
        int startPosition = this.findFirstVisibleItemPosition();
        LayoutHelper firstLayoutHelper = this.mHelperFinder.getLayoutHelper(startPosition);
        int endPosition = this.findLastVisibleItemPosition();
        LayoutHelper lastLayoutHelper = this.mHelperFinder.getLayoutHelper(endPosition);
        List<LayoutHelper> totalLayoutHelpers = this.mHelperFinder.getLayoutHelpers();
        int start = totalLayoutHelpers.indexOf(firstLayoutHelper);
        int end = totalLayoutHelpers.indexOf(lastLayoutHelper);
        for (int i = start; i <= end; ++i) {
            try {
                totalLayoutHelpers.get(i).adjustLayout(startPosition, endPosition, this);
                continue;
            }
            catch (Exception e) {
                if (!sDebuggable) continue;
                throw e;
            }
        }
    }

    @Override
    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (Build.VERSION.SDK_INT >= 18) {
            Trace.beginSection((String)TRACE_LAYOUT);
        }
        if (this.mNoScrolling && state.didStructureChange()) {
            this.mSpaceMeasured = false;
            this.mSpaceMeasuring = true;
        }
        this.runPreLayout(recycler, state);
        try {
            super.onLayoutChildren(recycler, state);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.runPostLayout(recycler, state, Integer.MAX_VALUE);
        }
        if ((this.mNestedScrolling || this.mNoScrolling) && this.mSpaceMeasuring) {
            this.mSpaceMeasured = true;
            int childCount = this.getChildCount();
            View lastChild = this.getChildAt(childCount - 1);
            if (lastChild != null) {
                ViewParent parent;
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)lastChild.getLayoutParams();
                this.mMeasuredFullSpace = this.getDecoratedBottom(lastChild) + params.bottomMargin + this.computeAlignOffset(lastChild, true, false);
                if (this.mRecyclerView != null && this.mNestedScrolling && (parent = this.mRecyclerView.getParent()) instanceof View) {
                    this.mMeasuredFullSpace = Math.min(this.mMeasuredFullSpace, ((View)parent).getMeasuredHeight());
                }
            } else {
                this.mSpaceMeasuring = false;
            }
            this.mSpaceMeasuring = false;
            if (this.mRecyclerView != null && this.getItemCount() > 0) {
                this.mRecyclerView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (VirtualLayoutManager.this.mRecyclerView != null) {
                            VirtualLayoutManager.this.mRecyclerView.requestLayout();
                        }
                    }
                });
            }
        }
        if (Build.VERSION.SDK_INT >= 18) {
            Trace.endSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int scrollInternalBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (Build.VERSION.SDK_INT >= 18) {
            Trace.beginSection((String)TRACE_SCROLL);
        }
        this.runPreLayout(recycler, state);
        int scrolled = 0;
        try {
            if (!this.mNoScrolling) {
                scrolled = super.scrollInternalBy(dy, recycler, state);
            } else {
                if (this.getChildCount() == 0 || dy == 0) {
                    int n = 0;
                    return n;
                }
                this.mLayoutState.mRecycle = true;
                this.ensureLayoutStateExpose();
                int layoutDirection = dy > 0 ? 1 : -1;
                int absDy = Math.abs(dy);
                this.updateLayoutStateExpose(layoutDirection, absDy, true, state);
                int freeScroll = this.mLayoutState.mScrollingOffset;
                int consumed = freeScroll + this.fill(recycler, this.mLayoutState, state, false);
                if (consumed < 0) {
                    int n = 0;
                    return n;
                }
                scrolled = absDy > consumed ? layoutDirection * consumed : dy;
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)Log.getStackTraceString((Throwable)e), (Throwable)e);
            if (sDebuggable) {
                throw e;
            }
        }
        finally {
            this.runPostLayout(recycler, state, scrolled);
        }
        if (Build.VERSION.SDK_INT >= 18) {
            Trace.endSection();
        }
        return scrolled;
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        int startPosition = this.findFirstVisibleItemPosition();
        int endPosition = this.findLastVisibleItemPosition();
        List<LayoutHelper> layoutHelpers = this.mHelperFinder.getLayoutHelpers();
        Iterator<LayoutHelper> iterator = layoutHelpers.iterator();
        LayoutHelper layoutHelper = null;
        while (iterator.hasNext()) {
            layoutHelper = iterator.next();
            layoutHelper.onScrollStateChanged(state, startPosition, endPosition, this);
        }
    }

    public void offsetChildrenHorizontal(int dx) {
        super.offsetChildrenHorizontal(dx);
        List<LayoutHelper> layoutHelpers = this.mHelperFinder.getLayoutHelpers();
        Iterator<LayoutHelper> iterator = layoutHelpers.iterator();
        LayoutHelper layoutHelper = null;
        while (iterator.hasNext()) {
            layoutHelper = iterator.next();
            layoutHelper.onOffsetChildrenHorizontal(dx, this);
        }
    }

    public void offsetChildrenVertical(int dy) {
        super.offsetChildrenVertical(dy);
        List<LayoutHelper> layoutHelpers = this.mHelperFinder.getLayoutHelpers();
        Iterator<LayoutHelper> iterator = layoutHelpers.iterator();
        LayoutHelper layoutHelper = null;
        while (iterator.hasNext()) {
            layoutHelper = iterator.next();
            layoutHelper.onOffsetChildrenVertical(dy, this);
        }
        if (null != this.mViewLifeCycleHelper) {
            this.mViewLifeCycleHelper.checkViewStatusInScreen();
        }
    }

    public void setViewLifeCycleListener(@NonNull ViewLifeCycleListener viewLifeCycleListener) {
        if (null == viewLifeCycleListener) {
            throw new IllegalArgumentException("ViewLifeCycleListener should not be null!");
        }
        this.mViewLifeCycleHelper = new ViewLifeCycleHelper(this, viewLifeCycleListener);
    }

    public int getVirtualLayoutDirection() {
        return this.mLayoutState.mLayoutDirection;
    }

    @Nullable
    private int findRangeLength(@NonNull Range<Integer> range) {
        int count = this.mRangeLengths.size();
        if (count == 0) {
            return -1;
        }
        int s = 0;
        int e = count - 1;
        int m = -1;
        Pair<Range<Integer>, Integer> rs = null;
        while (s <= e) {
            m = (s + e) / 2;
            rs = this.mRangeLengths.get(m);
            Range r = (Range)rs.first;
            if (r == null) {
                rs = null;
                break;
            }
            if (r.contains(range.getLower()) || r.contains(range.getUpper()) || range.contains(r)) break;
            if ((Integer)r.getLower() > range.getUpper()) {
                e = m - 1;
            } else if ((Integer)r.getUpper() < range.getLower()) {
                s = m + 1;
            }
            rs = null;
        }
        return rs == null ? -1 : m;
    }

    @Override
    protected void layoutChunk(RecyclerView.Recycler recycler, RecyclerView.State state, ExposeLinearLayoutManagerEx.LayoutState layoutState, LayoutChunkResult result) {
        LayoutHelper layoutHelper;
        int position = layoutState.mCurrentPosition;
        this.mTempLayoutStateWrapper.mLayoutState = layoutState;
        LayoutHelper layoutHelper2 = layoutHelper = this.mHelperFinder == null ? null : this.mHelperFinder.getLayoutHelper(position);
        if (layoutHelper == null) {
            layoutHelper = this.mDefaultLayoutHelper;
        }
        layoutHelper.doLayout(recycler, state, this.mTempLayoutStateWrapper, result, this);
        this.mTempLayoutStateWrapper.mLayoutState = null;
        if (layoutState.mCurrentPosition == position) {
            if (sDebuggable) {
                Log.w((String)TAG, (String)("layoutHelper[" + layoutHelper.getClass().getSimpleName() + "@" + layoutHelper.toString() + "] consumes no item!"));
            }
            result.mFinished = true;
        } else {
            int positionAfterLayout = layoutState.mCurrentPosition - layoutState.mItemDirection;
            int consumed = result.mIgnoreConsumed ? 0 : result.mConsumed;
            Range<Integer> range = new Range<Integer>(Math.min(position, positionAfterLayout), Math.max(position, positionAfterLayout));
            int idx = this.findRangeLength(range);
            if (idx >= 0) {
                Pair<Range<Integer>, Integer> pair = this.mRangeLengths.get(idx);
                if (pair != null && ((Range)pair.first).equals(range) && (Integer)pair.second == consumed) {
                    return;
                }
                this.mRangeLengths.remove(idx);
            }
            this.mRangeLengths.add((Pair<Range<Integer>, Integer>)Pair.create(range, (Object)consumed));
            Collections.sort(this.mRangeLengths, this.mRangeComparator);
        }
    }

    public int getOffsetToStart() {
        if (this.getChildCount() == 0) {
            return -1;
        }
        View view = this.getChildAt(0);
        if (view == null) {
            return -1;
        }
        int position = this.getPosition(view);
        int idx = this.findRangeLength(Range.create(position, position));
        if (idx < 0 || idx >= this.mRangeLengths.size()) {
            return -1;
        }
        int offset = -this.mOrientationHelper.getDecoratedStart(view);
        for (int i = 0; i < idx; ++i) {
            Pair<Range<Integer>, Integer> pair = this.mRangeLengths.get(i);
            if (pair == null) continue;
            offset += ((Integer)pair.second).intValue();
        }
        return offset;
    }

    private void setDefaultLayoutHelper(@NonNull LayoutHelper layoutHelper) {
        if (layoutHelper == null) {
            throw new IllegalArgumentException("layoutHelper should not be null");
        }
        this.mDefaultLayoutHelper = layoutHelper;
    }

    @Override
    public void scrollToPosition(int position) {
        super.scrollToPosition(position);
    }

    @Override
    public void scrollToPositionWithOffset(int position, int offset) {
        super.scrollToPositionWithOffset(position, offset);
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        super.smoothScrollToPosition(recyclerView, state, position);
    }

    @Override
    public boolean supportsPredictiveItemAnimations() {
        return this.mCurrentPendingSavedState == null;
    }

    public void onItemsAdded(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.onItemsChanged(recyclerView);
    }

    public void onItemsRemoved(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.onItemsChanged(recyclerView);
    }

    public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.onItemsChanged(recyclerView);
    }

    public void onItemsMoved(RecyclerView recyclerView, int from, int to, int itemCount) {
        this.onItemsChanged(recyclerView);
    }

    public void onItemsChanged(RecyclerView recyclerView) {
        List<LayoutHelper> layoutHelpers = this.mHelperFinder.getLayoutHelpers();
        Iterator<LayoutHelper> iterator = layoutHelpers.iterator();
        LayoutHelper layoutHelper = null;
        while (iterator.hasNext()) {
            layoutHelper = iterator.next();
            layoutHelper.onItemsChanged(this);
        }
    }

    public boolean checkLayoutParams(RecyclerView.LayoutParams lp) {
        return lp instanceof LayoutParams;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public RecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (lp instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)lp);
        }
        if (lp instanceof RecyclerView.LayoutParams) {
            return new LayoutParams((RecyclerView.LayoutParams)lp);
        }
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    public RecyclerView.LayoutParams generateLayoutParams(Context c, AttributeSet attrs) {
        return new InflateLayoutParams(c, attrs);
    }

    public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
        super.onAdapterChanged(oldAdapter, newAdapter);
    }

    @Override
    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        this.mRecyclerView = view;
    }

    @Override
    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        List<LayoutHelper> layoutHelpers = this.mHelperFinder.getLayoutHelpers();
        Iterator<LayoutHelper> iterator = layoutHelpers.iterator();
        LayoutHelper layoutHelper = null;
        while (iterator.hasNext()) {
            layoutHelper = iterator.next();
            layoutHelper.clear(this);
        }
        this.mRecyclerView = null;
    }

    public List<View> getFixedViews() {
        if (this.mRecyclerView == null) {
            return Collections.emptyList();
        }
        LinkedList<View> views = new LinkedList<View>();
        List<LayoutHelper> layoutHelpers = this.mHelperFinder.getLayoutHelpers();
        Iterator<LayoutHelper> iterator = layoutHelpers.iterator();
        LayoutHelper layoutHelper = null;
        while (iterator.hasNext()) {
            layoutHelper = iterator.next();
            View fixedView = layoutHelper.getFixedView();
            if (fixedView == null) continue;
            views.add(fixedView);
        }
        return views;
    }

    public void setLayoutViewFactory(@NonNull LayoutViewFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory should not be null");
        }
        this.mLayoutViewFatory = factory;
    }

    @Override
    public final View generateLayoutView() {
        if (this.mRecyclerView == null) {
            return null;
        }
        View layoutView = this.mLayoutViewFatory.generateLayoutView(this.mRecyclerView.getContext());
        LayoutParams params = new LayoutParams(-2, -2);
        VirtualLayoutManager.attachViewHolder(params, new LayoutViewHolder(layoutView));
        layoutView.setLayoutParams((ViewGroup.LayoutParams)params);
        return layoutView;
    }

    @Override
    public void addChildView(View view, int index) {
        super.addView(view, index);
    }

    public void moveView(int fromIndex, int toIndex) {
        super.moveView(fromIndex, toIndex);
    }

    @Override
    public void addChildView(LayoutStateWrapper layoutState, View view) {
        this.addChildView(layoutState, view, layoutState.getItemDirection() == 1 ? -1 : 0);
    }

    @Override
    public void addChildView(LayoutStateWrapper layoutState, View view, int index) {
        this.showView(view);
        if (!layoutState.hasScrapList()) {
            this.addView(view, index);
        } else {
            this.addDisappearingView(view, index);
        }
    }

    @Override
    public void addOffFlowView(View view, boolean head) {
        this.showView(view);
        this.addHiddenView(view, head);
    }

    @Override
    public void addBackgroundView(View view, boolean head) {
        this.showView(view);
        int index = head ? 0 : -1;
        this.addView(view, index);
    }

    @Override
    public void addFixedView(View view) {
        this.addOffFlowView(view, false);
    }

    @Override
    public void hideView(View view) {
        super.hideView(view);
    }

    @Override
    public void showView(View view) {
        super.showView(view);
    }

    @Override
    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    @Override
    public RecyclerView.ViewHolder getChildViewHolder(View view) {
        if (this.mRecyclerView != null) {
            return this.mRecyclerView.getChildViewHolder(view);
        }
        return null;
    }

    @Override
    public boolean isViewHolderUpdated(View view) {
        RecyclerView.ViewHolder holder = this.getChildViewHolder(view);
        return holder == null || VirtualLayoutManager.isViewHolderUpdated(holder);
    }

    @Override
    public void removeChildView(View child) {
        this.removeView(child);
    }

    @Override
    public OrientationHelperEx getMainOrientationHelper() {
        return this.mOrientationHelper;
    }

    @Override
    public OrientationHelperEx getSecondaryOrientationHelper() {
        return this.mSecondaryOrientationHelper;
    }

    @Override
    public void measureChild(View child, int widthSpec, int heightSpec) {
        this.measureChildWithDecorations(child, widthSpec, heightSpec);
    }

    @Override
    public void measureChildWithMargins(View child, int widthUsed, int heightUsed) {
        this.measureChildWithDecorationsAndMargin(child, widthUsed, heightUsed);
    }

    @Override
    public int getChildMeasureSpec(int parentSize, int size, boolean canScroll) {
        return VirtualLayoutManager.getChildMeasureSpec((int)parentSize, (int)0, (int)size, (boolean)canScroll);
    }

    public boolean canScrollHorizontally() {
        boolean ret = true;
        if (this.layoutManagerCanScrollListener != null) {
            ret = ret && this.layoutManagerCanScrollListener.canScrollHorizontally();
        }
        return this.mCanScrollHorizontally && !this.mNoScrolling && ret;
    }

    public boolean canScrollVertically() {
        boolean ret = true;
        if (this.layoutManagerCanScrollListener != null) {
            ret = ret && this.layoutManagerCanScrollListener.canScrollVertically();
        }
        return this.mCanScrollVertically && !this.mNoScrolling && ret;
    }

    @Override
    public void layoutChildWithMargins(View child, int left, int top, int right, int bottom) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        if (this.mPerformanceMonitor != null) {
            this.mPerformanceMonitor.recordStart(PHASE_LAYOUT, child);
        }
        this.layoutDecorated(child, left + lp.leftMargin, top + lp.topMargin, right - lp.rightMargin, bottom - lp.bottomMargin);
        if (this.mPerformanceMonitor != null) {
            this.mPerformanceMonitor.recordEnd(PHASE_LAYOUT, child);
        }
    }

    @Override
    public void layoutChild(View child, int left, int top, int right, int bottom) {
        if (this.mPerformanceMonitor != null) {
            this.mPerformanceMonitor.recordStart(PHASE_LAYOUT, child);
        }
        this.layoutDecorated(child, left, top, right, bottom);
        if (this.mPerformanceMonitor != null) {
            this.mPerformanceMonitor.recordEnd(PHASE_LAYOUT, child);
        }
    }

    @Override
    protected void recycleChildren(RecyclerView.Recycler recycler, int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return;
        }
        if (sDebuggable) {
            Log.d((String)TAG, (String)("Recycling " + Math.abs(startIndex - endIndex) + " items"));
        }
        if (endIndex > startIndex) {
            View endView = this.getChildAt(endIndex - 1);
            View startView = this.getChildAt(startIndex);
            int startPos = this.getPosition(startView);
            int endPos = this.getPosition(endView);
            int idx = startIndex;
            for (int i = startIndex; i < endIndex; ++i) {
                View v = this.getChildAt(idx);
                int pos = this.getPosition(v);
                if (pos != -1) {
                    LayoutHelper layoutHelper = this.mHelperFinder.getLayoutHelper(pos);
                    if (layoutHelper == null || layoutHelper.isRecyclable(pos, startPos, endPos, this, true)) {
                        this.removeAndRecycleViewAt(idx, recycler);
                        continue;
                    }
                    ++idx;
                    continue;
                }
                this.removeAndRecycleViewAt(idx, recycler);
            }
        } else {
            View endView = this.getChildAt(startIndex);
            View startView = this.getChildAt(endIndex + 1);
            int startPos = this.getPosition(startView);
            int endPos = this.getPosition(endView);
            for (int i = startIndex; i > endIndex; --i) {
                View v = this.getChildAt(i);
                int pos = this.getPosition(v);
                if (pos != -1) {
                    LayoutHelper layoutHelper = this.mHelperFinder.getLayoutHelper(pos);
                    if (layoutHelper != null && !layoutHelper.isRecyclable(pos, startPos, endPos, this, false)) continue;
                    this.removeAndRecycleViewAt(i, recycler);
                    continue;
                }
                this.removeAndRecycleViewAt(i, recycler);
            }
        }
    }

    public void detachAndScrapAttachedViews(RecyclerView.Recycler recycler) {
        int childCount = this.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View v = this.getChildAt(i);
            RecyclerView.ViewHolder holder = this.getChildViewHolder(v);
            if (!(holder instanceof CacheViewHolder) || !((CacheViewHolder)holder).needCached()) continue;
            ExposeLinearLayoutManagerEx.ViewHolderWrapper.setFlags(holder, 0, 6);
        }
        super.detachAndScrapAttachedViews(recycler);
    }

    public void detachAndScrapViewAt(int index, RecyclerView.Recycler recycler) {
        View child = this.getChildAt(index);
        RecyclerView.ViewHolder holder = this.getChildViewHolder(child);
        if (holder instanceof CacheViewHolder && ((CacheViewHolder)holder).needCached()) {
            ExposeLinearLayoutManagerEx.ViewHolderWrapper.setFlags(holder, 0, 4);
        }
        super.detachAndScrapViewAt(index, recycler);
    }

    public void detachAndScrapView(View child, RecyclerView.Recycler recycler) {
        super.detachAndScrapView(child, recycler);
    }

    @Override
    public int getContentWidth() {
        return super.getWidth();
    }

    @Override
    public int getContentHeight() {
        return super.getHeight();
    }

    @Override
    public boolean isDoLayoutRTL() {
        return this.isLayoutRTL();
    }

    private void measureChildWithDecorations(View child, int widthSpec, int heightSpec) {
        this.calculateItemDecorationsForChild(child, this.mDecorInsets);
        widthSpec = this.updateSpecWithExtra(widthSpec, this.mDecorInsets.left, this.mDecorInsets.right);
        heightSpec = this.updateSpecWithExtra(heightSpec, this.mDecorInsets.top, this.mDecorInsets.bottom);
        if (this.mPerformanceMonitor != null) {
            this.mPerformanceMonitor.recordStart(PHASE_MEASURE, child);
        }
        child.measure(widthSpec, heightSpec);
        if (this.mPerformanceMonitor != null) {
            this.mPerformanceMonitor.recordEnd(PHASE_MEASURE, child);
        }
    }

    private void measureChildWithDecorationsAndMargin(View child, int widthSpec, int heightSpec) {
        this.calculateItemDecorationsForChild(child, this.mDecorInsets);
        RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
        if (this.getOrientation() == 1) {
            widthSpec = this.updateSpecWithExtra(widthSpec, lp.leftMargin + this.mDecorInsets.left, lp.rightMargin + this.mDecorInsets.right);
        }
        if (this.getOrientation() == 0) {
            heightSpec = this.updateSpecWithExtra(heightSpec, this.mDecorInsets.top, this.mDecorInsets.bottom);
        }
        if (this.mPerformanceMonitor != null) {
            this.mPerformanceMonitor.recordStart(PHASE_MEASURE, child);
        }
        child.measure(widthSpec, heightSpec);
        if (this.mPerformanceMonitor != null) {
            this.mPerformanceMonitor.recordEnd(PHASE_MEASURE, child);
        }
    }

    private int updateSpecWithExtra(int spec, int startInset, int endInset) {
        if (startInset == 0 && endInset == 0) {
            return spec;
        }
        int mode = View.MeasureSpec.getMode((int)spec);
        if (mode == Integer.MIN_VALUE || mode == 0x40000000) {
            int size = View.MeasureSpec.getSize((int)spec);
            if (size - startInset - endInset < 0) {
                return View.MeasureSpec.makeMeasureSpec((int)0, (int)mode);
            }
            return View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)spec) - startInset - endInset), (int)mode);
        }
        return spec;
    }

    @Override
    public View findViewByPosition(int position) {
        View view = super.findViewByPosition(position);
        if (view != null && this.getPosition(view) == position) {
            return view;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            view = this.getChildAt(i);
            if (view == null || this.getPosition(view) != position) continue;
            return view;
        }
        return null;
    }

    @Override
    public void recycleView(View view) {
        ViewParent parent;
        if (this.mRecyclerView != null && (parent = view.getParent()) != null && parent == this.mRecyclerView) {
            RecyclerView.ViewHolder holder = this.mRecyclerView.getChildViewHolder(view);
            this.mRecyclerView.getRecycledViewPool().putRecycledView(holder);
        }
    }

    @Override
    public LayoutHelper findLayoutHelperByPosition(int position) {
        return this.mHelperFinder.getLayoutHelper(position);
    }

    public void onMeasure(RecyclerView.Recycler recycler, RecyclerView.State state, int widthSpec, int heightSpec) {
        int measuredSize;
        if (!this.mNoScrolling && !this.mNestedScrolling) {
            super.onMeasure(recycler, state, widthSpec, heightSpec);
            return;
        }
        int initialSize = 0x7FFFFFF;
        if (this.mRecyclerView != null && this.mNestedScrolling) {
            if (this.mMaxMeasureSize > 0) {
                initialSize = this.mMaxMeasureSize;
            } else {
                ViewParent parent = this.mRecyclerView.getParent();
                if (parent instanceof View) {
                    initialSize = ((View)parent).getMeasuredHeight();
                }
            }
        }
        int n = measuredSize = this.mSpaceMeasured ? this.mMeasuredFullSpace : initialSize;
        if (this.mNoScrolling) {
            boolean bl = this.mSpaceMeasuring = !this.mSpaceMeasured;
            if (this.getChildCount() > 0 || this.getChildCount() != this.getItemCount()) {
                View lastChild = this.getChildAt(this.getChildCount() - 1);
                int bottom = this.mMeasuredFullSpace;
                if (lastChild != null) {
                    RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)lastChild.getLayoutParams();
                    bottom = this.getDecoratedBottom(lastChild) + params.bottomMargin + this.computeAlignOffset(lastChild, true, false);
                }
                if (this.getChildCount() != this.getItemCount() || lastChild != null && bottom != this.mMeasuredFullSpace) {
                    measuredSize = 0x7FFFFFF;
                    this.mSpaceMeasured = false;
                    this.mSpaceMeasuring = true;
                }
            } else if (this.getItemCount() == 0) {
                measuredSize = 0;
                this.mSpaceMeasured = true;
                this.mSpaceMeasuring = false;
            }
        }
        if (this.getOrientation() == 1) {
            super.onMeasure(recycler, state, widthSpec, View.MeasureSpec.makeMeasureSpec((int)measuredSize, (int)Integer.MIN_VALUE));
        } else {
            super.onMeasure(recycler, state, View.MeasureSpec.makeMeasureSpec((int)measuredSize, (int)Integer.MIN_VALUE), heightSpec);
        }
    }

    public static interface CacheViewHolder {
        public boolean needCached();
    }

    private static class LayoutViewHolder
    extends RecyclerView.ViewHolder {
        public LayoutViewHolder(View itemView) {
            super(itemView);
        }
    }

    public static class LayoutStateWrapper {
        public static final int LAYOUT_START = -1;
        public static final int LAYOUT_END = 1;
        static final int INVALID_LAYOUT = Integer.MIN_VALUE;
        public static final int ITEM_DIRECTION_HEAD = -1;
        public static final int ITEM_DIRECTION_TAIL = 1;
        static final int SCOLLING_OFFSET_NaN = Integer.MIN_VALUE;
        private ExposeLinearLayoutManagerEx.LayoutState mLayoutState;

        LayoutStateWrapper() {
        }

        LayoutStateWrapper(ExposeLinearLayoutManagerEx.LayoutState layoutState) {
            this.mLayoutState = layoutState;
        }

        public int getOffset() {
            return this.mLayoutState.mOffset;
        }

        public int getCurrentPosition() {
            return this.mLayoutState.mCurrentPosition;
        }

        public boolean hasScrapList() {
            return this.mLayoutState.mScrapList != null;
        }

        public void skipCurrentPosition() {
            this.mLayoutState.mCurrentPosition += this.mLayoutState.mItemDirection;
        }

        public boolean isRecycle() {
            return this.mLayoutState.mRecycle;
        }

        public boolean isRefreshLayout() {
            return this.mLayoutState.mOnRefresLayout;
        }

        public int getAvailable() {
            return this.mLayoutState.mAvailable;
        }

        public int getItemDirection() {
            return this.mLayoutState.mItemDirection;
        }

        public int getLayoutDirection() {
            return this.mLayoutState.mLayoutDirection;
        }

        public int getScrollingOffset() {
            return this.mLayoutState.mScrollingOffset;
        }

        public int getExtra() {
            return this.mLayoutState.mExtra;
        }

        public boolean isPreLayout() {
            return this.mLayoutState.mIsPreLayout;
        }

        public boolean hasMore(RecyclerView.State state) {
            return this.mLayoutState.hasMore(state);
        }

        public View next(RecyclerView.Recycler recycler) {
            View next = this.mLayoutState.next(recycler);
            return next;
        }

        public View retrieve(RecyclerView.Recycler recycler, int position) {
            int originPosition = this.mLayoutState.mCurrentPosition;
            this.mLayoutState.mCurrentPosition = position;
            View view = this.next(recycler);
            this.mLayoutState.mCurrentPosition = originPosition;
            return view;
        }
    }

    public static class AnchorInfoWrapper {
        public int position;
        public int coordinate;
        public boolean layoutFromEnd;

        AnchorInfoWrapper() {
        }
    }

    public static class InflateLayoutParams
    extends LayoutParams {
        public InflateLayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }
    }

    public static class LayoutParams
    extends RecyclerView.LayoutParams {
        public static final int INVALIDE_SIZE = Integer.MIN_VALUE;
        public int zIndex = 0;
        public float mAspectRatio = Float.NaN;
        private int mOriginWidth = Integer.MIN_VALUE;
        private int mOriginHeight = Integer.MIN_VALUE;

        public void storeOriginWidth() {
            if (this.mOriginWidth == Integer.MIN_VALUE) {
                this.mOriginWidth = this.width;
            }
        }

        public void storeOriginHeight() {
            if (this.mOriginHeight == Integer.MIN_VALUE) {
                this.mOriginHeight = this.height;
            }
        }

        public void restoreOriginWidth() {
            if (this.mOriginWidth != Integer.MIN_VALUE) {
                this.width = this.mOriginWidth;
            }
        }

        public void restoreOriginHeight() {
            if (this.mOriginHeight != Integer.MIN_VALUE) {
                this.height = this.mOriginHeight;
            }
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(RecyclerView.LayoutParams source) {
            super(source);
        }
    }
}

