/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.MismatchChildCountException;
import com.alibaba.android.vlayout.Range;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;
import java.util.LinkedList;
import java.util.List;

public abstract class LayoutHelper {
    public static final Range<Integer> RANGE_ALL = Range.create(Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final Range<Integer> RANGE_EMPTY = Range.create(-1, -1);
    @NonNull
    Range<Integer> mRange = RANGE_EMPTY;
    int mZIndex = 0;
    @NonNull
    protected final List<View> mOffFlowViews = new LinkedList<View>();

    public boolean isOutOfRange(int position) {
        return !this.mRange.contains(position);
    }

    public void setRange(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end should be larger or equeal then start position");
        }
        if (start == -1 && end == -1) {
            this.mRange = RANGE_EMPTY;
            this.onRangeChange(start, end);
            return;
        }
        if (end - start + 1 != this.getItemCount()) {
            throw new MismatchChildCountException("ItemCount mismatch when range: " + this.mRange.toString() + " childCount: " + this.getItemCount());
        }
        if (start == this.mRange.getUpper() && end == this.mRange.getLower()) {
            return;
        }
        this.mRange = Range.create(start, end);
        this.onRangeChange(start, end);
    }

    public void onRangeChange(int start, int end) {
    }

    @NonNull
    public final Range<Integer> getRange() {
        return this.mRange;
    }

    public void checkAnchorInfo(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfo, LayoutManagerHelper helper) {
    }

    public void onScrollStateChanged(int state, int startPosition, int endPosition, LayoutManagerHelper helper) {
    }

    public void onOffsetChildrenHorizontal(int dx, LayoutManagerHelper helper) {
    }

    public void onOffsetChildrenVertical(int dy, LayoutManagerHelper helper) {
    }

    public int getZIndex() {
        return this.mZIndex;
    }

    public void setZIndex(int zIndex) {
        this.mZIndex = zIndex;
    }

    @Nullable
    public View getFixedView() {
        return null;
    }

    @NonNull
    public List<View> getOffFlowViews() {
        return this.mOffFlowViews;
    }

    public boolean isRecyclable(int childPos, int startIndex, int endIndex, LayoutManagerHelper helper, boolean fromStart) {
        return true;
    }

    public abstract int getItemCount();

    public abstract void setItemCount(int var1);

    public abstract void doLayout(RecyclerView.Recycler var1, RecyclerView.State var2, VirtualLayoutManager.LayoutStateWrapper var3, LayoutChunkResult var4, LayoutManagerHelper var5);

    public void onRefreshLayout(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfo, LayoutManagerHelper helper) {
    }

    public abstract void beforeLayout(RecyclerView.Recycler var1, RecyclerView.State var2, LayoutManagerHelper var3);

    public abstract void afterLayout(RecyclerView.Recycler var1, RecyclerView.State var2, int var3, int var4, int var5, LayoutManagerHelper var6);

    public abstract void adjustLayout(int var1, int var2, LayoutManagerHelper var3);

    public void onItemsChanged(LayoutManagerHelper helper) {
    }

    public abstract void clear(LayoutManagerHelper var1);

    public abstract boolean requireLayoutView();

    public abstract void bindLayoutView(View var1);

    public abstract boolean isFixLayout();

    public abstract int computeAlignOffset(int var1, boolean var2, boolean var3, LayoutManagerHelper var4);

    public abstract int computeMarginStart(int var1, boolean var2, boolean var3, LayoutManagerHelper var4);

    public abstract int computeMarginEnd(int var1, boolean var2, boolean var3, LayoutManagerHelper var4);

    public abstract int computePaddingStart(int var1, boolean var2, boolean var3, LayoutManagerHelper var4);

    public abstract int computePaddingEnd(int var1, boolean var2, boolean var3, LayoutManagerHelper var4);

    public void onSaveState(Bundle bundle) {
    }

    public void onRestoreInstanceState(Bundle bundle) {
    }
}

