/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClient;
import com.algolia.search.APIClientBuilder;
import com.algolia.search.APIClientConfiguration;
import com.algolia.search.ApacheHttpClient;
import com.algolia.search.ApacheHttpClientConfiguration;
import com.algolia.search.GenericAPIClientBuilder;
import com.algolia.search.http.AlgoliaHttpClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;

public final class ApacheAPIClientBuilder
extends APIClientBuilder {
    private ApacheHttpClientConfiguration httpClientConfiguration = new ApacheHttpClientConfiguration();

    public ApacheAPIClientBuilder(@Nonnull String applicationId, @Nonnull String apiKey) {
        super(applicationId, apiKey);
    }

    public ApacheAPIClientBuilder setUserAgent(@Nonnull String customAgent, @Nonnull String customAgentVersion) {
        super.setUserAgent(customAgent, customAgentVersion);
        return this;
    }

    @Deprecated
    public ApacheAPIClientBuilder setExtraHeader(@Nonnull String key, String value) {
        super.setExtraHeader(key, value);
        return this;
    }

    public ApacheAPIClientBuilder addExtraHeader(@Nonnull String key, String value) {
        super.addExtraHeader(key, value);
        return this;
    }

    public ApacheAPIClientBuilder setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    public ApacheAPIClientBuilder setReadTimeout(int readTimeout) {
        super.setReadTimeout(readTimeout);
        return this;
    }

    public ApacheAPIClientBuilder setHostDownTimeout(int hostDownTimeout) {
        super.setHostDownTimeout(hostDownTimeout);
        return this;
    }

    public ApacheAPIClientBuilder setObjectMapper(@Nonnull ObjectMapper objectMapper) {
        super.setObjectMapper(objectMapper);
        return this;
    }

    public ApacheAPIClientBuilder setQueryHosts(List<String> queryHosts) {
        super.setQueryHosts(queryHosts);
        return this;
    }

    public ApacheAPIClientBuilder setBuildHosts(List<String> buildHosts) {
        super.setBuildHosts(buildHosts);
        return this;
    }

    public ApacheAPIClientBuilder setMaxConnTotal(int maxConnTotal) {
        super.setMaxConnTotal(maxConnTotal);
        return this;
    }

    public GenericAPIClientBuilder setMaxConnPerRoute(int maxConnPerRoute) {
        super.setMaxConnPerRoute(maxConnPerRoute);
        return this;
    }

    public ApacheAPIClientBuilder setProxy(HttpHost proxy) {
        this.httpClientConfiguration.setProxy(proxy);
        return this;
    }

    public ApacheAPIClientBuilder setProxyPreferredAuthSchemes(Collection<String> proxyPreferredAuthSchemes) {
        this.httpClientConfiguration.setProxyPreferredAuthSchemes(proxyPreferredAuthSchemes);
        return this;
    }

    public ApacheAPIClientBuilder setDefaultCredentialsProvider(CredentialsProvider defaultCredentialsProvider) {
        this.httpClientConfiguration.setDefaultCredentialsProvider(defaultCredentialsProvider);
        return this;
    }

    protected APIClient build(@Nonnull APIClientConfiguration configuration) {
        return new APIClient((AlgoliaHttpClient)new ApacheHttpClient(configuration, this.httpClientConfiguration), configuration);
    }
}

