/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.saas;

import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.Index;
import com.algolia.search.saas.Query;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class APIClient {
    private int httpSocketTimeoutMS = 30000;
    private int httpConnectTimeoutMS = 2000;
    private int httpSearchTimeoutMS = 5000;
    private static final String version;
    private final String applicationID;
    private final String apiKey;
    private final List<String> buildHostsArray;
    private final List<String> queryHostsArray;
    private final HttpClient httpClient;
    private String forwardRateLimitAPIKey = null;
    private String forwardEndUserIP = null;
    private String forwardAdminAPIKey = null;
    private HashMap<String, String> headers;

    public APIClient(String applicationID, String apiKey) {
        this(applicationID, apiKey, Arrays.asList(applicationID + "-1.algolianet.com", applicationID + "-2.algolianet.com", applicationID + "-3.algolianet.com"));
        this.buildHostsArray.add(0, applicationID + ".algolia.net");
        this.queryHostsArray.add(0, applicationID + "-dsn.algolia.net");
    }

    public APIClient(String applicationID, String apiKey, List<String> hostsArray) {
        this(applicationID, apiKey, hostsArray, hostsArray);
    }

    public APIClient(String applicationID, String apiKey, List<String> buildHostsArray, List<String> queryHostArray) {
        if (applicationID == null || applicationID.length() == 0) {
            throw new RuntimeException("AlgoliaSearch requires an applicationID.");
        }
        this.applicationID = applicationID;
        if (apiKey == null || apiKey.length() == 0) {
            throw new RuntimeException("AlgoliaSearch requires an apiKey.");
        }
        this.apiKey = apiKey;
        if (buildHostsArray == null || buildHostsArray.size() == 0 || queryHostArray == null || queryHostArray.size() == 0) {
            throw new RuntimeException("AlgoliaSearch requires a list of hostnames.");
        }
        this.buildHostsArray = new ArrayList<String>(buildHostsArray);
        this.queryHostsArray = new ArrayList<String>(queryHostArray);
        this.httpClient = HttpClientBuilder.create().disableAutomaticRetries().build();
        this.headers = new HashMap();
    }

    public void enableRateLimitForward(String adminAPIKey, String endUserIP, String rateLimitAPIKey) {
        this.forwardAdminAPIKey = adminAPIKey;
        this.forwardEndUserIP = endUserIP;
        this.forwardRateLimitAPIKey = rateLimitAPIKey;
    }

    public void disableRateLimitForward() {
        this.forwardRateLimitAPIKey = null;
        this.forwardEndUserIP = null;
        this.forwardAdminAPIKey = null;
    }

    public void setExtraHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setTimeout(int connectTimeout, int readTimeout) {
        this.httpSocketTimeoutMS = readTimeout;
        this.httpConnectTimeoutMS = connectTimeout;
    }

    public JSONObject listIndexes() throws AlgoliaException {
        return this.getRequest("/1/indexes/", false);
    }

    public JSONObject deleteIndex(String indexName) throws AlgoliaException {
        try {
            return this.deleteRequest("/1/indexes/" + URLEncoder.encode(indexName, "UTF-8"), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject moveIndex(String srcIndexName, String dstIndexName) throws AlgoliaException {
        try {
            JSONObject content = new JSONObject();
            content.put("operation", (Object)"move");
            content.put("destination", (Object)dstIndexName);
            return this.postRequest("/1/indexes/" + URLEncoder.encode(srcIndexName, "UTF-8") + "/operation", content.toString(), true, false);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject copyIndex(String srcIndexName, String dstIndexName) throws AlgoliaException {
        try {
            JSONObject content = new JSONObject();
            content.put("operation", (Object)"copy");
            content.put("destination", (Object)dstIndexName);
            return this.postRequest("/1/indexes/" + URLEncoder.encode(srcIndexName, "UTF-8") + "/operation", content.toString(), true, false);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject getLogs() throws AlgoliaException {
        return this.getRequest("/1/logs", false);
    }

    public JSONObject getLogs(int offset, int length) throws AlgoliaException {
        return this.getLogs(offset, length, LogType.LOG_ALL);
    }

    public JSONObject getLogs(int offset, int length, boolean onlyErrors) throws AlgoliaException {
        return this.getLogs(offset, length, onlyErrors ? LogType.LOG_ERROR : LogType.LOG_ALL);
    }

    public JSONObject getLogs(int offset, int length, LogType logType) throws AlgoliaException {
        String type = null;
        switch (logType) {
            case LOG_BUILD: {
                type = "build";
                break;
            }
            case LOG_QUERY: {
                type = "query";
                break;
            }
            case LOG_ERROR: {
                type = "error";
                break;
            }
            case LOG_ALL: {
                type = "all";
            }
        }
        return this.getRequest("/1/logs?offset=" + offset + "&length=" + length + "&type=" + type, false);
    }

    public Index initIndex(String indexName) {
        return new Index(this, indexName);
    }

    public JSONObject listUserKeys() throws AlgoliaException {
        return this.getRequest("/1/keys", false);
    }

    public JSONObject getUserKeyACL(String key) throws AlgoliaException {
        return this.getRequest("/1/keys/" + key, false);
    }

    public JSONObject deleteUserKey(String key) throws AlgoliaException {
        return this.deleteRequest("/1/keys/" + key, true);
    }

    public JSONObject addUserKey(JSONObject params) throws AlgoliaException {
        return this.postRequest("/1/keys", params.toString(), true, false);
    }

    public JSONObject addUserKey(List<String> acls) throws AlgoliaException {
        return this.addUserKey(acls, 0, 0, 0, null);
    }

    public JSONObject updateUserKey(String key, JSONObject params) throws AlgoliaException {
        return this.putRequest("/1/keys/" + key, params.toString(), true);
    }

    public JSONObject updateUserKey(String key, List<String> acls) throws AlgoliaException {
        return this.updateUserKey(key, acls, 0, 0, 0, null);
    }

    public JSONObject addUserKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        return this.addUserKey(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, null);
    }

    public JSONObject updateUserKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        return this.updateUserKey(key, acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, null);
    }

    public JSONObject addUserKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, List<String> indexes) throws AlgoliaException {
        JSONArray array = new JSONArray(acls);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("acl", (Object)array);
            jsonObject.put("validity", validity);
            jsonObject.put("maxQueriesPerIPPerHour", maxQueriesPerIPPerHour);
            jsonObject.put("maxHitsPerQuery", maxHitsPerQuery);
            if (indexes != null) {
                jsonObject.put("indexes", (Object)new JSONArray(indexes));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return this.addUserKey(jsonObject);
    }

    public JSONObject updateUserKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, List<String> indexes) throws AlgoliaException {
        JSONArray array = new JSONArray(acls);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("acl", (Object)array);
            jsonObject.put("validity", validity);
            jsonObject.put("maxQueriesPerIPPerHour", maxQueriesPerIPPerHour);
            jsonObject.put("maxHitsPerQuery", maxHitsPerQuery);
            if (indexes != null) {
                jsonObject.put("indexes", (Object)new JSONArray(indexes));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return this.updateUserKey(key, jsonObject);
    }

    public String generateSecuredApiKey(String privateApiKey, String tagFilters) throws NoSuchAlgorithmException, InvalidKeyException {
        return this.generateSecuredApiKey(privateApiKey, tagFilters, null);
    }

    public String generateSecuredApiKey(String privateApiKey, Query query) throws NoSuchAlgorithmException, InvalidKeyException {
        return this.generateSecuredApiKey(privateApiKey, query.toString(), null);
    }

    public String generateSecuredApiKey(String privateApiKey, String tagFilters, String userToken) throws NoSuchAlgorithmException, InvalidKeyException {
        return APIClient.hmac(privateApiKey, tagFilters + (userToken != null ? userToken : ""));
    }

    public String generateSecuredApiKey(String privateApiKey, Query query, String userToken) throws NoSuchAlgorithmException, InvalidKeyException {
        return APIClient.hmac(privateApiKey, query.toString() + (userToken != null ? userToken : ""));
    }

    static String hmac(String key, String msg) {
        Mac hmac;
        try {
            hmac = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        try {
            hmac.init(new SecretKeySpec(key.getBytes(), "HmacSHA256"));
        }
        catch (InvalidKeyException e) {
            throw new Error(e);
        }
        byte[] rawHmac = hmac.doFinal(msg.getBytes());
        byte[] hexBytes = new Hex().encode(rawHmac);
        return new String(hexBytes);
    }

    protected JSONObject getRequest(String url, boolean search) throws AlgoliaException {
        return this._request(Method.GET, url, null, false, search);
    }

    protected JSONObject deleteRequest(String url, boolean build) throws AlgoliaException {
        return this._request(Method.DELETE, url, null, build, false);
    }

    protected JSONObject postRequest(String url, String obj, boolean build, boolean search) throws AlgoliaException {
        return this._request(Method.POST, url, obj, build, search);
    }

    protected JSONObject putRequest(String url, String obj, boolean build) throws AlgoliaException {
        return this._request(Method.PUT, url, obj, build, false);
    }

    private JSONObject _requestByHost(HttpRequestBase req, String host, String url, String json, HashMap<String, String> errors, boolean searchTimeout) throws AlgoliaException {
        HttpResponse response;
        req.reset();
        try {
            req.setURI(new URI("https://" + host + url));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        req.setHeader("X-Algolia-Application-Id", this.applicationID);
        if (this.forwardAdminAPIKey == null) {
            req.setHeader("X-Algolia-API-Key", this.apiKey);
        } else {
            req.setHeader("X-Algolia-API-Key", this.forwardAdminAPIKey);
            req.setHeader("X-Forwarded-For", this.forwardEndUserIP);
            req.setHeader("X-Forwarded-API-Key", this.forwardRateLimitAPIKey);
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            req.setHeader(entry.getKey(), entry.getValue());
        }
        req.setHeader("User-Agent", "Algolia for Java " + version);
        if (json != null) {
            if (!(req instanceof HttpEntityEnclosingRequestBase)) {
                throw new IllegalArgumentException("Method " + req.getMethod() + " cannot enclose entity");
            }
            req.setHeader("Content-type", "application/json");
            try {
                StringEntity se = new StringEntity(json, "UTF-8");
                se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
                ((HttpEntityEnclosingRequestBase)req).setEntity((HttpEntity)se);
            }
            catch (UnsupportedEncodingException e) {
                throw new AlgoliaException("Invalid JSON Object: " + json);
            }
        }
        RequestConfig config = RequestConfig.custom().setSocketTimeout(searchTimeout ? this.httpSearchTimeoutMS : this.httpSocketTimeoutMS).setConnectTimeout(this.httpConnectTimeoutMS).setConnectionRequestTimeout(this.httpConnectTimeoutMS).build();
        req.setConfig(config);
        try {
            response = this.httpClient.execute((HttpUriRequest)req);
        }
        catch (IOException e) {
            errors.put(host, String.format("%s=%s", e.getClass().getName(), e.getMessage()));
            return null;
        }
        try {
            int code = response.getStatusLine().getStatusCode();
            if (code / 100 == 4) {
                String message = "";
                try {
                    message = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (code == 400) {
                    throw new AlgoliaException(code, message.length() > 0 ? message : "Bad request");
                }
                if (code == 403) {
                    throw new AlgoliaException(code, message.length() > 0 ? message : "Invalid Application-ID or API-Key");
                }
                if (code == 404) {
                    throw new AlgoliaException(code, message.length() > 0 ? message : "Resource does not exist");
                }
                throw new AlgoliaException(code, message.length() > 0 ? message : "Error");
            }
            if (code / 100 != 2) {
                try {
                    errors.put(host, EntityUtils.toString((HttpEntity)response.getEntity()));
                }
                catch (IOException e) {
                    errors.put(host, String.valueOf(code));
                }
                JSONObject e = null;
                return e;
            }
            InputStream istream = response.getEntity().getContent();
            InputStreamReader is = new InputStreamReader(istream, "UTF-8");
            JSONTokener tokener = new JSONTokener((Reader)is);
            JSONObject res = new JSONObject(tokener);
            is.close();
            JSONObject jSONObject = res;
            return jSONObject;
        }
        finally {
            req.releaseConnection();
        }
    }

    private JSONObject _request(Method m, String url, String json, boolean build, boolean search) throws AlgoliaException {
        HttpDelete req;
        switch (m) {
            case DELETE: {
                req = new HttpDelete();
                break;
            }
            case GET: {
                req = new HttpGet();
                break;
            }
            case POST: {
                req = new HttpPost();
                break;
            }
            case PUT: {
                req = new HttpPut();
                break;
            }
            default: {
                throw new IllegalArgumentException("Method " + (Object)((Object)m) + " is not supported");
            }
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        List<String> hosts = build ? this.buildHostsArray : this.queryHostsArray;
        for (int i = 0; i < hosts.size(); ++i) {
            String host = hosts.get(i);
            JSONObject res = this._requestByHost((HttpRequestBase)req, host, url, json, errors, search);
            if (res == null) continue;
            return res;
        }
        StringBuilder builder = new StringBuilder("Hosts unreachable: ");
        Boolean first = true;
        for (Map.Entry entry : errors.entrySet()) {
            if (!first.booleanValue()) {
                builder.append(", ");
            }
            builder.append(entry.toString());
            first = false;
        }
        throw new AlgoliaException(builder.toString());
    }

    public JSONObject multipleQueries(List<IndexQuery> queries) throws AlgoliaException {
        return this.multipleQueries(queries, "none");
    }

    public JSONObject multipleQueries(List<IndexQuery> queries, String strategy) throws AlgoliaException {
        try {
            JSONArray requests = new JSONArray();
            for (IndexQuery indexQuery : queries) {
                String paramsString = indexQuery.getQuery().getQueryString();
                requests.put((Object)new JSONObject().put("indexName", (Object)indexQuery.getIndex()).put("params", (Object)paramsString));
            }
            JSONObject body = new JSONObject().put("requests", (Object)requests);
            return this.postRequest("/1/indexes/*/queries?strategy=" + strategy, body.toString(), false, true);
        }
        catch (JSONException e) {
            new AlgoliaException(e.getMessage());
            return null;
        }
    }

    public JSONObject batch(JSONArray actions) throws AlgoliaException {
        try {
            JSONObject content = new JSONObject();
            content.put("requests", (Object)actions);
            return this.postRequest("/1/indexes/*/batch", content.toString(), true, false);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject batch(List<JSONObject> actions) throws AlgoliaException {
        try {
            JSONObject content = new JSONObject();
            content.put("requests", actions);
            return this.postRequest("/1/indexes/*/batch", content.toString(), true, false);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    static {
        String tmp = "N/A";
        try {
            InputStream versionStream = APIClient.class.getResourceAsStream("/version.properties");
            if (versionStream != null) {
                BufferedReader versionReader = new BufferedReader(new InputStreamReader(versionStream));
                tmp = versionReader.readLine();
                versionReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        version = tmp;
    }

    public static class IndexQuery {
        private String index;
        private Query query;

        public IndexQuery(String index, Query q) {
            this.index = index;
            this.query = q;
        }

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public Query getQuery() {
            return this.query;
        }

        public void setQuery(Query query) {
            this.query = query;
        }
    }

    private static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        TRACE,
        HEAD;

    }

    public static enum LogType {
        LOG_QUERY,
        LOG_BUILD,
        LOG_ERROR,
        LOG_ALL;

    }
}

