/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.util;

import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public class AlgoliaUtils {
    public static Boolean isEmptyWhiteSpace(String stringToCheck) {
        return stringToCheck.trim().length() == 0;
    }

    public static Boolean isNullOrEmptyWhiteSpace(String stringToCheck) {
        return stringToCheck == null || stringToCheck.trim().length() == 0;
    }

    public static <T> void ensureObjectID(@Nonnull Class<T> clazz) {
        Field objectIDField = AlgoliaUtils.getField(clazz, "objectID");
        Optional<Field> optObjectIDField = AlgoliaUtils.findObjectIDInAnnotation(clazz);
        if (objectIDField == null && !optObjectIDField.isPresent()) {
            throw new AlgoliaRuntimeException("The " + clazz + " must have an objectID property or a Jackson annotation @JsonProperty(\"objectID\")");
        }
    }

    public static <T> String getObjectID(@Nonnull T data, @Nonnull Class<T> clazz) {
        String objectID = null;
        try {
            Field objectIDField = AlgoliaUtils.getField(clazz, "objectID");
            if (objectIDField != null) {
                objectID = (String)objectIDField.get(data);
            }
        }
        catch (IllegalAccessException objectIDField) {
            // empty catch block
        }
        if (objectID != null) {
            return objectID;
        }
        Optional<Field> optObjectIDField = AlgoliaUtils.findObjectIDInAnnotation(clazz);
        if (optObjectIDField.isPresent()) {
            Field objectIDField = optObjectIDField.get();
            try {
                objectIDField.setAccessible(true);
                objectID = (String)objectIDField.get(data);
                if (objectID != null) {
                    return objectID;
                }
            }
            catch (IllegalAccessException ignored) {
                throw new AlgoliaRuntimeException("Can't access the ObjectID field.");
            }
        }
        throw new AlgoliaRuntimeException("The " + clazz + " must have an objectID property or a Jackson annotation @JsonProperty(\"objectID\")");
    }

    private static Optional<Field> findObjectIDInAnnotation(@Nonnull Class<?> clazz) {
        List<Field> fields = AlgoliaUtils.getFields(clazz);
        return fields.stream().filter(f -> f.getAnnotation(JsonProperty.class) != null && f.getAnnotation(JsonProperty.class).value().equals("objectID")).findFirst();
    }

    private static Field getField(@Nonnull Class<?> clazz, @Nonnull String fieldName) {
        Class<?> tmpClass = clazz;
        while (true) {
            try {
                Field f = tmpClass.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException e) {
                if ((tmpClass = tmpClass.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }

    private static List<Field> getFields(@Nonnull Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> i = clazz; i != null && i != Object.class; i = i.getSuperclass()) {
            Collections.addAll(result, i.getDeclaredFields());
        }
        return result;
    }
}

