/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SearchIndexBase;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.indexing.Query;
import com.algolia.search.models.indexing.SearchForFacetRequest;
import com.algolia.search.models.indexing.SearchForFacetResponse;
import com.algolia.search.models.indexing.SearchResult;
import com.algolia.search.util.AlgoliaUtils;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public interface SearchIndexSearching<T>
extends SearchIndexBase<T> {
    default public SearchResult<T> search(@Nonnull Query query) {
        return LaunderThrowable.await(this.searchAsync(query));
    }

    default public SearchResult<T> search(@Nonnull Query query, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.searchAsync(query, requestOptions));
    }

    default public CompletableFuture<SearchResult<T>> searchAsync(@Nonnull Query query) {
        return this.searchAsync(query, null);
    }

    default public CompletableFuture<SearchResult<T>> searchAsync(@Nonnull Query query, RequestOptions requestOptions) {
        Objects.requireNonNull(query, "A query key is required.");
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.getUrlEncodedIndexName() + "/query", CallType.READ, query, SearchResult.class, this.getClazz(), requestOptions).thenComposeAsync(resp -> {
            CompletableFuture<SearchResult> r = new CompletableFuture<SearchResult>();
            r.complete((SearchResult)resp);
            return r;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public SearchForFacetResponse searchForFacetValues(@Nonnull SearchForFacetRequest query) {
        return LaunderThrowable.await(this.searchForFacetValuesAsync(query));
    }

    default public SearchForFacetResponse searchForFacetValues(@Nonnull SearchForFacetRequest query, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.searchForFacetValuesAsync(query, requestOptions));
    }

    default public CompletableFuture<SearchForFacetResponse> searchForFacetValuesAsync(@Nonnull SearchForFacetRequest query) {
        return this.searchForFacetValuesAsync(query, null);
    }

    default public CompletableFuture<SearchForFacetResponse> searchForFacetValuesAsync(@Nonnull SearchForFacetRequest query, RequestOptions requestOptions) {
        Objects.requireNonNull(query, "query is required.");
        if (AlgoliaUtils.isNullOrEmptyWhiteSpace(query.getFacetName()).booleanValue()) {
            throw new AlgoliaRuntimeException("facetName must not be null, empty or white spaces.");
        }
        if (AlgoliaUtils.isNullOrEmptyWhiteSpace(query.getFacetQuery()).booleanValue()) {
            throw new AlgoliaRuntimeException("facetQuery must not be null, empty or white spaces.");
        }
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.getUrlEncodedIndexName() + "/facets/" + query.getFacetName() + "/query", CallType.READ, query, SearchForFacetResponse.class, requestOptions);
    }
}

