/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SearchClientBase;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.common.Log;
import com.algolia.search.models.common.LogType;
import com.algolia.search.models.common.Logs;
import com.algolia.search.models.indexing.IndicesResponse;
import com.algolia.search.models.indexing.ListIndicesResponse;
import com.algolia.search.util.AlgoliaUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public interface SearchClientAdvanced
extends SearchClientBase {
    default public List<IndicesResponse> listIndices() {
        return this.listIndices(null);
    }

    default public List<IndicesResponse> listIndices(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.listIndicesAsync(requestOptions));
    }

    default public CompletableFuture<List<IndicesResponse>> listIndicesAsync() {
        return this.listIndicesAsync(null);
    }

    default public CompletableFuture<List<IndicesResponse>> listIndicesAsync(RequestOptions requestOptions) {
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/indexes", CallType.READ, ListIndicesResponse.class, requestOptions).thenApplyAsync(ListIndicesResponse::getIndices, (Executor)this.getConfig().getExecutor());
    }

    default public List<Log> getLogs() {
        return LaunderThrowable.await(this.getLogsAsync(0, 10));
    }

    default public List<Log> getLogs(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getLogsAsync(requestOptions));
    }

    default public List<Log> getLogs(int offset, int length) {
        return LaunderThrowable.await(this.getLogsAsync(offset, length));
    }

    default public List<Log> getLogs(int offset, int length, @Nonnull String logType) {
        return LaunderThrowable.await(this.getLogsAsync(offset, length, logType));
    }

    default public List<Log> getLogs(int offset, int length, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getLogsAsync(offset, length, LogType.LOG_ALL.getName(), requestOptions));
    }

    default public CompletableFuture<List<Log>> getLogsAsync() {
        return this.getLogsAsync(0, 10);
    }

    default public CompletableFuture<List<Log>> getLogsAsync(int offset, int length) {
        return this.getLogsAsync(offset, length, LogType.LOG_ALL.getName());
    }

    default public CompletableFuture<List<Log>> getLogsAsync(int offset, int length, @Nonnull String logType) {
        return this.getLogsAsync(offset, length, logType, null);
    }

    default public CompletableFuture<List<Log>> getLogsAsync(RequestOptions requestOptions) {
        return this.getLogsAsync(0, 10, LogType.LOG_ALL.getName(), requestOptions);
    }

    default public CompletableFuture<List<Log>> getLogsAsync(int offset, int length, @Nonnull String logType, RequestOptions requestOptions) {
        if (AlgoliaUtils.isNullOrEmptyWhiteSpace(logType).booleanValue()) {
            throw new AlgoliaRuntimeException("logType can't be null, empty or whitespaces");
        }
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.addExtraQueryParameters("offset", Integer.toString(offset));
        requestOptions.addExtraQueryParameters("length", Integer.toString(length));
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/logs", CallType.READ, Logs.class, requestOptions).thenApplyAsync(Logs::getLogs, (Executor)this.getConfig().getExecutor());
    }

    default public <T, U> U customRequest(T data, Class<U> returnClazz, @Nonnull HttpMethod httpMethod, @Nonnull String path, @Nonnull CallType callType) {
        return LaunderThrowable.await(this.customRequestAsync(data, returnClazz, httpMethod, path, callType));
    }

    default public <T, U> U customRequest(T data, Class<U> returnClazz, @Nonnull HttpMethod httpMethod, @Nonnull String path, @Nonnull CallType callType, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.customRequestAsync(data, returnClazz, httpMethod, path, callType, requestOptions));
    }

    default public <U> U customRequest(Class<U> returnClazz, @Nonnull HttpMethod httpMethod, @Nonnull String path, @Nonnull CallType callType) {
        return LaunderThrowable.await(this.customRequestAsync(returnClazz, httpMethod, path, callType));
    }

    default public <U> U customRequest(Class<U> returnClazz, @Nonnull HttpMethod httpMethod, @Nonnull String path, @Nonnull CallType callType, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.customRequestAsync(returnClazz, httpMethod, path, callType, requestOptions));
    }

    default public <T, U> CompletableFuture<U> customRequestAsync(T data, Class<U> returnClazz, @Nonnull HttpMethod httpMethod, @Nonnull String path, @Nonnull CallType callType) {
        return this.customRequestAsync(data, returnClazz, httpMethod, path, callType, null);
    }

    default public <T, U> CompletableFuture<U> customRequestAsync(T data, Class<U> returnClazz, @Nonnull HttpMethod httpMethod, @Nonnull String path, @Nonnull CallType callType, RequestOptions requestOptions) {
        return this.getTransport().executeRequestAsync(httpMethod, path, callType, data, returnClazz, requestOptions);
    }

    default public <U> CompletableFuture<U> customRequestAsync(Class<U> returnClazz, @Nonnull HttpMethod httpMethod, @Nonnull String path, @Nonnull CallType callType) {
        return this.customRequestAsync(returnClazz, httpMethod, path, callType, null);
    }

    default public <U> CompletableFuture<U> customRequestAsync(Class<U> returnClazz, @Nonnull HttpMethod httpMethod, @Nonnull String path, @Nonnull CallType callType, RequestOptions requestOptions) {
        return this.getTransport().executeRequestAsync(httpMethod, path, callType, returnClazz, requestOptions);
    }
}

