/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.util;

import com.algolia.search.Defaults;
import com.algolia.search.models.apikeys.SecuredApiKeyRestriction;
import com.algolia.search.models.indexing.SearchParameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class QueryStringUtils {
    public static String urlEncodeUTF8(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String buildQueryString(Map<String, String> map, boolean withoutLeadingMark) {
        return withoutLeadingMark ? QueryStringUtils.buildString(map).orElse("") : QueryStringUtils.buildQueryString(map);
    }

    public static String buildQueryString(Map<String, String> map) {
        return QueryStringUtils.buildString(map).map(s -> "?" + s).orElse("");
    }

    public static String buildQueryAsQueryParams(SearchParameters query) {
        Map map = (Map)Defaults.getObjectMapper().convertValue((Object)query, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Map<String, String> newMap = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (e.getValue() instanceof List) {
                List tmpList = (List)e.getValue();
                if (tmpList.get(0) != null && tmpList.get(0) instanceof List) {
                    List listOfList = (List)e.getValue();
                    return "[" + listOfList.stream().map(arr -> "[" + arr.stream().map(QueryStringUtils::formatParameters).collect(Collectors.joining(",")) + "]").collect(Collectors.joining(",")) + "]";
                }
                return String.join((CharSequence)",", (List)e.getValue());
            }
            return String.valueOf(e.getValue());
        }));
        return QueryStringUtils.buildQueryString(newMap, true);
    }

    static String buildRestrictionQueryString(SecuredApiKeyRestriction restriction) {
        Map map = (Map)Defaults.getObjectMapper().convertValue((Object)restriction, (TypeReference)new TypeReference<Map<String, String>>(){});
        return QueryStringUtils.buildQueryString(map, true);
    }

    private static String formatParameters(Object parameter) {
        if (parameter instanceof Float) {
            return parameter.toString();
        }
        return "\"" + parameter.toString() + "\"";
    }

    private static Optional<String> buildString(Map<String, String> map) {
        return map.entrySet().stream().map(p -> QueryStringUtils.urlEncodeUTF8((String)p.getKey()) + "=" + QueryStringUtils.urlEncodeUTF8((String)p.getValue())).reduce((p1, p2) -> p1 + "&" + p2);
    }
}

