/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.models.indexing;

import com.algolia.search.models.indexing.AroundPrecision;
import com.algolia.search.models.indexing.AroundRadius;
import com.algolia.search.models.indexing.RemoveWordsType;
import com.algolia.search.models.settings.Distinct;
import com.algolia.search.models.settings.IgnorePlurals;
import com.algolia.search.models.settings.RemoveStopWords;
import com.algolia.search.models.settings.TypoTolerance;
import com.algolia.search.util.QueryStringUtils;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class SearchParameters<T extends SearchParameters<T>>
implements Serializable {
    @JsonProperty(value="query")
    protected String query;
    protected String similarQuery;
    protected Distinct distinct;
    protected Boolean getRankingInfo;
    protected List<List<String>> numericFilters;
    protected List<List<String>> tagFilters;
    protected Boolean clickAnalytics;
    protected Boolean analytics;
    protected List<String> analyticsTags;
    protected Boolean synonyms;
    protected Boolean replaceSynonymsInHighlight;
    protected Integer minProximity;
    protected List<String> responseFields;
    protected Long maxFacetHits;
    protected Boolean percentileComputation;
    protected List<String> queryLanguages;
    protected List<String> attributesToRetrieve;
    protected List<String> restrictSearchableAttributes;
    protected String filters;
    protected List<String> facets;
    protected Long maxValuesPerFacet;
    protected List<List<String>> facetFilters;
    protected List<List<String>> optionalFilters;
    protected Boolean facetingAfterDistinct;
    protected String sortFacetValuesBy;
    protected String aroundLatLng;
    protected Boolean aroundLatLngViaIP;
    protected AroundRadius aroundRadius;
    protected List<AroundPrecision> aroundPrecision;
    protected Integer minimumAroundRadius;
    protected List<List<Float>> insideBoundingBox;
    protected List<List<Float>> insidePolygon;
    protected List<String> attributesToHighlight;
    protected List<String> attributesToSnippet;
    protected String highlightPreTag;
    protected String highlightPostTag;
    protected String snippetEllipsisText;
    protected Boolean restrictHighlightAndSnippetArrays;
    protected Integer page;
    protected Integer hitsPerPage;
    protected Integer offset;
    protected Integer length;
    protected Boolean enableRules;
    protected List<String> ruleContexts;
    protected String queryType;
    protected RemoveWordsType removeWordsIfNoResults;
    protected Boolean advancedSyntax;
    protected List<String> advancedSyntaxFeatures;
    protected List<String> optionalWords;
    protected RemoveStopWords removeStopWords;
    protected List<String> disableExactOnAttributes;
    protected String exactOnSingleWordQuery;
    protected List<String> alternativesAsExact;
    protected Boolean sumOrFiltersScores;
    protected Integer minWordSizefor1Typo;
    protected Integer minWordSizefor2Typos;
    protected TypoTolerance typoTolerance;
    protected Boolean allowTyposOnNumericTokens;
    protected IgnorePlurals ignorePlurals;
    protected List<String> disableTypoToleranceOnAttributes;
    protected String userToken;
    protected Integer validUntil;
    protected List<String> restrictIndices;
    protected String restrictSources;
    protected Boolean enablePersonalization;
    protected Integer personalizationImpact;
    protected Map<String, Object> customParameters = new HashMap<String, Object>();

    @JsonIgnore
    public abstract T getThis();

    public String getQuery() {
        return this.query;
    }

    public T setQuery(String query) {
        this.query = query;
        return this.getThis();
    }

    public String getSimilarQuery() {
        return this.similarQuery;
    }

    public T setSimilarQuery(String similarQuery) {
        this.similarQuery = similarQuery;
        return this.getThis();
    }

    public Boolean getGetRankingInfo() {
        return this.getRankingInfo;
    }

    public T setGetRankingInfo(Boolean getRankingInfo) {
        this.getRankingInfo = getRankingInfo;
        return this.getThis();
    }

    public List<List<String>> getNumericFilters() {
        return this.numericFilters;
    }

    public T setNumericFilters(List<List<String>> numericFilters) {
        this.numericFilters = numericFilters;
        return this.getThis();
    }

    public List<List<String>> getTagFilters() {
        return this.tagFilters;
    }

    public T setTagFilters(List<List<String>> tagFilters) {
        this.tagFilters = tagFilters;
        return this.getThis();
    }

    public Boolean getClickAnalytics() {
        return this.clickAnalytics;
    }

    public T setClickAnalytics(Boolean clickAnalytics) {
        this.clickAnalytics = clickAnalytics;
        return this.getThis();
    }

    public Boolean getAnalytics() {
        return this.analytics;
    }

    public T setAnalytics(Boolean analytics) {
        this.analytics = analytics;
        return this.getThis();
    }

    public List<String> getAnalyticsTags() {
        return this.analyticsTags;
    }

    public T setAnalyticsTags(List<String> analyticsTags) {
        this.analyticsTags = analyticsTags;
        return this.getThis();
    }

    public Boolean getSynonyms() {
        return this.synonyms;
    }

    public T setSynonyms(Boolean synonyms) {
        this.synonyms = synonyms;
        return this.getThis();
    }

    public Boolean getReplaceSynonymsInHighlight() {
        return this.replaceSynonymsInHighlight;
    }

    public T setReplaceSynonymsInHighlight(Boolean replaceSynonymsInHighlight) {
        this.replaceSynonymsInHighlight = replaceSynonymsInHighlight;
        return this.getThis();
    }

    public Integer getMinProximity() {
        return this.minProximity;
    }

    public T setMinProximity(Integer minProximity) {
        this.minProximity = minProximity;
        return this.getThis();
    }

    public List<String> getResponseFields() {
        return this.responseFields;
    }

    public T setResponseFields(List<String> responseFields) {
        this.responseFields = responseFields;
        return this.getThis();
    }

    public Long getMaxFacetHits() {
        return this.maxFacetHits;
    }

    public T setMaxFacetHits(Long maxFacetHits) {
        this.maxFacetHits = maxFacetHits;
        return this.getThis();
    }

    public Boolean getPercentileComputation() {
        return this.percentileComputation;
    }

    public T setPercentileComputation(Boolean percentileComputation) {
        this.percentileComputation = percentileComputation;
        return this.getThis();
    }

    public List<String> getQueryLanguages() {
        return this.queryLanguages;
    }

    public T setQueryLanguages(List<String> queryLanguages) {
        this.queryLanguages = queryLanguages;
        return this.getThis();
    }

    public List<String> getAttributesToRetrieve() {
        return this.attributesToRetrieve;
    }

    public T setAttributesToRetrieve(List<String> attributesToRetrieve) {
        this.attributesToRetrieve = attributesToRetrieve;
        return this.getThis();
    }

    public List<String> getRestrictSearchableAttributes() {
        return this.restrictSearchableAttributes;
    }

    public T setRestrictSearchableAttributes(List<String> restrictSearchableAttributes) {
        this.restrictSearchableAttributes = restrictSearchableAttributes;
        return this.getThis();
    }

    public String getFilters() {
        return this.filters;
    }

    public T setFilters(String filters) {
        this.filters = filters;
        return this.getThis();
    }

    public List<String> getFacets() {
        return this.facets;
    }

    public T setFacets(List<String> facets) {
        this.facets = facets;
        return this.getThis();
    }

    public Long getMaxValuesPerFacet() {
        return this.maxValuesPerFacet;
    }

    public T setMaxValuesPerFacet(Long maxValuesPerFacet) {
        this.maxValuesPerFacet = maxValuesPerFacet;
        return this.getThis();
    }

    public Boolean getFacetingAfterDistinct() {
        return this.facetingAfterDistinct;
    }

    public T setFacetingAfterDistinct(Boolean facetingAfterDistinct) {
        this.facetingAfterDistinct = facetingAfterDistinct;
        return this.getThis();
    }

    public String getSortFacetValuesBy() {
        return this.sortFacetValuesBy;
    }

    public T setSortFacetValuesBy(String sortFacetValuesBy) {
        this.sortFacetValuesBy = sortFacetValuesBy;
        return this.getThis();
    }

    public String getAroundLatLng() {
        return this.aroundLatLng;
    }

    public T setAroundLatLng(String aroundLatLng) {
        this.aroundLatLng = aroundLatLng;
        return this.getThis();
    }

    public Boolean getAroundLatLngViaIP() {
        return this.aroundLatLngViaIP;
    }

    public T setAroundLatLngViaIP(Boolean aroundLatLngViaIP) {
        this.aroundLatLngViaIP = aroundLatLngViaIP;
        return this.getThis();
    }

    public List<AroundPrecision> getAroundPrecision() {
        return this.aroundPrecision;
    }

    public T setAroundPrecision(List<AroundPrecision> aroundPrecision) {
        this.aroundPrecision = aroundPrecision;
        return this.getThis();
    }

    public Integer getMinimumAroundRadius() {
        return this.minimumAroundRadius;
    }

    public T setMinimumAroundRadius(Integer minimumAroundRadius) {
        this.minimumAroundRadius = minimumAroundRadius;
        return this.getThis();
    }

    public List<List<Float>> getInsideBoundingBox() {
        return this.insideBoundingBox;
    }

    public T setInsideBoundingBox(List<List<Float>> insideBoundingBox) {
        this.insideBoundingBox = insideBoundingBox;
        return this.getThis();
    }

    public List<List<Float>> getInsidePolygon() {
        return this.insidePolygon;
    }

    public T setInsidePolygon(List<List<Float>> insidePolygon) {
        this.insidePolygon = insidePolygon;
        return this.getThis();
    }

    public List<String> getAttributesToHighlight() {
        return this.attributesToHighlight;
    }

    public T setAttributesToHighlight(List<String> attributesToHighlight) {
        this.attributesToHighlight = attributesToHighlight;
        return this.getThis();
    }

    public List<String> getAttributesToSnippet() {
        return this.attributesToSnippet;
    }

    public T setAttributesToSnippet(List<String> attributesToSnippet) {
        this.attributesToSnippet = attributesToSnippet;
        return this.getThis();
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public T setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return this.getThis();
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public T setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return this.getThis();
    }

    public String getSnippetEllipsisText() {
        return this.snippetEllipsisText;
    }

    public T setSnippetEllipsisText(String snippetEllipsisText) {
        this.snippetEllipsisText = snippetEllipsisText;
        return this.getThis();
    }

    public Boolean getRestrictHighlightAndSnippetArrays() {
        return this.restrictHighlightAndSnippetArrays;
    }

    public T setRestrictHighlightAndSnippetArrays(Boolean restrictHighlightAndSnippetArrays) {
        this.restrictHighlightAndSnippetArrays = restrictHighlightAndSnippetArrays;
        return this.getThis();
    }

    public Integer getPage() {
        return this.page;
    }

    public T setPage(Integer page) {
        this.page = page;
        return this.getThis();
    }

    public Integer getHitsPerPage() {
        return this.hitsPerPage;
    }

    public T setHitsPerPage(Integer hitsPerPage) {
        this.hitsPerPage = hitsPerPage;
        return this.getThis();
    }

    public Integer getOffset() {
        return this.offset;
    }

    public T setOffset(Integer offset) {
        this.offset = offset;
        return this.getThis();
    }

    public Integer getLength() {
        return this.length;
    }

    public T setLength(Integer length) {
        this.length = length;
        return this.getThis();
    }

    public Boolean getEnableRules() {
        return this.enableRules;
    }

    public T setEnableRules(Boolean enableRules) {
        this.enableRules = enableRules;
        return this.getThis();
    }

    public List<String> getRuleContexts() {
        return this.ruleContexts;
    }

    public T setRuleContexts(List<String> ruleContexts) {
        this.ruleContexts = ruleContexts;
        return this.getThis();
    }

    public String getQueryType() {
        return this.queryType;
    }

    public T setQueryType(String queryType) {
        this.queryType = queryType;
        return this.getThis();
    }

    public Boolean getAdvancedSyntax() {
        return this.advancedSyntax;
    }

    public T setAdvancedSyntax(Boolean advancedSyntax) {
        this.advancedSyntax = advancedSyntax;
        return this.getThis();
    }

    public List<String> getAdvancedSyntaxFeatures() {
        return this.advancedSyntaxFeatures;
    }

    public T setAdvancedSyntaxFeatures(List<String> advancedSyntaxFeatures) {
        this.advancedSyntaxFeatures = advancedSyntaxFeatures;
        return this.getThis();
    }

    public List<String> getOptionalWords() {
        return this.optionalWords;
    }

    public T setOptionalWords(List<String> optionalWords) {
        this.optionalWords = optionalWords;
        return this.getThis();
    }

    public List<String> getDisableExactOnAttributes() {
        return this.disableExactOnAttributes;
    }

    public T setDisableExactOnAttributes(List<String> disableExactOnAttributes) {
        this.disableExactOnAttributes = disableExactOnAttributes;
        return this.getThis();
    }

    public String getExactOnSingleWordQuery() {
        return this.exactOnSingleWordQuery;
    }

    public T setExactOnSingleWordQuery(String exactOnSingleWordQuery) {
        this.exactOnSingleWordQuery = exactOnSingleWordQuery;
        return this.getThis();
    }

    public List<String> getAlternativesAsExact() {
        return this.alternativesAsExact;
    }

    public T setAlternativesAsExact(List<String> alternativesAsExact) {
        this.alternativesAsExact = alternativesAsExact;
        return this.getThis();
    }

    public Integer getMinWordSizefor1Typo() {
        return this.minWordSizefor1Typo;
    }

    public T setMinWordSizefor1Typo(Integer minWordSizefor1Typo) {
        this.minWordSizefor1Typo = minWordSizefor1Typo;
        return this.getThis();
    }

    public Integer getMinWordSizefor2Typos() {
        return this.minWordSizefor2Typos;
    }

    public T setMinWordSizefor2Typos(Integer minWordSizefor2Typos) {
        this.minWordSizefor2Typos = minWordSizefor2Typos;
        return this.getThis();
    }

    public Boolean getAllowTyposOnNumericTokens() {
        return this.allowTyposOnNumericTokens;
    }

    public T setAllowTyposOnNumericTokens(Boolean allowTyposOnNumericTokens) {
        this.allowTyposOnNumericTokens = allowTyposOnNumericTokens;
        return this.getThis();
    }

    public List<String> getDisableTypoToleranceOnAttributes() {
        return this.disableTypoToleranceOnAttributes;
    }

    public T setDisableTypoToleranceOnAttributes(List<String> disableTypoToleranceOnAttributes) {
        this.disableTypoToleranceOnAttributes = disableTypoToleranceOnAttributes;
        return this.getThis();
    }

    public String getUserToken() {
        return this.userToken;
    }

    public T setUserToken(String userToken) {
        this.userToken = userToken;
        return this.getThis();
    }

    public Integer getValidUntil() {
        return this.validUntil;
    }

    public T setValidUntil(Integer validUntil) {
        this.validUntil = validUntil;
        return this.getThis();
    }

    public List<String> getRestrictIndices() {
        return this.restrictIndices;
    }

    public T setRestrictIndices(List<String> restrictIndices) {
        this.restrictIndices = restrictIndices;
        return this.getThis();
    }

    public String getRestrictSources() {
        return this.restrictSources;
    }

    public T setRestrictSources(String restrictSources) {
        this.restrictSources = restrictSources;
        return this.getThis();
    }

    public Boolean getEnablePersonalization() {
        return this.enablePersonalization;
    }

    public T setEnablePersonalization(Boolean enablePersonalization) {
        this.enablePersonalization = enablePersonalization;
        return this.getThis();
    }

    public Integer getPersonalizationImpact() {
        return this.personalizationImpact;
    }

    public T setPersonalizationImpact(Integer personalizationImpact) {
        this.personalizationImpact = personalizationImpact;
        return this.getThis();
    }

    public List<List<String>> getFacetFilters() {
        return this.facetFilters;
    }

    public T setFacetFilters(List<List<String>> facetFilters) {
        this.facetFilters = facetFilters;
        return this.getThis();
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    public T setDistinct(Distinct distinct) {
        this.distinct = distinct;
        return this.getThis();
    }

    public AroundRadius getAroundRadius() {
        return this.aroundRadius;
    }

    public T setAroundRadius(AroundRadius aroundRadius) {
        this.aroundRadius = aroundRadius;
        return this.getThis();
    }

    public RemoveWordsType getRemoveWordsIfNoResults() {
        return this.removeWordsIfNoResults;
    }

    public T setRemoveWordsIfNoResults(RemoveWordsType removeWordsIfNoResults) {
        this.removeWordsIfNoResults = removeWordsIfNoResults;
        return this.getThis();
    }

    public RemoveStopWords getRemoveStopWords() {
        return this.removeStopWords;
    }

    public T setRemoveStopWords(RemoveStopWords removeStopWords) {
        this.removeStopWords = removeStopWords;
        return this.getThis();
    }

    public TypoTolerance getTypoTolerance() {
        return this.typoTolerance;
    }

    public T setTypoTolerance(TypoTolerance typoTolerance) {
        this.typoTolerance = typoTolerance;
        return this.getThis();
    }

    public IgnorePlurals getIgnorePlurals() {
        return this.ignorePlurals;
    }

    public T setIgnorePlurals(IgnorePlurals ignorePlurals) {
        this.ignorePlurals = ignorePlurals;
        return this.getThis();
    }

    public List<List<String>> getOptionalFilters() {
        return this.optionalFilters;
    }

    public T setOptionalFilters(List<List<String>> optionalFilters) {
        this.optionalFilters = optionalFilters;
        return this.getThis();
    }

    public Boolean getSumOrFiltersScores() {
        return this.sumOrFiltersScores;
    }

    public T setSumOrFiltersScores(Boolean sumOrFiltersScores) {
        this.sumOrFiltersScores = sumOrFiltersScores;
        return this.getThis();
    }

    @JsonAnyGetter
    public Map<String, Object> getCustomParameters() {
        return this.customParameters;
    }

    @JsonAnySetter
    public T setCustomParameters(Map<String, Object> customSettings) {
        this.customParameters = customSettings;
        return this.getThis();
    }

    @JsonAnySetter
    public T setCustomParameter(String key, Object value) {
        this.customParameters.put(key, value);
        return this.getThis();
    }

    public String toParam() {
        return QueryStringUtils.buildQueryAsQueryParams(this);
    }
}

