/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.StatefulHost;
import com.algolia.search.models.common.CompressionType;
import com.algolia.search.util.AlgoliaUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;

public abstract class ConfigBase {
    private static final String JAVA_VERSION = System.getProperty("java.version");
    private final String applicationID;
    private final String apiKey;
    private final Map<String, String> defaultHeaders;
    private final int batchSize;
    private final Integer readTimeOut;
    private final Integer writeTimeOut;
    private final Integer connectTimeOut;
    private final List<StatefulHost> hosts;
    private final ExecutorService executor;
    private final CompressionType compressionType;

    protected ConfigBase(Builder<?> builder) {
        Objects.requireNonNull(((Builder)builder).applicationID, "An ApplicationID is required.");
        Objects.requireNonNull(((Builder)builder).apiKey, "An API key is required.");
        Objects.requireNonNull(((Builder)builder).hosts, "Default hosts are required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(((Builder)builder).applicationID).booleanValue()) {
            throw new IllegalArgumentException("The ApplicationID can't be empty.");
        }
        if (AlgoliaUtils.isEmptyWhiteSpace(((Builder)builder).apiKey).booleanValue()) {
            throw new IllegalArgumentException("The APIKey can't be empty.");
        }
        this.apiKey = ((Builder)builder).apiKey;
        this.applicationID = ((Builder)builder).applicationID;
        this.defaultHeaders = ((Builder)builder).defaultHeaders;
        this.batchSize = ((Builder)builder).batchSize;
        this.compressionType = builder.compressionType;
        this.readTimeOut = ((Builder)builder).readTimeOut;
        this.writeTimeOut = ((Builder)builder).writeTimeOut;
        this.connectTimeOut = ((Builder)builder).connectTimeOut;
        this.hosts = ((Builder)builder).hosts;
        this.executor = ((Builder)builder).executor;
    }

    public String getApplicationID() {
        return this.applicationID;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public Integer getReadTimeOut() {
        return this.readTimeOut;
    }

    public Integer getWriteTimeOut() {
        return this.writeTimeOut;
    }

    public Integer getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public List<StatefulHost> getHosts() {
        return this.hosts;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public static abstract class Builder<T extends Builder<T>> {
        private final String applicationID;
        private final String apiKey;
        private final Map<String, String> defaultHeaders;
        private int batchSize;
        private Integer readTimeOut;
        private Integer writeTimeOut;
        private Integer connectTimeOut;
        private List<StatefulHost> hosts;
        private ExecutorService executor;
        protected CompressionType compressionType;

        public Builder(@Nonnull String applicationID, @Nonnull String apiKey, @Nonnull List<StatefulHost> defaultHosts, @Nonnull CompressionType compressionType) {
            this.applicationID = applicationID;
            this.apiKey = apiKey;
            this.batchSize = 1000;
            this.hosts = defaultHosts;
            this.connectTimeOut = 2000;
            this.compressionType = compressionType;
            this.defaultHeaders = new HashMap<String, String>();
            this.defaultHeaders.put("X-Algolia-Application-Id", applicationID);
            this.defaultHeaders.put("X-Algolia-API-Key", apiKey);
            String clientVersion = this.getClass().getPackage().getImplementationVersion();
            this.defaultHeaders.put("User-Agent", String.format("Algolia for Java (%s); JVM (%s)", clientVersion, JAVA_VERSION));
            this.defaultHeaders.put("Accept", "application/json");
            this.defaultHeaders.put("Accept-Encoding", "gzip");
            this.executor = ForkJoinPool.commonPool();
        }

        public abstract T getThis();

        public T setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this.getThis();
        }

        public T setReadTimeOut(Integer readTimeOut) {
            this.readTimeOut = readTimeOut;
            return this.getThis();
        }

        public T setWriteTimeOut(Integer writeTimeOut) {
            this.writeTimeOut = writeTimeOut;
            return this.getThis();
        }

        public T setConnectTimeOut(Integer connectTimeOut) {
            this.connectTimeOut = connectTimeOut;
            return this.getThis();
        }

        public T setHosts(@Nonnull List<StatefulHost> customHosts) {
            this.hosts = customHosts;
            return this.getThis();
        }

        public T setExecutorService(ExecutorService executorService) {
            this.executor = executorService;
            return this.getThis();
        }

        public T addExtraHeaders(@Nonnull String headerKey, @Nonnull String headerValue) {
            this.defaultHeaders.put(headerKey, headerValue);
            return this.getThis();
        }

        public T addExtraHeaders(Map<String, String> headers) {
            this.defaultHeaders.putAll(headers);
            return this.getThis();
        }
    }
}

