/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AnalyticsConfig;
import com.algolia.search.ConfigBase;
import com.algolia.search.HttpRequester;
import com.algolia.search.HttpTransport;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.analytics.ABTest;
import com.algolia.search.models.analytics.ABTestResponse;
import com.algolia.search.models.analytics.ABTests;
import com.algolia.search.models.analytics.AddABTestResponse;
import com.algolia.search.models.analytics.DeleteAbTestResponse;
import com.algolia.search.models.analytics.StopAbTestResponse;
import com.algolia.search.models.common.CallType;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public final class AnalyticsClient
implements Closeable {
    private final HttpTransport transport;
    private final ConfigBase config;

    public AnalyticsClient(@Nonnull AnalyticsConfig config, @Nonnull HttpRequester httpRequester) {
        Objects.requireNonNull(httpRequester, "An httpRequester is required.");
        Objects.requireNonNull(config, "A configuration is required.");
        this.config = config;
        this.transport = new HttpTransport(config, httpRequester);
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }

    public ConfigBase getConfig() {
        return this.config;
    }

    public ABTests getABTests() {
        return LaunderThrowable.await(this.getABTestsAsync(0, 10, null));
    }

    public ABTests getABTests(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getABTestsAsync(0, 10, requestOptions));
    }

    public ABTests getABTests(int offset, int limit) {
        return LaunderThrowable.await(this.getABTestsAsync(offset, limit, null));
    }

    public ABTests getABTests(int offset, int limit, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getABTestsAsync(offset, limit, requestOptions));
    }

    public CompletableFuture<ABTests> getABTestsAsync() {
        return this.getABTestsAsync(0, 10, null);
    }

    public CompletableFuture<ABTests> getABTestsAsync(RequestOptions requestOptions) {
        return this.getABTestsAsync(0, 10, requestOptions);
    }

    public CompletableFuture<ABTests> getABTestsAsync(int offset, int limit) {
        return this.getABTestsAsync(0, 10, null);
    }

    public CompletableFuture<ABTests> getABTestsAsync(int offset, int limit, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.addExtraQueryParameters("offset", Integer.toString(offset));
        requestOptions.addExtraQueryParameters("limit", Integer.toString(limit));
        return this.transport.executeRequestAsync(HttpMethod.GET, "/2/abtests", CallType.READ, null, ABTests.class, requestOptions);
    }

    public ABTestResponse getABTest(long id) {
        return LaunderThrowable.await(this.getABTestAsync(id, null));
    }

    public ABTestResponse getABTest(long id, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getABTestAsync(id, requestOptions));
    }

    public CompletableFuture<ABTestResponse> getABTestAsync(long id) {
        return this.getABTestAsync(id, null);
    }

    public CompletableFuture<ABTestResponse> getABTestAsync(long id, RequestOptions requestOptions) {
        return this.transport.executeRequestAsync(HttpMethod.GET, "/2/abtests/" + id, CallType.READ, ABTestResponse.class, requestOptions);
    }

    public StopAbTestResponse stopABTest(long id) {
        return LaunderThrowable.await(this.stopABTestAsync(id, null));
    }

    public StopAbTestResponse stopABTest(long id, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.stopABTestAsync(id, requestOptions));
    }

    public CompletableFuture<StopAbTestResponse> stopABTestAsync(long id) {
        return this.stopABTestAsync(id, null);
    }

    public CompletableFuture<StopAbTestResponse> stopABTestAsync(long id, RequestOptions requestOptions) {
        return this.transport.executeRequestAsync(HttpMethod.POST, "/2/abtests/" + id + "/stop", CallType.WRITE, StopAbTestResponse.class, requestOptions);
    }

    public DeleteAbTestResponse deleteABTest(long id) {
        return LaunderThrowable.await(this.deleteABTestAsync(id, null));
    }

    public DeleteAbTestResponse deleteABTest(long id, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.deleteABTestAsync(id, requestOptions));
    }

    public CompletableFuture<DeleteAbTestResponse> deleteABTestAsync(long id) {
        return this.deleteABTestAsync(id, null);
    }

    public CompletableFuture<DeleteAbTestResponse> deleteABTestAsync(long id, RequestOptions requestOptions) {
        return this.transport.executeRequestAsync(HttpMethod.DELETE, "/2/abtests/" + id, CallType.WRITE, DeleteAbTestResponse.class, requestOptions);
    }

    public AddABTestResponse addABTest(@Nonnull ABTest abTest) {
        return LaunderThrowable.await(this.addABTestAsync(abTest, null));
    }

    public AddABTestResponse addABTest(@Nonnull ABTest abTest, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.addABTestAsync(abTest, requestOptions));
    }

    public CompletableFuture<AddABTestResponse> addABTestAsync(@Nonnull ABTest abTest) {
        return this.addABTestAsync(abTest, null);
    }

    public CompletableFuture<AddABTestResponse> addABTestAsync(@Nonnull ABTest abTest, RequestOptions requestOptions) {
        Objects.requireNonNull(abTest, "An ABTest is required.");
        return this.transport.executeRequestAsync(HttpMethod.POST, "/2/abtests", CallType.WRITE, abTest, AddABTestResponse.class, requestOptions);
    }
}

