/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClient;
import com.algolia.search.AbstractIndex;
import com.algolia.search.IndexIterable;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.inputs.BatchOperation;
import com.algolia.search.inputs.partial_update.PartialUpdateOperation;
import com.algolia.search.inputs.synonym.AbstractSynonym;
import com.algolia.search.objects.ApiKey;
import com.algolia.search.objects.IndexSettings;
import com.algolia.search.objects.Query;
import com.algolia.search.objects.SynonymQuery;
import com.algolia.search.objects.tasks.sync.Task;
import com.algolia.search.objects.tasks.sync.TaskIndexing;
import com.algolia.search.objects.tasks.sync.TaskSingleIndex;
import com.algolia.search.responses.CreateUpdateKey;
import com.algolia.search.responses.DeleteKey;
import com.algolia.search.responses.SearchFacetResult;
import com.algolia.search.responses.SearchResult;
import com.algolia.search.responses.SearchSynonymResult;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Index<T>
extends AbstractIndex<T> {
    private final String name;
    private final Class<T> klass;
    private final APIClient client;

    Index(String name, Class<T> klass, APIClient client) {
        this.name = name;
        this.klass = klass;
        this.client = client;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getKlass() {
        return this.klass;
    }

    public TaskIndexing addObject(@Nonnull T object) throws AlgoliaException {
        return this.client.addObject(this.name, object);
    }

    public TaskIndexing addObject(@Nonnull String objectID, @Nonnull T object) throws AlgoliaException {
        return this.client.addObject(this.name, objectID, object);
    }

    public TaskSingleIndex addObjects(@Nonnull List<T> objects) throws AlgoliaException {
        return this.client.addObjects(this.name, objects);
    }

    public Optional<T> getObject(@Nonnull String objectID) throws AlgoliaException {
        return this.client.getObject(this.name, objectID, this.klass);
    }

    public List<T> getObjects(@Nonnull List<String> objectIDs) throws AlgoliaException {
        return this.client.getObjects(this.name, objectIDs, this.klass);
    }

    public List<T> getObjects(@Nonnull List<String> objectIDs, @Nonnull List<String> attributesToRetrieve) throws AlgoliaException {
        return this.client.getObjects(this.name, objectIDs, attributesToRetrieve, this.klass);
    }

    public void waitTask(@Nonnull Task task, long timeToWait) throws AlgoliaException {
        Preconditions.checkArgument((timeToWait >= 0L ? 1 : 0) != 0, (String)"timeToWait must be >= 0, was %s", (Object[])new Object[]{timeToWait});
        this.client.waitTask(task, timeToWait);
    }

    public void waitTask(@Nonnull Task task) throws AlgoliaException {
        this.client.waitTask(task, 100L);
    }

    public Task delete() throws AlgoliaException {
        return this.client.deleteIndex(this.name);
    }

    public Task clear() throws AlgoliaException {
        return this.client.clearIndex(this.name);
    }

    public Task saveObject(@Nonnull String objectID, @Nonnull T object) throws AlgoliaException {
        return this.client.saveObject(this.name, objectID, object);
    }

    public TaskSingleIndex saveObjects(@Nonnull List<T> objects) throws AlgoliaException {
        return this.client.saveObjects(this.name, objects);
    }

    public Task deleteObject(@Nonnull String objectID) throws AlgoliaException {
        return this.client.deleteObject(this.name, objectID);
    }

    public TaskSingleIndex deleteObjects(@Nonnull List<String> objectIDs) throws AlgoliaException {
        return this.client.deleteObjects(this.name, objectIDs);
    }

    public IndexSettings getSettings() throws AlgoliaException {
        return this.client.getSettings(this.name);
    }

    public Task setSettings(@Nonnull IndexSettings settings) throws AlgoliaException {
        return this.setSettings(settings, false);
    }

    public Task setSettings(@Nonnull IndexSettings settings, @Nonnull Boolean forwardToReplicas) throws AlgoliaException {
        return this.client.setSettings(this.name, settings, forwardToReplicas);
    }

    public List<ApiKey> listKeys() throws AlgoliaException {
        return this.client.listKeys(this.name);
    }

    public Optional<ApiKey> getKey(@Nonnull String key) throws AlgoliaException {
        return this.client.getKey(this.name, key);
    }

    public DeleteKey deleteKey(@Nonnull String key) throws AlgoliaException {
        return this.client.deleteKey(this.name, key);
    }

    public CreateUpdateKey addKey(@Nonnull ApiKey key) throws AlgoliaException {
        return this.client.addKey(this.name, key);
    }

    public CreateUpdateKey updateKey(@Nonnull String keyName, @Nonnull ApiKey key) throws AlgoliaException {
        return this.client.updateKey(this.name, keyName, key);
    }

    public Task moveTo(@Nonnull String dstIndexName) throws AlgoliaException {
        return this.client.moveIndex(this.name, dstIndexName);
    }

    public Task copyTo(@Nonnull String dstIndexName) throws AlgoliaException {
        return this.client.copyIndex(this.name, dstIndexName);
    }

    public SearchResult<T> search(@Nonnull Query query) throws AlgoliaException {
        return this.client.search(this.name, query, this.klass);
    }

    public SearchFacetResult searchInFacetValues(@Nonnull String facetName, @Nonnull String facetQuery, Query query) throws AlgoliaException {
        return this.client.searchInFacetValues(this.name, facetName, facetQuery, query);
    }

    public SearchFacetResult searchInFacetValues(@Nonnull String facetName, @Nonnull String facetQuery) throws AlgoliaException {
        return this.searchInFacetValues(facetName, facetQuery, null);
    }

    @Deprecated
    public SearchFacetResult searchFacet(@Nonnull String facetName, @Nonnull String facetQuery, Query query) throws AlgoliaException {
        return this.searchInFacetValues(facetName, facetQuery, query);
    }

    @Deprecated
    public SearchFacetResult searchFacet(@Nonnull String facetName, @Nonnull String facetQuery) throws AlgoliaException {
        return this.searchInFacetValues(facetName, facetQuery);
    }

    public TaskSingleIndex batch(@Nonnull List<BatchOperation> operations) throws AlgoliaException {
        return this.client.batch(this.name, operations);
    }

    public TaskSingleIndex partialUpdateObject(@Nonnull String objectID, @Nonnull Object object) throws AlgoliaException {
        return this.client.partialUpdateObject(this.name, objectID, object);
    }

    public TaskSingleIndex partialUpdateObjects(@Nonnull List<Object> objects) throws AlgoliaException {
        return this.client.partialUpdateObjects(this.name, objects);
    }

    public TaskSingleIndex partialUpdateObject(@Nonnull PartialUpdateOperation operation) throws AlgoliaException {
        return this.partialUpdateObject(operation, true);
    }

    public TaskSingleIndex partialUpdateObject(@Nonnull PartialUpdateOperation operation, boolean createIfNotExists) throws AlgoliaException {
        return this.client.partialUpdateObject(this.name, operation, createIfNotExists);
    }

    public Task saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content) throws AlgoliaException {
        return this.saveSynonym(synonymID, content, false);
    }

    public Task saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, boolean forwardToReplicas) throws AlgoliaException {
        return this.saveSynonym(synonymID, content, forwardToReplicas, false);
    }

    public Task saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, boolean forwardToReplicas, boolean replaceExistingSynonyms) throws AlgoliaException {
        return this.client.saveSynonym(this.name, synonymID, content, forwardToReplicas, replaceExistingSynonyms);
    }

    public Optional<AbstractSynonym> getSynonym(@Nonnull String synonymID) throws AlgoliaException {
        return this.client.getSynonym(this.name, synonymID);
    }

    public Task deleteSynonym(@Nonnull String synonymID) throws AlgoliaException {
        return this.deleteSynonym(synonymID, false);
    }

    public Task deleteSynonym(@Nonnull String synonymID, boolean forwardToReplicas) throws AlgoliaException {
        return this.client.deleteSynonym(this.name, synonymID, forwardToReplicas);
    }

    public Task clearSynonyms() throws AlgoliaException {
        return this.clearSynonyms(false);
    }

    public Task clearSynonyms(boolean forwardToReplicas) throws AlgoliaException {
        return this.client.clearSynonyms(this.name, forwardToReplicas);
    }

    public SearchSynonymResult searchSynonyms(@Nonnull SynonymQuery query) throws AlgoliaException {
        return this.client.searchSynonyms(this.name, query);
    }

    public Task batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas, boolean replaceExistingSynonyms) throws AlgoliaException {
        return this.client.batchSynonyms(this.name, synonyms, forwardToReplicas, replaceExistingSynonyms);
    }

    public Task batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas) throws AlgoliaException {
        return this.batchSynonyms(synonyms, forwardToReplicas, false);
    }

    public Task batchSynonyms(@Nonnull List<AbstractSynonym> synonyms) throws AlgoliaException {
        return this.batchSynonyms(synonyms, false, false);
    }

    public IndexIterable<T> browse(@Nonnull Query query) throws AlgoliaException {
        return new IndexIterable<T>(this.client, this.name, query, this.klass);
    }

    public IndexIterable<T> browseFrom(@Nonnull Query query, @Nullable String cursor) throws AlgoliaException {
        return new IndexIterable<T>(this.client, this.name, query, cursor, this.klass);
    }

    public void deleteByQuery(@Nonnull Query query) throws AlgoliaException {
        this.client.deleteByQuery(this.name, query, 1000);
    }

    public void deleteByQuery(@Nonnull Query query, int batchSize) throws AlgoliaException {
        this.client.deleteByQuery(this.name, query, batchSize);
    }

    public static class Attributes {
        private String name;
        private String createdAt;
        private String updatedAt;
        private Integer entries;
        private Integer dataSize;
        private Integer fileSize;
        private Integer lastBuildTimeS;
        private Integer numberOfPendingTask;
        private Boolean pendingTask;

        public String getName() {
            return this.name;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public Integer getEntries() {
            return this.entries;
        }

        public Integer getDataSize() {
            return this.dataSize;
        }

        public Integer getFileSize() {
            return this.fileSize;
        }

        public Integer getLastBuildTimeS() {
            return this.lastBuildTimeS;
        }

        public Integer getNumberOfPendingTask() {
            return this.numberOfPendingTask;
        }

        public Boolean getPendingTask() {
            return this.pendingTask;
        }
    }
}

