/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.objects;

import com.algolia.search.objects.AroundRadius;
import com.algolia.search.objects.CompoundType;
import com.algolia.search.objects.Distinct;
import com.algolia.search.objects.FacetFilters;
import com.algolia.search.objects.FacetFiltersAsListOfString;
import com.algolia.search.objects.IgnorePlurals;
import com.algolia.search.objects.RemoveStopWords;
import com.algolia.search.objects.TypoTolerance;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class QueryBase<T extends QueryBase<?>>
implements Serializable {
    protected String similarQuery;
    protected Distinct distinct;
    protected Boolean getRankingInfo;
    protected List<List<String>> numericFilters;
    protected List<List<String>> tagFilters;
    protected Boolean clickAnalytics;
    protected Boolean analytics;
    protected List<String> analyticsTags;
    protected Boolean synonyms;
    protected Boolean replaceSynonymsInHighlight;
    protected Integer minProximity;
    protected List<String> responseFields;
    protected Long maxFacetHits;
    protected Boolean percentileComputation;
    protected List<String> queryLanguages;
    protected List<String> attributesToRetrieve;
    protected List<String> restrictSearchableAttributes;
    protected String filters;
    protected String facets;
    protected Long maxValuesPerFacet;
    protected FacetFilters facetFilters;
    protected List<List<String>> optionalFilters;
    protected Boolean facetingAfterDistinct;
    protected String sortFacetValuesBy;
    protected String aroundLatLng;
    protected Boolean aroundLatLngViaIP;
    protected AroundRadius aroundRadius;
    protected Integer aroundPrecision;
    protected Integer minimumAroundRadius;
    protected List<List<Float>> insideBoundingBox;
    protected List<List<Float>> insidePolygon;
    protected List<String> attributesToHighlight;
    protected List<String> attributesToSnippet;
    protected String highlightPreTag;
    protected String highlightPostTag;
    protected String snippetEllipsisText;
    protected Boolean restrictHighlightAndSnippetArrays;
    protected Long page;
    protected Long hitsPerPage;
    protected Long offset;
    protected Long length;
    protected Boolean enableRules;
    protected List<String> ruleContexts;
    protected String queryType;
    protected RemoveWordsType removeWordsIfNoResults;
    protected Boolean advancedSyntax;
    protected List<String> advancedSyntaxFeatures;
    protected List<String> optionalWords;
    protected RemoveStopWords removeStopWords;
    protected List<String> disableExactOnAttributes;
    protected String exactOnSingleWordQuery;
    protected List<String> alternativesAsExact;
    protected Boolean sumOrFiltersScores;
    @JsonProperty(value="query")
    protected String query;
    protected Integer minWordSizefor1Typo;
    protected Integer minWordSizefor2Typos;
    protected TypoTolerance typoTolerance;
    protected Boolean allowTyposOnNumericTokens;
    protected IgnorePlurals ignorePlurals;
    protected List<String> disableTypoToleranceOnAttributes;
    protected String userToken;
    protected Integer validUntil;
    protected List<String> restrictIndices;
    protected String restrictSources;
    protected String cursor;
    protected Boolean enablePersonalization;
    @JsonIgnore
    protected Map<String, Object> customParameters = new HashMap<String, Object>();

    private Map<String, String> toQueryParam() {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        if (this.distinct != null) {
            builder = this.add(builder, "distinct", this.distinct.getInsideValue());
        }
        builder = this.add(builder, "getRankingInfo", this.getRankingInfo);
        builder = this.addListString(builder, "numericFilters", this.numericFilters);
        builder = this.addListString(builder, "tagFilters", this.tagFilters);
        builder = this.addListString(builder, "optionalFilters", this.optionalFilters);
        builder = this.addListFloat(builder, "insideBoundingBox", this.insideBoundingBox);
        builder = this.addListFloat(builder, "insidePolygon", this.insidePolygon);
        builder = this.add(builder, "analytics", this.analytics);
        builder = this.add(builder, "analyticsTags", this.analyticsTags);
        builder = this.add(builder, "clickAnalytics", this.clickAnalytics);
        builder = this.add(builder, "synonyms", this.synonyms);
        builder = this.add(builder, "replaceSynonymsInHighlight", this.replaceSynonymsInHighlight);
        builder = this.add(builder, "minProximity", this.minProximity);
        builder = this.add(builder, "responseFields", this.responseFields);
        builder = this.add(builder, "maxFacetHits", this.maxFacetHits);
        builder = this.add(builder, "percentileComputation", this.percentileComputation);
        builder = this.add(builder, "queryLanguages", this.queryLanguages);
        builder = this.add(builder, "attributesToRetrieve", this.attributesToRetrieve);
        builder = this.add(builder, "restrictSearchableAttributes", this.restrictSearchableAttributes);
        builder = this.add(builder, "filters", this.filters);
        builder = this.add(builder, "facets", this.facets);
        builder = this.add(builder, "maxValuesPerFacet", this.maxValuesPerFacet);
        builder = this.add(builder, "facetFilters", this.facetFilters);
        builder = this.add(builder, "facetingAfterDistinct", this.facetingAfterDistinct);
        builder = this.add(builder, "sortFacetValuesBy", this.sortFacetValuesBy);
        builder = this.add(builder, "aroundLatLng", this.aroundLatLng);
        builder = this.add(builder, "aroundLatLngViaIP", this.aroundLatLngViaIP);
        builder = this.add(builder, "aroundRadius", this.aroundRadius);
        builder = this.add(builder, "aroundPrecision", this.aroundPrecision);
        builder = this.add(builder, "minimumAroundRadius", this.minimumAroundRadius);
        builder = this.add(builder, "attributesToHighlight", this.attributesToHighlight);
        builder = this.add(builder, "attributesToSnippet", this.attributesToSnippet);
        builder = this.add(builder, "highlightPreTag", this.highlightPreTag);
        builder = this.add(builder, "highlightPostTag", this.highlightPostTag);
        builder = this.add(builder, "snippetEllipsisText", this.snippetEllipsisText);
        builder = this.add(builder, "restrictHighlightAndSnippetArrays", this.restrictHighlightAndSnippetArrays);
        builder = this.add(builder, "page", this.page);
        builder = this.add(builder, "hitsPerPage", this.hitsPerPage);
        builder = this.add(builder, "offset", this.offset);
        builder = this.add(builder, "length", this.length);
        builder = this.add(builder, "enableRules", this.enableRules);
        builder = this.add(builder, "ruleContexts", this.ruleContexts);
        builder = this.add(builder, "queryType", this.queryType);
        builder = this.add(builder, "removeWordsIfNoResults", this.removeWordsIfNoResults);
        builder = this.add(builder, "advancedSyntax", this.advancedSyntax);
        builder = this.add(builder, "advancedSyntaxFeatures", this.advancedSyntaxFeatures);
        builder = this.add(builder, "optionalWords", this.optionalWords);
        if (this.removeStopWords != null) {
            builder = this.add(builder, "removeStopWords", this.removeStopWords.getInsideValue());
        }
        builder = this.add(builder, "disableExactOnAttributes", this.disableExactOnAttributes);
        builder = this.add(builder, "exactOnSingleWordQuery", this.exactOnSingleWordQuery);
        builder = this.add(builder, "alternativesAsExact", this.alternativesAsExact);
        builder = this.add(builder, "query", this.query);
        builder = this.add(builder, "minWordSizefor1Typo", this.minWordSizefor1Typo);
        builder = this.add(builder, "minWordSizefor2Typos", this.minWordSizefor2Typos);
        builder = this.add(builder, "typoTolerance", this.typoTolerance);
        builder = this.add(builder, "allowTyposOnNumericTokens", this.allowTyposOnNumericTokens);
        if (this.ignorePlurals != null) {
            builder = this.add(builder, "ignorePlurals", this.ignorePlurals.getInsideValue());
        }
        builder = this.add(builder, "disableTypoToleranceOnAttributes", this.disableTypoToleranceOnAttributes);
        builder = this.add(builder, "userToken", this.userToken);
        builder = this.add(builder, "validUntil", this.validUntil);
        builder = this.add(builder, "restrictIndices", this.restrictIndices);
        builder = this.add(builder, "restrictSources", this.restrictSources);
        builder = this.add(builder, "cursor", this.cursor);
        builder = this.add(builder, "enablePersonalization", this.enablePersonalization);
        for (Map.Entry<String, Object> entry : this.customParameters.entrySet()) {
            builder = this.add(builder, entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, Object value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, CompoundType value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.getInsideValue().toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, Enum<?> value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, String value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value);
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, Boolean value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, Integer value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, List<String> attributes) {
        if (attributes == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)String.join((CharSequence)",", attributes));
    }

    private ImmutableMap.Builder<String, String> addListString(ImmutableMap.Builder<String, String> builder, String name, List<List<String>> attributes) {
        if (attributes == null) {
            return builder;
        }
        String values = "[" + attributes.stream().map(arr -> "[" + arr.stream().map(QueryBase::formatParameters).collect(Collectors.joining(",")) + "]").collect(Collectors.joining(",")) + "]";
        return builder.put((Object)name, (Object)values);
    }

    private ImmutableMap.Builder<String, String> addListFloat(ImmutableMap.Builder<String, String> builder, String name, List<List<Float>> attributes) {
        if (attributes == null) {
            return builder;
        }
        String values = "[" + attributes.stream().map(arr -> "[" + arr.stream().map(QueryBase::formatParameters).collect(Collectors.joining(",")) + "]").collect(Collectors.joining(",")) + "]";
        return builder.put((Object)name, (Object)values);
    }

    private static String formatParameters(Object parameter) {
        if (parameter instanceof Float) {
            return parameter.toString();
        }
        return "\"" + parameter.toString() + "\"";
    }

    public String toParam() {
        StringBuilder builder = new StringBuilder();
        boolean firstOne = true;
        for (Map.Entry<String, String> entry : this.toQueryParam().entrySet()) {
            try {
                if (!firstOne) {
                    builder = builder.append("&");
                }
                builder = builder.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            firstOne = false;
        }
        return builder.toString();
    }

    public String getSimilarQuery() {
        return this.similarQuery;
    }

    public T setSimilarQuery(String similarQuery) {
        this.similarQuery = similarQuery;
        return (T)this;
    }

    public T setAroundRadius(AroundRadius aroundRadius) {
        this.aroundRadius = aroundRadius;
        return (T)this;
    }

    @JsonAnySetter
    public T addCustomParameter(String key, String value) {
        this.customParameters.put(key, value);
        return (T)this;
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    public T setDistinct(Distinct distinct) {
        this.distinct = distinct;
        return (T)this;
    }

    public Boolean getGetRankingInfo() {
        return this.getRankingInfo;
    }

    public T setGetRankingInfo(Boolean getRankingInfo) {
        this.getRankingInfo = getRankingInfo;
        return (T)this;
    }

    public List<List<String>> getNumericFilters() {
        return this.numericFilters;
    }

    public T setNumericFilters(List<List<String>> numericFilters) {
        this.numericFilters = numericFilters;
        return (T)this;
    }

    public List<List<String>> getTagFilters() {
        return this.tagFilters;
    }

    public T setTagFilters(List<List<String>> tagFilters) {
        this.tagFilters = tagFilters;
        return (T)this;
    }

    public Boolean getClickAnalytics() {
        return this.clickAnalytics;
    }

    public T setClickAnalytics(Boolean clickAnalytics) {
        this.clickAnalytics = clickAnalytics;
        return (T)this;
    }

    public Boolean getAnalytics() {
        return this.analytics;
    }

    public T setAnalytics(Boolean analytics) {
        this.analytics = analytics;
        return (T)this;
    }

    public List<String> getAnalyticsTags() {
        return this.analyticsTags;
    }

    public T setAnalyticsTags(List<String> analyticsTags) {
        this.analyticsTags = analyticsTags;
        return (T)this;
    }

    public Boolean getSynonyms() {
        return this.synonyms;
    }

    public T setSynonyms(Boolean synonyms) {
        this.synonyms = synonyms;
        return (T)this;
    }

    public Boolean getReplaceSynonymsInHighlight() {
        return this.replaceSynonymsInHighlight;
    }

    public T setReplaceSynonymsInHighlight(Boolean replaceSynonymsInHighlight) {
        this.replaceSynonymsInHighlight = replaceSynonymsInHighlight;
        return (T)this;
    }

    public Integer getMinProximity() {
        return this.minProximity;
    }

    public T setMinProximity(Integer minProximity) {
        this.minProximity = minProximity;
        return (T)this;
    }

    public List<String> getResponseFields() {
        return this.responseFields;
    }

    public T setResponseFields(List<String> responseFields) {
        this.responseFields = responseFields;
        return (T)this;
    }

    public Long getMaxFacetHits() {
        return this.maxFacetHits;
    }

    @JsonSetter
    public T setMaxFacetHits(Long maxFacetHits) {
        this.maxFacetHits = maxFacetHits;
        return (T)this;
    }

    public T setMaxFacetHits(Integer maxFacetHits) {
        return this.setMaxFacetHits(maxFacetHits.longValue());
    }

    public Boolean getPercentileComputation() {
        return this.percentileComputation;
    }

    public T setPercentileComputation(Boolean percentileComputation) {
        this.percentileComputation = percentileComputation;
        return (T)this;
    }

    public List<String> getQueryLanguages() {
        return this.queryLanguages;
    }

    public T setQueryLanguages(List<String> queryLanguages) {
        this.queryLanguages = queryLanguages;
        return (T)this;
    }

    public List<String> getAttributesToRetrieve() {
        return this.attributesToRetrieve;
    }

    public T setAttributesToRetrieve(List<String> attributesToRetrieve) {
        this.attributesToRetrieve = attributesToRetrieve;
        return (T)this;
    }

    public List<String> getRestrictSearchableAttributes() {
        return this.restrictSearchableAttributes;
    }

    public T setRestrictSearchableAttributes(List<String> restrictSearchableAttributes) {
        this.restrictSearchableAttributes = restrictSearchableAttributes;
        return (T)this;
    }

    public String getFilters() {
        return this.filters;
    }

    public T setFilters(String filters) {
        this.filters = filters;
        return (T)this;
    }

    public String getFacets() {
        return this.facets;
    }

    public T setFacets(String facets) {
        this.facets = facets;
        return (T)this;
    }

    public Long getMaxValuesPerFacet() {
        return this.maxValuesPerFacet;
    }

    @JsonSetter
    public T setMaxValuesPerFacet(Long maxValuesPerFacet) {
        this.maxValuesPerFacet = maxValuesPerFacet;
        return (T)this;
    }

    public T setMaxValuesPerFacet(Integer maxValuesPerFacet) {
        return this.setMaxValuesPerFacet(maxValuesPerFacet.longValue());
    }

    public FacetFilters getFacetFilters() {
        return this.facetFilters;
    }

    @Deprecated
    public T setFacetFilters(List<String> facetFilters) {
        this.facetFilters = new FacetFiltersAsListOfString(facetFilters);
        return (T)this;
    }

    @JsonSetter
    public T setFacetFilters(FacetFilters facetFilters) {
        this.facetFilters = facetFilters;
        return (T)this;
    }

    public List<List<String>> getOptionalFilters() {
        return this.optionalFilters;
    }

    public T setOptionalFilters(List<List<String>> optionalFilters) {
        this.optionalFilters = optionalFilters;
        return (T)this;
    }

    public Boolean getFacetingAfterDistinct() {
        return this.facetingAfterDistinct;
    }

    public T setFacetingAfterDistinct(Boolean facetingAfterDistinct) {
        this.facetingAfterDistinct = facetingAfterDistinct;
        return (T)this;
    }

    public String getAroundLatLng() {
        return this.aroundLatLng;
    }

    public T setAroundLatLng(String aroundLatLng) {
        this.aroundLatLng = aroundLatLng;
        return (T)this;
    }

    public Boolean getAroundLatLngViaIP() {
        return this.aroundLatLngViaIP;
    }

    public T setAroundLatLngViaIP(Boolean aroundLatLngViaIP) {
        this.aroundLatLngViaIP = aroundLatLngViaIP;
        return (T)this;
    }

    public AroundRadius getAroundRadius() {
        return this.aroundRadius;
    }

    public Integer getAroundPrecision() {
        return this.aroundPrecision;
    }

    public T setAroundPrecision(Integer aroundPrecision) {
        this.aroundPrecision = aroundPrecision;
        return (T)this;
    }

    public Integer getMinimumAroundRadius() {
        return this.minimumAroundRadius;
    }

    public T setMinimumAroundRadius(Integer minimumAroundRadius) {
        this.minimumAroundRadius = minimumAroundRadius;
        return (T)this;
    }

    public List<List<Float>> getInsideBoundingBox() {
        return this.insideBoundingBox;
    }

    public T setInsideBoundingBox(List<List<Float>> insideBoundingBox) {
        this.insideBoundingBox = insideBoundingBox;
        return (T)this;
    }

    public List<List<Float>> getInsidePolygon() {
        return this.insidePolygon;
    }

    public T setInsidePolygon(List<List<Float>> insidePolygon) {
        this.insidePolygon = insidePolygon;
        return (T)this;
    }

    public List<String> getAttributesToHighlight() {
        return this.attributesToHighlight;
    }

    public T setAttributesToHighlight(List<String> attributesToHighlight) {
        this.attributesToHighlight = attributesToHighlight;
        return (T)this;
    }

    public List<String> getAttributesToSnippet() {
        return this.attributesToSnippet;
    }

    public T setAttributesToSnippet(List<String> attributesToSnippet) {
        this.attributesToSnippet = attributesToSnippet;
        return (T)this;
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public T setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return (T)this;
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public T setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return (T)this;
    }

    public String getSnippetEllipsisText() {
        return this.snippetEllipsisText;
    }

    public T setSnippetEllipsisText(String snippetEllipsisText) {
        this.snippetEllipsisText = snippetEllipsisText;
        return (T)this;
    }

    public Boolean getRestrictHighlightAndSnippetArrays() {
        return this.restrictHighlightAndSnippetArrays;
    }

    public T setRestrictHighlightAndSnippetArrays(Boolean restrictHighlightAndSnippetArrays) {
        this.restrictHighlightAndSnippetArrays = restrictHighlightAndSnippetArrays;
        return (T)this;
    }

    public Long getPage() {
        return this.page;
    }

    @JsonSetter
    public T setPage(Long page) {
        this.page = page;
        return (T)this;
    }

    public T setPage(Integer page) {
        return this.setPage(page.longValue());
    }

    public Long getHitsPerPage() {
        return this.hitsPerPage;
    }

    @JsonSetter
    public T setHitsPerPage(Long hitsPerPage) {
        this.hitsPerPage = hitsPerPage;
        return (T)this;
    }

    public T setHitsPerPage(Integer hitsPerPage) {
        return this.setHitsPerPage(hitsPerPage.longValue());
    }

    public Long getOffset() {
        return this.offset;
    }

    @JsonSetter
    public T setOffset(Long offset) {
        this.offset = offset;
        return (T)this;
    }

    public T setOffset(Integer offset) {
        return this.setOffset(offset.longValue());
    }

    public Long getLength() {
        return this.length;
    }

    @JsonSetter
    public T setLength(Long length) {
        this.length = length;
        return (T)this;
    }

    public T setLength(Integer length) {
        return this.setLength(length.longValue());
    }

    public String getQueryType() {
        return this.queryType;
    }

    public T setQueryType(String queryType) {
        this.queryType = queryType;
        return (T)this;
    }

    public RemoveWordsType getRemoveWordsIfNoResults() {
        return this.removeWordsIfNoResults;
    }

    public T setRemoveWordsIfNoResults(RemoveWordsType removeWordsIfNoResults) {
        this.removeWordsIfNoResults = removeWordsIfNoResults;
        return (T)this;
    }

    public Boolean getAdvancedSyntax() {
        return this.advancedSyntax;
    }

    public T setAdvancedSyntax(Boolean advancedSyntax) {
        this.advancedSyntax = advancedSyntax;
        return (T)this;
    }

    public List<String> getAdvancedSyntaxFeatures() {
        return this.advancedSyntaxFeatures;
    }

    public T setAdvancedSyntaxFeatures(List<String> advancedSyntaxFeatures) {
        this.advancedSyntaxFeatures = advancedSyntaxFeatures;
        return (T)this;
    }

    public List<String> getOptionalWords() {
        return this.optionalWords;
    }

    public T setOptionalWords(List<String> optionalWords) {
        this.optionalWords = optionalWords;
        return (T)this;
    }

    public RemoveStopWords getRemoveStopWords() {
        return this.removeStopWords;
    }

    public T setRemoveStopWords(RemoveStopWords removeStopWords) {
        this.removeStopWords = removeStopWords;
        return (T)this;
    }

    public List<String> getDisableExactOnAttributes() {
        return this.disableExactOnAttributes;
    }

    public T setDisableExactOnAttributes(List<String> disableExactOnAttributes) {
        this.disableExactOnAttributes = disableExactOnAttributes;
        return (T)this;
    }

    public String getExactOnSingleWordQuery() {
        return this.exactOnSingleWordQuery;
    }

    public T setExactOnSingleWordQuery(String exactOnSingleWordQuery) {
        this.exactOnSingleWordQuery = exactOnSingleWordQuery;
        return (T)this;
    }

    public List<String> getAlternativesAsExact() {
        return this.alternativesAsExact;
    }

    public T setAlternativesAsExact(List<String> alternativesAsExact) {
        this.alternativesAsExact = alternativesAsExact;
        return (T)this;
    }

    public Integer getMinWordSizefor1Typo() {
        return this.minWordSizefor1Typo;
    }

    public T setMinWordSizefor1Typo(Integer minWordSizefor1Typo) {
        this.minWordSizefor1Typo = minWordSizefor1Typo;
        return (T)this;
    }

    public Integer getMinWordSizefor2Typos() {
        return this.minWordSizefor2Typos;
    }

    public T setMinWordSizefor2Typos(Integer minWordSizefor2Typos) {
        this.minWordSizefor2Typos = minWordSizefor2Typos;
        return (T)this;
    }

    public TypoTolerance getTypoTolerance() {
        return this.typoTolerance;
    }

    public T setTypoTolerance(TypoTolerance typoTolerance) {
        this.typoTolerance = typoTolerance;
        return (T)this;
    }

    public Boolean getAllowTyposOnNumericTokens() {
        return this.allowTyposOnNumericTokens;
    }

    public T setAllowTyposOnNumericTokens(Boolean allowTyposOnNumericTokens) {
        this.allowTyposOnNumericTokens = allowTyposOnNumericTokens;
        return (T)this;
    }

    public IgnorePlurals getIgnorePlurals() {
        return this.ignorePlurals;
    }

    public T setIgnorePlurals(IgnorePlurals ignorePlurals) {
        this.ignorePlurals = ignorePlurals;
        return (T)this;
    }

    public List<String> getDisableTypoToleranceOnAttributes() {
        return this.disableTypoToleranceOnAttributes;
    }

    public T setDisableTypoToleranceOnAttributes(List<String> disableTypoToleranceOnAttributes) {
        this.disableTypoToleranceOnAttributes = disableTypoToleranceOnAttributes;
        return (T)this;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public T setUserToken(String userToken) {
        this.userToken = userToken;
        return (T)this;
    }

    public Integer getValidUntil() {
        return this.validUntil;
    }

    public T setValidUntil(Integer validUntil) {
        this.validUntil = validUntil;
        return (T)this;
    }

    public List<String> getRestrictIndices() {
        return this.restrictIndices;
    }

    public T setRestrictIndices(List<String> restrictIndices) {
        this.restrictIndices = restrictIndices;
        return (T)this;
    }

    public String getRestrictSources() {
        return this.restrictSources;
    }

    public T setRestrictSources(String restrictSources) {
        this.restrictSources = restrictSources;
        return (T)this;
    }

    public String getCursor() {
        return this.cursor;
    }

    public T setCursor(String cursor) {
        this.cursor = cursor;
        return (T)this;
    }

    public Boolean getEnableRules() {
        return this.enableRules;
    }

    public T setEnableRules(Boolean enableRules) {
        this.enableRules = enableRules;
        return (T)this;
    }

    public List<String> getRuleContexts() {
        return this.ruleContexts;
    }

    public Boolean getEnablePersonalization() {
        return this.enablePersonalization;
    }

    public T setEnablePersonalization(Boolean enablePersonalization) {
        this.enablePersonalization = enablePersonalization;
        return (T)this;
    }

    public T setRuleContexts(List<String> ruleContexts) {
        this.ruleContexts = ruleContexts;
        return (T)this;
    }

    public T setQuery(String query) {
        this.query = query;
        return (T)this;
    }

    public String getSortFacetValuesBy() {
        return this.sortFacetValuesBy;
    }

    public T setSortFacetValuesBy(String sortFacetValuesBy) {
        this.sortFacetValuesBy = sortFacetValuesBy;
        return (T)this;
    }

    public Boolean getSumOrFiltersScores() {
        return this.sumOrFiltersScores;
    }

    public T setSumOrFiltersScores(Boolean sumOrFiltersScores) {
        this.sumOrFiltersScores = sumOrFiltersScores;
        return (T)this;
    }

    @JsonAnyGetter
    public Map<String, Object> getCustomParameters() {
        return this.customParameters;
    }

    @JsonAnySetter
    public T setCustomParameters(Map<String, Object> customParameters) {
        this.customParameters = customParameters;
        return (T)this;
    }

    public String toString() {
        return "Query{distinct=" + this.distinct + ", getRankingInfo=" + this.getRankingInfo + ", numericFilters=" + this.numericFilters + ", tagFilters=" + this.tagFilters + ", analytics=" + this.analytics + ", analyticsTags='" + this.analyticsTags + '\'' + ", synonyms=" + this.synonyms + ", replaceSynonymsInHighlight=" + this.replaceSynonymsInHighlight + ", minProximity=" + this.minProximity + ", responseFields=" + this.responseFields + ", maxFacetHits=" + this.maxFacetHits + ", percentileComputation=" + this.percentileComputation + ", queryLanguages=" + this.queryLanguages + ", attributesToRetrieve=" + this.attributesToRetrieve + ", restrictSearchableAttributes=" + this.restrictSearchableAttributes + ", filters='" + this.filters + '\'' + ", facets='" + this.facets + '\'' + ", maxValuesPerFacet=" + this.maxValuesPerFacet + ", facetFilters=" + this.facetFilters + ", facetingAfterDistinct=" + this.facetingAfterDistinct + ", sortFacetValuesBy" + this.sortFacetValuesBy + ", aroundLatLng='" + this.aroundLatLng + '\'' + ", aroundLatLngViaIP=" + this.aroundLatLngViaIP + ", aroundRadius=" + this.aroundRadius + ", aroundPrecision=" + this.aroundPrecision + ", minimumAroundRadius=" + this.minimumAroundRadius + ", insideBoundingBox=" + this.insideBoundingBox + ", insidePolygon=" + this.insidePolygon + ", attributesToHighlight=" + this.attributesToHighlight + ", attributesToSnippet=" + this.attributesToSnippet + ", highlightPreTag='" + this.highlightPreTag + '\'' + ", highlightPostTag='" + this.highlightPostTag + '\'' + ", snippetEllipsisText='" + this.snippetEllipsisText + '\'' + ", restrictHighlightAndSnippetArrays=" + this.restrictHighlightAndSnippetArrays + ", page=" + this.page + ", hitsPerPage=" + this.hitsPerPage + ", offset=" + this.offset + ", length=" + this.length + ", enableRules" + this.enableRules + ", ruleContexts" + this.ruleContexts + ", queryType='" + this.queryType + '\'' + ", removeWordsIfNoResults=" + (Object)((Object)this.removeWordsIfNoResults) + ", advancedSyntax=" + this.advancedSyntax + ", advancedSyntaxFeatures=" + this.advancedSyntaxFeatures + ", optionalWords=" + this.optionalWords + ", removeStopWords=" + this.removeStopWords + ", disableExactOnAttributes=" + this.disableExactOnAttributes + ", exactOnSingleWordQuery='" + this.exactOnSingleWordQuery + '\'' + ", alternativesAsExact=" + this.alternativesAsExact + ", query='" + this.query + '\'' + ", minWordSizefor1Typo=" + this.minWordSizefor1Typo + ", minWordSizefor2Typos=" + this.minWordSizefor2Typos + ", typoTolerance=" + this.typoTolerance + ", allowTyposOnNumericTokens=" + this.allowTyposOnNumericTokens + ", ignorePlurals=" + this.ignorePlurals + ", disableTypoToleranceOnAttributes=" + this.disableTypoToleranceOnAttributes + ", userToken='" + this.userToken + '\'' + ", validUntil=" + this.validUntil + ", restrictIndices=" + this.restrictIndices + ", restrictSources='" + this.restrictSources + '\'' + ", cursor='" + this.cursor + '\'' + ", customParameters=" + this.customParameters + '}';
    }

    public static enum RemoveWordsType {
        REMOVE_LAST_WORDS("LastWords"),
        REMOVE_FIRST_WORDS("FirstWords"),
        REMOVE_NONE("none"),
        REMOVE_ALLOPTIONAL("allOptional");

        private final String name;

        private RemoveWordsType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum QueryType {
        PREFIX_ALL("prefixAll"),
        PREFIX_LAST("prefixLast"),
        PREFIX_NONE("prefixNone");

        private final String name;

        private QueryType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

