/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.iterators;

import com.algolia.search.AsyncIndex;
import com.algolia.search.inputs.query_rules.Rule;
import com.algolia.search.iterators.AsyncAlgoliaIterator;
import com.algolia.search.objects.RuleQuery;
import com.algolia.search.responses.SearchRuleResult;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

public class AsyncRulesIterator
extends AsyncAlgoliaIterator<Rule> {
    private static final RuleQuery EMPTY_QUERY = new RuleQuery("");

    public AsyncRulesIterator(@Nonnull AsyncIndex<?> index) {
        super(index);
    }

    public AsyncRulesIterator(@Nonnull AsyncIndex<?> index, @Nonnull Integer hitsPerPage) {
        super(index, hitsPerPage);
    }

    @Override
    List<Rule> doQueryToGetHits(Integer page) {
        try {
            SearchRuleResult result = this.index.searchRules(EMPTY_QUERY.setPage(page).setHitsPerPage(this.hitsPerPage)).get();
            if (result == null) {
                return SearchRuleResult.empty().getHits();
            }
            return result.getHits();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

