/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SyncInsightsClient;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.inputs.insights.InsightsEvent;
import com.algolia.search.inputs.insights.InsightsResult;
import com.algolia.search.objects.RequestOptions;
import java.util.List;
import javax.annotation.Nonnull;

public class SyncUserInsightsClient {
    private String userToken;
    private SyncInsightsClient client;

    public SyncUserInsightsClient(String userToken, SyncInsightsClient client) {
        this.userToken = userToken;
        this.client = client;
    }

    public InsightsResult clickedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters) throws AlgoliaException {
        return this.clickedFilters(eventName, indexName, filters, new RequestOptions());
    }

    public InsightsResult clickedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        InsightsEvent event = new InsightsEvent().setEventType("click").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setFilters(filters);
        return this.client.sendEvent(event, requestOptions);
    }

    public InsightsResult clickedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs) throws AlgoliaException {
        return this.clickedObjectIDs(eventName, indexName, objectIDs, new RequestOptions());
    }

    public InsightsResult clickedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        InsightsEvent event = new InsightsEvent().setEventType("click").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs);
        return this.client.sendEvent(event, requestOptions);
    }

    public InsightsResult clickedObjectIDsAfterSearch(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull List<Long> positions, @Nonnull String queryID) throws AlgoliaException {
        return this.clickedObjectIDsAfterSearch(eventName, indexName, objectIDs, positions, queryID, new RequestOptions());
    }

    public InsightsResult clickedObjectIDsAfterSearch(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull List<Long> positions, @Nonnull String queryID, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        InsightsEvent event = new InsightsEvent().setEventType("click").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs).setPositions(positions).setQueryID(queryID);
        return this.client.sendEvent(event, requestOptions);
    }

    public InsightsResult convertedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs) throws AlgoliaException {
        return this.convertedObjectIDs(eventName, indexName, objectIDs, new RequestOptions());
    }

    public InsightsResult convertedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        InsightsEvent event = new InsightsEvent().setEventType("conversion").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs);
        return this.client.sendEvent(event, requestOptions);
    }

    public InsightsResult convertedObjectIDsAfterSearch(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull String queryID) throws AlgoliaException {
        return this.convertedObjectIDsAfterSearch(eventName, indexName, objectIDs, queryID, new RequestOptions());
    }

    public InsightsResult convertedObjectIDsAfterSearch(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull String queryID, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        InsightsEvent event = new InsightsEvent().setEventType("conversion").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs).setQueryID(queryID);
        return this.client.sendEvent(event, requestOptions);
    }

    public InsightsResult convertedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters) throws AlgoliaException {
        InsightsEvent event = new InsightsEvent().setEventType("conversion").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setFilters(filters);
        return this.client.sendEvent(event, new RequestOptions());
    }

    public InsightsResult convertedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        InsightsEvent event = new InsightsEvent().setEventType("conversion").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setFilters(filters);
        return this.client.sendEvent(event, requestOptions);
    }

    public InsightsResult viewedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters) throws AlgoliaException {
        return this.viewedFilters(eventName, indexName, filters, new RequestOptions());
    }

    public InsightsResult viewedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        InsightsEvent event = new InsightsEvent().setEventType("view").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setFilters(filters);
        return this.client.sendEvent(event, requestOptions);
    }

    public InsightsResult viewedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs) throws AlgoliaException {
        return this.viewedObjectIDs(eventName, indexName, objectIDs, new RequestOptions());
    }

    public InsightsResult viewedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        InsightsEvent event = new InsightsEvent().setEventType("view").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs);
        return this.client.sendEvent(event, requestOptions);
    }
}

