/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SyncBaseIndex;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.sync.Task;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public interface SyncTasks<T>
extends SyncBaseIndex<T> {
    default public void waitTask(@Nonnull Task task, long timeToWait) throws AlgoliaException {
        this.waitTask(task, timeToWait, new RequestOptions());
    }

    default public void waitTask(@Nonnull Task task, long timeToWait, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        Preconditions.checkArgument((timeToWait >= 0L ? 1 : 0) != 0, (String)"timeToWait must be >= 0, was %s", (long)timeToWait);
        this.getApiClient().waitTask(task, timeToWait, requestOptions);
    }

    default public void waitTask(@Nonnull Task task) throws AlgoliaException {
        this.getApiClient().waitTask(task, 100L);
    }

    default public void waitTask(@Nonnull Long taskID) throws AlgoliaException {
        Task task = new Task().setAPIClient(this.getApiClient()).setIndex(this.getName()).setTaskID(taskID);
        this.waitTask(task);
    }

    default public void waitTask(@Nonnull Long taskID, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        Task task = new Task().setAPIClient(this.getApiClient()).setIndex(this.getName()).setTaskID(taskID);
        this.waitTask(task, requestOptions);
    }

    default public void waitTask(@Nonnull Task task, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        this.getApiClient().waitTask(task, 100L, requestOptions);
    }
}

