/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClient;
import com.algolia.search.SyncUserInsightsClient;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.http.AlgoliaRequest;
import com.algolia.search.http.AlgoliaRequestKind;
import com.algolia.search.http.HttpMethod;
import com.algolia.search.inputs.insights.InsightsEvent;
import com.algolia.search.inputs.insights.InsightsRequest;
import com.algolia.search.inputs.insights.InsightsResult;
import com.algolia.search.objects.InsightsConfig;
import com.algolia.search.objects.RequestOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class SyncInsightsClient {
    private APIClient client;
    private InsightsConfig config;
    private String host;

    public SyncInsightsClient(@Nonnull String applicationId, @Nonnull String apiKey, @Nonnull APIClient client) {
        this(applicationId, apiKey, "us", client);
    }

    public SyncInsightsClient(@Nonnull String applicationId, @Nonnull String apiKey, @Nonnull String region, @Nonnull APIClient client) {
        this(new InsightsConfig().setApplicationId(applicationId).setApiKey(apiKey).setRegion(region), client);
    }

    public SyncInsightsClient(@Nonnull InsightsConfig config, @Nonnull APIClient client) {
        this.config = config;
        this.client = client;
        this.host = "insights." + config.getRegion() + ".algolia.io";
    }

    public SyncUserInsightsClient user(@Nonnull String userToken) {
        return new SyncUserInsightsClient(userToken, this);
    }

    public InsightsResult sendEvent(@Nonnull InsightsEvent event) throws AlgoliaException {
        List<InsightsEvent> events = Collections.singletonList(event);
        return this.sendEvents(events, new RequestOptions());
    }

    public InsightsResult sendEvent(@Nonnull InsightsEvent event, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        List<InsightsEvent> events = Collections.singletonList(event);
        return this.sendEvents(events, requestOptions);
    }

    public InsightsResult sendEvents(@Nonnull List<InsightsEvent> events) throws AlgoliaException {
        return this.sendEvents(events, new RequestOptions());
    }

    public InsightsResult sendEvents(@Nonnull List<InsightsEvent> events, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        InsightsRequest request = new InsightsRequest().setEvents(events);
        return this.client.httpClient.requestInsights(new AlgoliaRequest<InsightsResult>(HttpMethod.POST, AlgoliaRequestKind.INSIGHTS_API, Arrays.asList("1", "events"), requestOptions, InsightsResult.class).setData(request), this.host);
    }
}

