/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncInsightsClient;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.inputs.insights.InsightsEvent;
import com.algolia.search.inputs.insights.InsightsResult;
import com.algolia.search.objects.RequestOptions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class AsyncUserInsightsClient {
    private String userToken;
    private AsyncInsightsClient client;

    public AsyncUserInsightsClient(String userToken, AsyncInsightsClient client) {
        this.userToken = userToken;
        this.client = client;
    }

    public CompletableFuture<InsightsResult> clickedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters) throws AlgoliaException {
        return this.clickedFilters(eventName, indexName, filters, new RequestOptions());
    }

    public CompletableFuture<InsightsResult> clickedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters, @Nonnull RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("click").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setFilters(filters);
        return this.client.sendEvent(event, requestOptions);
    }

    public CompletableFuture<InsightsResult> clickedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs) {
        return this.clickedObjectIDs(eventName, indexName, objectIDs, new RequestOptions());
    }

    public CompletableFuture<InsightsResult> clickedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("click").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs);
        return this.client.sendEvent(event, requestOptions);
    }

    public CompletableFuture<InsightsResult> clickedObjectIDsAfterSearch(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull List<Long> positions, @Nonnull String queryID) {
        return this.clickedObjectIDsAfterSearch(eventName, indexName, objectIDs, positions, queryID, new RequestOptions());
    }

    public CompletableFuture<InsightsResult> clickedObjectIDsAfterSearch(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull List<Long> positions, @Nonnull String queryID, @Nonnull RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("click").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs).setPositions(positions).setQueryID(queryID);
        return this.client.sendEvent(event, requestOptions);
    }

    public CompletableFuture<InsightsResult> convertedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs) {
        return this.convertedObjectIDs(eventName, indexName, objectIDs, new RequestOptions());
    }

    public CompletableFuture<InsightsResult> convertedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("conversion").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs);
        return this.client.sendEvent(event, requestOptions);
    }

    public CompletableFuture<InsightsResult> convertedObjectIDsAfterSearch(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull String queryID) {
        return this.convertedObjectIDsAfterSearch(eventName, indexName, objectIDs, queryID, new RequestOptions());
    }

    public CompletableFuture<InsightsResult> convertedObjectIDsAfterSearch(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull String queryID, @Nonnull RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("conversion").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs).setQueryID(queryID);
        return this.client.sendEvent(event, requestOptions);
    }

    public CompletableFuture<InsightsResult> convertedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters) {
        InsightsEvent event = new InsightsEvent().setEventType("conversion").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setFilters(filters);
        return this.client.sendEvent(event, new RequestOptions());
    }

    public CompletableFuture<InsightsResult> convertedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters, @Nonnull RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("conversion").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setFilters(filters);
        return this.client.sendEvent(event, requestOptions);
    }

    public CompletableFuture<InsightsResult> viewedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters) {
        return this.viewedFilters(eventName, indexName, filters, new RequestOptions());
    }

    public CompletableFuture<InsightsResult> viewedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters, @Nonnull RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("view").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setFilters(filters);
        return this.client.sendEvent(event, requestOptions);
    }

    public CompletableFuture<InsightsResult> viewedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs) {
        return this.viewedObjectIDs(eventName, indexName, objectIDs, new RequestOptions());
    }

    public CompletableFuture<InsightsResult> viewedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("view").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs);
        return this.client.sendEvent(event, requestOptions);
    }
}

