/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncBaseIndex;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.async.AsyncTask;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public interface AsyncTasks<T>
extends AsyncBaseIndex<T> {
    default public void waitTask(@Nonnull AsyncTask task, long timeToWait) {
        this.waitTask(task, timeToWait);
    }

    default public void waitTask(@Nonnull AsyncTask task, long timeToWait, @Nonnull RequestOptions requestOptions) {
        Preconditions.checkArgument((timeToWait >= 0L ? 1 : 0) != 0, (String)"timeToWait must be >= 0, was %s", (long)timeToWait);
        this.getApiClient().waitTask(task, timeToWait, requestOptions);
    }

    default public void waitTask(@Nonnull AsyncTask task) {
        this.waitTask(task, new RequestOptions());
    }

    default public void waitTask(@Nonnull Long taskID) throws AlgoliaException {
        AsyncTask task = new AsyncTask().setIndex(this.getName()).setTaskID(taskID);
        this.waitTask(task);
    }

    default public void waitTask(@Nonnull AsyncTask task, @Nonnull RequestOptions requestOptions) {
        this.getApiClient().waitTask(task, 100L, requestOptions);
    }
}

