/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClient;
import com.algolia.search.SyncBrowse;
import com.algolia.search.SyncDeleteByQuery;
import com.algolia.search.SyncIndexCRUD;
import com.algolia.search.SyncKey;
import com.algolia.search.SyncObjects;
import com.algolia.search.SyncPartialUpdate;
import com.algolia.search.SyncRules;
import com.algolia.search.SyncSearchForFacet;
import com.algolia.search.SyncSettings;
import com.algolia.search.SyncSynonyms;
import com.algolia.search.SyncTasks;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.inputs.BatchOperation;
import com.algolia.search.objects.Query;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.sync.TaskSingleIndex;
import com.algolia.search.responses.SearchResult;
import java.util.List;
import javax.annotation.Nonnull;

public class Index<T>
implements SyncDeleteByQuery<T>,
SyncBrowse<T>,
SyncSynonyms<T>,
SyncPartialUpdate<T>,
SyncSearchForFacet<T>,
SyncKey<T>,
SyncSettings<T>,
SyncObjects<T>,
SyncTasks<T>,
SyncIndexCRUD<T>,
SyncRules<T> {
    private final String name;
    private final Class<T> klass;
    private final APIClient client;

    Index(String name, Class<T> klass, APIClient client) {
        this.name = name;
        this.klass = klass;
        this.client = client;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getKlass() {
        return this.klass;
    }

    @Override
    public APIClient getApiClient() {
        return this.client;
    }

    public SearchResult<T> search(@Nonnull Query query) throws AlgoliaException {
        return this.search(query, new RequestOptions());
    }

    public SearchResult<T> search(@Nonnull Query query, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.client.search(this.name, query, this.klass, requestOptions);
    }

    public TaskSingleIndex batch(@Nonnull List<BatchOperation> operations) throws AlgoliaException {
        return this.batch(operations, new RequestOptions());
    }

    public TaskSingleIndex batch(@Nonnull List<BatchOperation> operations, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.client.batch(this.name, operations, requestOptions);
    }

    public String toString() {
        return "Index{name='" + this.name + '\'' + ", klass=" + this.klass + '}';
    }

    public static class Attributes {
        private String name;
        private String createdAt;
        private String updatedAt;
        private Long entries;
        private Long dataSize;
        private Long fileSize;
        private Long lastBuildTimeS;
        private Long numberOfPendingTasks;
        private Boolean pendingTask;

        public String getName() {
            return this.name;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public Long getEntries() {
            return this.entries;
        }

        public Long getDataSize() {
            return this.dataSize;
        }

        public Long getFileSize() {
            return this.fileSize;
        }

        public Long getLastBuildTimeS() {
            return this.lastBuildTimeS;
        }

        public Long getNumberOfPendingTasks() {
            return this.numberOfPendingTasks;
        }

        public Boolean getPendingTask() {
            return this.pendingTask;
        }
    }
}

