/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncAPIClient;
import com.algolia.search.AsyncAPIClientConfiguration;
import com.algolia.search.GenericAPIClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;

public abstract class AsyncAPIClientBuilder
extends GenericAPIClientBuilder {
    public AsyncAPIClientBuilder(@Nonnull String applicationId, @Nonnull String apiKey) {
        super(applicationId, apiKey);
    }

    @Override
    public AsyncAPIClientBuilder setUserAgent(@Nonnull String customAgent, @Nonnull String customAgentVersion) {
        super.setUserAgent(customAgent, customAgentVersion);
        return this;
    }

    @Override
    @Deprecated
    public AsyncAPIClientBuilder setExtraHeader(@Nonnull String key, String value) {
        super.setExtraHeader(key, value);
        return this;
    }

    @Override
    public GenericAPIClientBuilder addExtraHeader(@Nonnull String key, String value) {
        return super.addExtraHeader(key, value);
    }

    @Override
    public AsyncAPIClientBuilder setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public AsyncAPIClientBuilder setReadTimeout(int readTimeout) {
        super.setReadTimeout(readTimeout);
        return this;
    }

    @Override
    public AsyncAPIClientBuilder setObjectMapper(@Nonnull ObjectMapper objectMapper) {
        super.setObjectMapper(objectMapper);
        return this;
    }

    @Override
    public AsyncAPIClientBuilder setQueryHosts(List<String> queryHosts) {
        super.setQueryHosts(queryHosts);
        return this;
    }

    @Override
    public AsyncAPIClientBuilder setBuildHosts(List<String> buildHosts) {
        super.setBuildHosts(buildHosts);
        return this;
    }

    @Override
    public GenericAPIClientBuilder setHostDownTimeout(int hostDownTimeout) {
        super.setHostDownTimeout(hostDownTimeout);
        return this;
    }

    @Override
    public GenericAPIClientBuilder setMaxConnTotal(int maxConnTotal) {
        super.setMaxConnTotal(maxConnTotal);
        return this;
    }

    @Override
    public GenericAPIClientBuilder setMaxConnPerRoute(int maxConnPerRoute) {
        super.setMaxConnPerRoute(maxConnPerRoute);
        return this;
    }

    protected abstract AsyncAPIClient build(@Nonnull AsyncAPIClientConfiguration var1);

    public AsyncAPIClient build() {
        return this.build(Executors.newFixedThreadPool(10));
    }

    public AsyncAPIClient build(ExecutorService executor) {
        return this.build(new AsyncAPIClientConfiguration(this.applicationId, this.apiKey, this.objectMapper, this.analyticsHost, this.generateBuildHosts(), this.generateQueryHosts(), this.generateHeaders(), this.connectTimeout, this.readTimeout, this.hostDownTimeout, this.maxConnTotal, this.maxConnPerRoute, executor));
    }
}

