/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncAPIClientConfiguration;
import com.algolia.search.AsyncIndex;
import com.algolia.search.Index;
import com.algolia.search.Utils;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.http.AlgoliaRequest;
import com.algolia.search.http.AsyncAlgoliaHttpClient;
import com.algolia.search.http.HttpMethod;
import com.algolia.search.inputs.ApiKeys;
import com.algolia.search.inputs.Batch;
import com.algolia.search.inputs.BatchOperation;
import com.algolia.search.inputs.BatchOperations;
import com.algolia.search.inputs.MultipleQueriesRequests;
import com.algolia.search.inputs.OperationOnIndex;
import com.algolia.search.inputs.Requests;
import com.algolia.search.inputs.Search;
import com.algolia.search.inputs.batch.BatchAddObjectOperation;
import com.algolia.search.inputs.batch.BatchDeleteObjectOperation;
import com.algolia.search.inputs.batch.BatchPartialUpdateObjectOperation;
import com.algolia.search.inputs.batch.BatchUpdateObjectOperation;
import com.algolia.search.inputs.partial_update.PartialUpdateOperation;
import com.algolia.search.inputs.synonym.AbstractSynonym;
import com.algolia.search.objects.ApiKey;
import com.algolia.search.objects.IndexQuery;
import com.algolia.search.objects.IndexSettings;
import com.algolia.search.objects.Log;
import com.algolia.search.objects.LogType;
import com.algolia.search.objects.MultiQueriesStrategy;
import com.algolia.search.objects.Query;
import com.algolia.search.objects.SynonymQuery;
import com.algolia.search.objects.tasks.async.AsyncGenericTask;
import com.algolia.search.objects.tasks.async.AsyncTask;
import com.algolia.search.objects.tasks.async.AsyncTaskIndexing;
import com.algolia.search.objects.tasks.async.AsyncTaskSingleIndex;
import com.algolia.search.objects.tasks.async.AsyncTasksMultipleIndex;
import com.algolia.search.responses.CreateUpdateKey;
import com.algolia.search.responses.DeleteKey;
import com.algolia.search.responses.Indices;
import com.algolia.search.responses.Logs;
import com.algolia.search.responses.MultiQueriesResult;
import com.algolia.search.responses.Results;
import com.algolia.search.responses.SearchResult;
import com.algolia.search.responses.SearchSynonymResult;
import com.algolia.search.responses.TaskStatus;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class AsyncAPIClient {
    protected final AsyncAlgoliaHttpClient httpClient;
    protected final AsyncAPIClientConfiguration configuration;
    protected final Executor executor;

    AsyncAPIClient(AsyncAlgoliaHttpClient httpClient, AsyncAPIClientConfiguration configuration) {
        this.httpClient = httpClient;
        this.configuration = configuration;
        this.executor = configuration.getExecutorService();
    }

    public CompletableFuture<List<Index.Attributes>> listIndices() {
        CompletableFuture<Indices> result = this.httpClient.requestWithRetry(new AlgoliaRequest<Indices>(HttpMethod.GET, true, Arrays.asList("1", "indexes"), Indices.class));
        return result.thenApply(Indices::getItems);
    }

    public <T> AsyncIndex<T> initIndex(@Nonnull String name, @Nonnull Class<T> klass) {
        return new AsyncIndex<T>(name, klass, this);
    }

    public AsyncIndex<?> initIndex(@Nonnull String name) {
        return new AsyncIndex<Object>(name, Object.class, this);
    }

    public CompletableFuture<List<Log>> getLogs() {
        CompletableFuture<Logs> result = this.httpClient.requestWithRetry(new AlgoliaRequest<Logs>(HttpMethod.GET, false, Arrays.asList("1", "logs"), Logs.class));
        return result.thenApply(Logs::getLogs);
    }

    public CompletableFuture<List<Log>> getLogs(@Nonnull Integer offset, @Nonnull Integer length, @Nonnull LogType logType) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"offset must be >= 0, was %s", (Object[])new Object[]{offset});
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"length must be >= 0, was %s", (Object[])new Object[]{length});
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("offset", offset.toString());
        parameters.put("length", length.toString());
        parameters.put("type", logType.getName());
        CompletableFuture<Logs> result = this.httpClient.requestWithRetry(new AlgoliaRequest<Logs>(HttpMethod.GET, false, Arrays.asList("1", "logs"), Logs.class).setParameters(parameters));
        return result.thenApply(Logs::getLogs);
    }

    public CompletableFuture<List<ApiKey>> listKeys() {
        CompletableFuture<ApiKeys> result = this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKeys>(HttpMethod.GET, false, Arrays.asList("1", "keys"), ApiKeys.class));
        return result.thenApply(ApiKeys::getKeys);
    }

    public CompletableFuture<Optional<ApiKey>> getKey(@Nonnull String key) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKey>(HttpMethod.GET, false, Arrays.asList("1", "keys", key), ApiKey.class)).thenApply(Optional::ofNullable);
    }

    public CompletableFuture<DeleteKey> deleteKey(@Nonnull String key) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<DeleteKey>(HttpMethod.DELETE, false, Arrays.asList("1", "keys", key), DeleteKey.class));
    }

    public CompletableFuture<CreateUpdateKey> addKey(@Nonnull ApiKey key) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.POST, false, Arrays.asList("1", "keys"), CreateUpdateKey.class).setData(key));
    }

    public CompletableFuture<CreateUpdateKey> updateKey(@Nonnull String keyName, @Nonnull ApiKey key) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.PUT, false, Arrays.asList("1", "keys", keyName), CreateUpdateKey.class).setData(key));
    }

    public String generateSecuredApiKey(@Nonnull String privateApiKey, @Nonnull Query query) throws AlgoliaException {
        return this.generateSecuredApiKey(privateApiKey, query, null);
    }

    public String generateSecuredApiKey(@Nonnull String privateApiKey, @Nonnull Query query, String userToken) throws AlgoliaException {
        return Utils.generateSecuredApiKey(privateApiKey, query, userToken);
    }

    public <T> void waitTask(@Nonnull AsyncGenericTask<T> task, long timeToWait) {
        Preconditions.checkArgument((timeToWait >= 0L ? 1 : 0) != 0, (String)"timeToWait must be >= 0, was %s", (Object[])new Object[]{timeToWait});
        while (true) {
            TaskStatus result;
            CompletableFuture<TaskStatus> status = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskStatus>(HttpMethod.GET, false, Arrays.asList("1", "indexes", task.getIndexName(), "task", task.getTaskIDToWaitFor().toString()), TaskStatus.class));
            try {
                result = status.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                break;
            }
            if (Objects.equals("published", result.getStatus())) {
                return;
            }
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timeToWait = (timeToWait *= 2L) > 10000L ? 10000L : timeToWait;
        }
    }

    public CompletableFuture<AsyncTasksMultipleIndex> batch(@Nonnull List<BatchOperation> operations) {
        boolean atLeastOneHaveIndexNameNull = operations.stream().anyMatch(o -> o.getIndexName() == null);
        if (atLeastOneHaveIndexNameNull) {
            return Utils.completeExceptionally(new AlgoliaException("All batch operations must have an index name set"));
        }
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTasksMultipleIndex>(HttpMethod.POST, true, Arrays.asList("1", "indexes", "*", "batch"), AsyncTasksMultipleIndex.class).setData(new BatchOperations(operations))).thenApply(AsyncTasksMultipleIndex::computeIndex);
    }

    public CompletableFuture<MultiQueriesResult> multipleQueries(@Nonnull List<IndexQuery> queries) {
        return this.multipleQueries(queries, MultiQueriesStrategy.NONE);
    }

    public CompletableFuture<MultiQueriesResult> multipleQueries(@Nonnull List<IndexQuery> queries, @Nonnull MultiQueriesStrategy strategy) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<MultiQueriesResult>(HttpMethod.POST, true, Arrays.asList("1", "indexes", "*", "queries"), MultiQueriesResult.class).setData(new MultipleQueriesRequests(queries)).setParameters((Map<String, String>)ImmutableMap.of((Object)"strategy", (Object)strategy.getName())));
    }

    CompletableFuture<AsyncTask> moveIndex(String srcIndexName, String dstIndexName) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, false, Arrays.asList("1", "indexes", srcIndexName, "operation"), AsyncTask.class).setData(new OperationOnIndex("move", dstIndexName))).thenApply(s -> s.setIndex(srcIndexName));
    }

    CompletableFuture<AsyncTask> copyIndex(String srcIndexName, String dstIndexName) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, false, Arrays.asList("1", "indexes", srcIndexName, "operation"), AsyncTask.class).setData(new OperationOnIndex("copy", dstIndexName))).thenApply(s -> s.setIndex(srcIndexName));
    }

    CompletableFuture<AsyncTask> deleteIndex(String indexName) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName), AsyncTask.class)).thenApply(s -> s.setIndex(indexName));
    }

    <T> CompletableFuture<AsyncTaskIndexing> addObject(String indexName, T object) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTaskIndexing>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName), AsyncTaskIndexing.class).setData(object)).thenApply(s -> s.setIndex(indexName));
    }

    <T> CompletableFuture<AsyncTaskIndexing> addObject(String indexName, String objectID, T object) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTaskIndexing>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, objectID), AsyncTaskIndexing.class).setData(object)).thenApply(s -> s.setIndex(indexName));
    }

    <T> CompletableFuture<Optional<T>> getObject(String indexName, String objectID, Class<T> klass) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<T>(HttpMethod.GET, true, Arrays.asList("1", "indexes", indexName, objectID), klass)).thenApply(Optional::ofNullable);
    }

    <T> CompletableFuture<AsyncTaskSingleIndex> addObjects(String indexName, List<T> objects) {
        return this.batchSingleIndex(indexName, objects.stream().map(BatchAddObjectOperation::new).collect(Collectors.toList())).thenApply(s -> s.setIndex(indexName));
    }

    private CompletableFuture<AsyncTaskSingleIndex> batchSingleIndex(String indexName, List<BatchOperation> operations) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTaskSingleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "batch"), AsyncTaskSingleIndex.class).setData(new Batch(operations))).thenApply(s -> s.setIndex(indexName));
    }

    <T> CompletableFuture<AsyncTask> saveObject(String indexName, String objectID, T object) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, objectID), AsyncTask.class).setData(object)).thenApply(s -> s.setIndex(indexName));
    }

    <T> CompletableFuture<AsyncTaskSingleIndex> saveObjects(String indexName, List<T> objects) {
        return this.batchSingleIndex(indexName, objects.stream().map(BatchUpdateObjectOperation::new).collect(Collectors.toList())).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTask> deleteObject(String indexName, String objectID) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName, objectID), AsyncTask.class)).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTaskSingleIndex> deleteObjects(String indexName, List<String> objectIDs) {
        return this.batchSingleIndex(indexName, objectIDs.stream().map(BatchDeleteObjectOperation::new).collect(Collectors.toList())).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTask> clearIndex(String indexName) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "clear"), AsyncTask.class)).thenApply(s -> s.setIndex(indexName));
    }

    <T> CompletableFuture<List<T>> getObjects(String indexName, List<String> objectIDs, Class<T> klass) {
        Requests requests = new Requests(objectIDs.stream().map(o -> new Requests.Request().setIndexName(indexName).setObjectID((String)o)).collect(Collectors.toList()));
        AlgoliaRequest<Results> algoliaRequest = new AlgoliaRequest<Results>(HttpMethod.POST, true, Arrays.asList("1", "indexes", "*", "objects"), Results.class, klass);
        return this.httpClient.requestWithRetry(algoliaRequest.setData(requests)).thenApply(Results::getResults);
    }

    CompletableFuture<IndexSettings> getSettings(String indexName) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<IndexSettings>(HttpMethod.GET, true, Arrays.asList("1", "indexes", indexName, "settings"), IndexSettings.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"getVersion", (Object)"2")));
    }

    CompletableFuture<AsyncTask> setSettings(String indexName, IndexSettings settings, Boolean forwardToSlaves) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, "settings"), AsyncTask.class).setData(settings).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToSlaves", (Object)forwardToSlaves.toString()))).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<List<ApiKey>> listKeys(String indexName) {
        CompletableFuture<ApiKeys> result = this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKeys>(HttpMethod.GET, false, Arrays.asList("1", "indexes", indexName, "keys"), ApiKeys.class));
        return result.thenApply(ApiKeys::getKeys);
    }

    CompletableFuture<Optional<ApiKey>> getKey(String indexName, String key) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKey>(HttpMethod.GET, false, Arrays.asList("1", "indexes", indexName, "keys", key), ApiKey.class)).thenApply(Optional::ofNullable);
    }

    CompletableFuture<DeleteKey> deleteKey(String indexName, String key) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<DeleteKey>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName, "keys", key), DeleteKey.class));
    }

    CompletableFuture<CreateUpdateKey> addKey(String indexName, ApiKey key) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "keys"), CreateUpdateKey.class).setData(key));
    }

    CompletableFuture<CreateUpdateKey> updateKey(String indexName, String keyName, ApiKey key) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, "keys", keyName), CreateUpdateKey.class).setData(key));
    }

    <T> CompletableFuture<SearchResult<T>> search(String indexName, Query query, Class<T> klass) {
        AlgoliaRequest<SearchResult> algoliaRequest = new AlgoliaRequest<SearchResult>(HttpMethod.POST, true, Arrays.asList("1", "indexes", indexName, "query"), SearchResult.class, klass);
        return this.httpClient.requestWithRetry(algoliaRequest.setData(new Search(query)));
    }

    CompletableFuture<AsyncTaskSingleIndex> batch(String indexName, List<BatchOperation> operations) {
        boolean onSameIndex = operations.stream().allMatch(o -> Objects.equals(null, o.getIndexName()));
        if (!onSameIndex) {
            Utils.completeExceptionally(new AlgoliaException("All operations are not on the same index"));
        }
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTaskSingleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "batch"), AsyncTaskSingleIndex.class).setData(new BatchOperations(operations))).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTaskSingleIndex> partialUpdateObject(String indexName, PartialUpdateOperation operation, Boolean createIfNotExists) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTaskSingleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, operation.getObjectID(), "partial"), AsyncTaskSingleIndex.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"createIfNotExists", (Object)createIfNotExists.toString())).setData(operation.toSerialize())).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTaskSingleIndex> partialUpdateObject(String indexName, String objectID, Object object) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTaskSingleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, objectID, "partial"), AsyncTaskSingleIndex.class).setData(object)).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTask> saveSynonym(String indexName, String synonymID, AbstractSynonym content, Boolean forwardToSlaves, Boolean replaceExistingSynonyms) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, "synonyms", synonymID), AsyncTask.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToSlaves", (Object)forwardToSlaves.toString(), (Object)"replaceExistingSynonyms", (Object)replaceExistingSynonyms.toString())).setData(content)).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<Optional<AbstractSynonym>> getSynonym(String indexName, String synonymID) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AbstractSynonym>(HttpMethod.GET, false, Arrays.asList("1", "indexes", indexName, "synonyms", synonymID), AbstractSynonym.class)).thenApply(Optional::ofNullable);
    }

    CompletableFuture<AsyncTask> deleteSynonym(String indexName, String synonymID, Boolean forwardToSlaves) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName, "synonyms", synonymID), AsyncTask.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToSlaves", (Object)forwardToSlaves.toString()))).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTask> clearSynonyms(String indexName, Boolean forwardToSlaves) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "synonyms", "clear"), AsyncTask.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToSlaves", (Object)forwardToSlaves.toString()))).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<SearchSynonymResult> searchSynonyms(String indexName, SynonymQuery query) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<SearchSynonymResult>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "synonyms", "search"), SearchSynonymResult.class).setData(query));
    }

    CompletableFuture<AsyncTask> batchSynonyms(String indexName, List<AbstractSynonym> synonyms, Boolean forwardToSlaves, Boolean replaceExistingSynonyms) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "synonyms", "batch"), AsyncTask.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToSlaves", (Object)forwardToSlaves.toString(), (Object)"replaceExistingSynonyms", (Object)replaceExistingSynonyms.toString())).setData(synonyms)).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTaskSingleIndex> partialUpdateObjects(String indexName, List<Object> objects) {
        return this.batch(indexName, objects.stream().map(BatchPartialUpdateObjectOperation::new).collect(Collectors.toList())).thenApply(s -> s.setIndex(indexName));
    }
}

