/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.objects.tasks.sync;

import com.algolia.search.APIClient;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.sync.GenericTask;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import javax.annotation.Nonnull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Task
extends GenericTask<Long> {
    @JsonIgnore
    public Task setAPIClient(APIClient apiClient) {
        super.setAPIClient(apiClient);
        return this;
    }

    @Override
    public void waitForCompletion() throws AlgoliaException {
        this.waitForCompletion(RequestOptions.empty);
    }

    @Override
    public void waitForCompletion(long timeToWait) throws AlgoliaException {
        this.waitForCompletion(timeToWait, RequestOptions.empty);
    }

    public void waitForCompletion(@Nonnull RequestOptions requestOptions) throws AlgoliaException {
        this.waitForCompletion(100L, requestOptions);
    }

    public void waitForCompletion(long timeToWait, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        this.apiClient.waitTask(this, timeToWait, requestOptions);
    }

    @Override
    @JsonIgnore
    public Long getTaskIDToWaitFor() {
        return (Long)this.getTaskID();
    }

    @Override
    @JsonIgnore
    public Task setIndex(String indexName) {
        super.setIndex(indexName);
        return this;
    }

    public Task setTaskID(Long taskID) {
        super.setTaskID(taskID);
        return this;
    }

    public String toString() {
        return "Task{apiClient=" + this.apiClient + ", indexName='" + this.indexName + '\'' + ", taskID=" + this.taskID + '}';
    }
}

