/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.iterators;

import com.algolia.search.APIClient;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.objects.Query;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.responses.BrowseResult;
import java.util.Iterator;

public class IndexIterator<T>
implements Iterator<T> {
    private final APIClient apiClient;
    private final String indexName;
    private final Query query;
    private final RequestOptions options;
    private final Class<T> klass;
    private String currentCursor = null;
    private boolean isFirstRequest = true;
    private Iterator<T> currentIterator = null;

    IndexIterator(APIClient apiClient, String indexName, Query query, String cursor, RequestOptions options, Class<T> klass) {
        this.apiClient = apiClient;
        this.indexName = indexName;
        this.query = query;
        this.currentCursor = cursor;
        this.options = options;
        this.klass = klass;
    }

    @Override
    public boolean hasNext() {
        if (this.isFirstRequest) {
            this.executeQueryAndSetInnerState();
            this.isFirstRequest = false;
        }
        if (this.currentCursor != null && !this.currentIterator.hasNext()) {
            this.executeQueryAndSetInnerState();
        }
        return this.currentIterator != null && this.currentIterator.hasNext();
    }

    @Override
    public T next() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            this.executeQueryAndSetInnerState();
            this.isFirstRequest = false;
        }
        return this.currentIterator.next();
    }

    private void executeQueryAndSetInnerState() {
        BrowseResult<T> browseResult = this.doQuery(this.currentCursor);
        this.currentCursor = browseResult.getCursor();
        this.currentIterator = browseResult.getHits().iterator();
    }

    private BrowseResult<T> doQuery(String cursor) {
        try {
            BrowseResult<T> browseResult = this.apiClient.browse(this.indexName, this.query, cursor, this.klass, this.options);
            if (browseResult == null) {
                return BrowseResult.empty();
            }
            return browseResult;
        }
        catch (AlgoliaException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCursor() {
        return this.currentCursor;
    }
}

