/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncBaseIndex;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.async.AsyncTask;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public interface AsyncIndexCRUD<T>
extends AsyncBaseIndex<T> {
    default public CompletableFuture<AsyncTask> moveTo(@Nonnull String dstIndexName) {
        return this.moveTo(dstIndexName, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTask> moveTo(@Nonnull String dstIndexName, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().moveIndex(this.getName(), dstIndexName, requestOptions);
    }

    default public CompletableFuture<AsyncTask> copyTo(@Nonnull String dstIndexName) {
        return this.copyTo(dstIndexName, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTask> copyTo(@Nonnull String dstIndexName, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().copyIndex(this.getName(), dstIndexName, null, requestOptions);
    }

    default public CompletableFuture<AsyncTask> copyTo(@Nonnull String dstIndexName, @Nonnull List<String> scope, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().copyIndex(this.getName(), dstIndexName, scope, requestOptions);
    }

    default public CompletableFuture<AsyncTask> copyTo(@Nonnull String dstIndexName, @Nonnull List<String> scope) {
        return this.copyTo(dstIndexName, scope, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTask> delete() {
        return this.delete(RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTask> delete(@Nonnull RequestOptions requestOptions) {
        return this.getApiClient().deleteIndex(this.getName(), requestOptions);
    }

    default public CompletableFuture<AsyncTask> clear() {
        return this.clear(RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTask> clear(@Nonnull RequestOptions requestOptions) {
        return this.getApiClient().clearIndex(this.getName(), requestOptions);
    }
}

