/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.http;

import com.algolia.search.http.HttpMethod;
import com.algolia.search.objects.RequestOptions;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class AlgoliaRequest<T> {
    private final HttpMethod method;
    private final boolean isSearch;
    private final List<String> path;
    private final RequestOptions options;
    private Map<String, String> parameters = Maps.newHashMap();
    private Object data = null;
    private Class<T> resultClass;
    private Class<T> collectionClass;
    private Class<?> elementClass;

    public AlgoliaRequest(HttpMethod method, boolean isSearch, List<String> path, RequestOptions options, Class<T> resultClass) {
        this.method = method;
        this.isSearch = isSearch;
        this.path = path;
        this.options = options;
        this.resultClass = resultClass;
    }

    public AlgoliaRequest(HttpMethod method, boolean isSearch, List<String> path, RequestOptions options, Class<T> collectionClass, Class<?> elementClass) {
        this.method = method;
        this.isSearch = isSearch;
        this.path = path;
        this.options = options;
        this.collectionClass = collectionClass;
        this.elementClass = elementClass;
    }

    JavaType getJavaType(TypeFactory factory) {
        if (this.resultClass != null) {
            return factory.constructType(this.resultClass);
        }
        return factory.constructParametricType(this.collectionClass, new Class[]{this.elementClass});
    }

    HttpMethod getMethod() {
        return this.method;
    }

    public boolean isSearch() {
        return this.isSearch;
    }

    List<String> getPath() {
        return this.path;
    }

    boolean hasData() {
        return this.data != null;
    }

    Object getData() {
        return this.data;
    }

    public AlgoliaRequest<T> setData(Object data) {
        this.data = data;
        return this;
    }

    Map<String, String> getParameters() {
        return ImmutableMap.builder().putAll(this.parameters).putAll(this.options.generateExtraQueryParams()).build();
    }

    public AlgoliaRequest<T> setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    Map<String, String> getHeaders() {
        return this.options.generateExtraHeaders();
    }

    public String toString(String host) {
        StringBuilder result = new StringBuilder();
        result.append(this.getMethod().name);
        result.append(" https://");
        result.append(host);
        for (String string : this.getPath()) {
            result.append("/");
            result.append(string);
        }
        if (!this.getParameters().entrySet().isEmpty()) {
            result.append("?");
        }
        for (Map.Entry entry : this.getParameters().entrySet()) {
            result.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        return result.toString();
    }
}

