/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.BaseAsyncIndex;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.async.AsyncTask;
import com.algolia.search.objects.tasks.async.AsyncTaskIndexing;
import com.algolia.search.objects.tasks.async.AsyncTaskSingleIndex;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

interface AsyncObjects<T>
extends BaseAsyncIndex<T> {
    default public CompletableFuture<AsyncTaskIndexing> addObject(@Nonnull T object) {
        return this.addObject(object, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTaskIndexing> addObject(@Nonnull T object, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().addObject(this.getName(), object, requestOptions);
    }

    default public CompletableFuture<AsyncTaskIndexing> addObject(@Nonnull String objectID, @Nonnull T object) {
        return this.addObject(objectID, object, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTaskIndexing> addObject(@Nonnull String objectID, @Nonnull T object, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().addObject(this.getName(), objectID, object, requestOptions);
    }

    default public CompletableFuture<AsyncTaskSingleIndex> addObjects(@Nonnull List<T> objects) {
        return this.addObjects(objects, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTaskSingleIndex> addObjects(@Nonnull List<T> objects, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().addObjects(this.getName(), objects, requestOptions);
    }

    default public CompletableFuture<Optional<T>> getObject(@Nonnull String objectID) {
        return this.getObject(objectID, RequestOptions.empty);
    }

    default public CompletableFuture<Optional<T>> getObject(@Nonnull String objectID, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().getObject(this.getName(), objectID, this.getKlass(), requestOptions);
    }

    default public CompletableFuture<List<T>> getObjects(@Nonnull List<String> objectIDs) {
        return this.getObjects(objectIDs, RequestOptions.empty);
    }

    default public CompletableFuture<List<T>> getObjects(@Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().getObjects(this.getName(), objectIDs, this.getKlass(), requestOptions);
    }

    default public CompletableFuture<List<T>> getObjects(@Nonnull List<String> objectIDs, @Nonnull List<String> attributesToRetrieve) {
        return this.getObjects(objectIDs, attributesToRetrieve, RequestOptions.empty);
    }

    default public CompletableFuture<List<T>> getObjects(@Nonnull List<String> objectIDs, @Nonnull List<String> attributesToRetrieve, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().getObjects(this.getName(), objectIDs, attributesToRetrieve, this.getKlass(), requestOptions);
    }

    default public CompletableFuture<AsyncTask> saveObject(@Nonnull String objectID, @Nonnull T object) {
        return this.saveObject(objectID, object, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTask> saveObject(@Nonnull String objectID, @Nonnull T object, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().saveObject(this.getName(), objectID, object, requestOptions);
    }

    default public CompletableFuture<AsyncTaskSingleIndex> saveObjects(@Nonnull List<T> objects) {
        return this.saveObjects(objects, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTaskSingleIndex> saveObjects(@Nonnull List<T> objects, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().saveObjects(this.getName(), objects, requestOptions);
    }

    default public CompletableFuture<AsyncTask> deleteObject(@Nonnull String objectID) {
        return this.deleteObject(objectID, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTask> deleteObject(@Nonnull String objectID, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().deleteObject(this.getName(), objectID, requestOptions);
    }

    default public CompletableFuture<AsyncTaskSingleIndex> deleteObjects(@Nonnull List<String> objectIDs) {
        return this.deleteObjects(objectIDs, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTaskSingleIndex> deleteObjects(@Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().deleteObjects(this.getName(), objectIDs, requestOptions);
    }
}

