/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClientConfiguration;
import com.algolia.search.Index;
import com.algolia.search.IndexIterable;
import com.algolia.search.Utils;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.exceptions.AlgoliaIndexNotFoundException;
import com.algolia.search.http.AlgoliaHttpClient;
import com.algolia.search.http.AlgoliaRequest;
import com.algolia.search.http.HttpMethod;
import com.algolia.search.inputs.ApiKeys;
import com.algolia.search.inputs.Batch;
import com.algolia.search.inputs.BatchOperation;
import com.algolia.search.inputs.BatchOperations;
import com.algolia.search.inputs.MultipleQueriesRequests;
import com.algolia.search.inputs.OperationOnIndex;
import com.algolia.search.inputs.Requests;
import com.algolia.search.inputs.batch.BatchAddObjectOperation;
import com.algolia.search.inputs.batch.BatchDeleteObjectOperation;
import com.algolia.search.inputs.batch.BatchPartialUpdateObjectOperation;
import com.algolia.search.inputs.batch.BatchUpdateObjectOperation;
import com.algolia.search.inputs.partial_update.PartialUpdateOperation;
import com.algolia.search.inputs.query_rules.Rule;
import com.algolia.search.inputs.synonym.AbstractSynonym;
import com.algolia.search.objects.ApiKey;
import com.algolia.search.objects.Distinct;
import com.algolia.search.objects.IndexQuery;
import com.algolia.search.objects.IndexSettings;
import com.algolia.search.objects.Log;
import com.algolia.search.objects.LogType;
import com.algolia.search.objects.MultiQueriesStrategy;
import com.algolia.search.objects.Query;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.RuleQuery;
import com.algolia.search.objects.SynonymQuery;
import com.algolia.search.objects.tasks.sync.GenericTask;
import com.algolia.search.objects.tasks.sync.Task;
import com.algolia.search.objects.tasks.sync.TaskIndexing;
import com.algolia.search.objects.tasks.sync.TaskSingleIndex;
import com.algolia.search.objects.tasks.sync.TasksMultipleIndex;
import com.algolia.search.responses.BrowseResult;
import com.algolia.search.responses.CreateUpdateKey;
import com.algolia.search.responses.DeleteKey;
import com.algolia.search.responses.Indices;
import com.algolia.search.responses.Logs;
import com.algolia.search.responses.MultiQueriesResult;
import com.algolia.search.responses.Results;
import com.algolia.search.responses.SearchFacetResult;
import com.algolia.search.responses.SearchResult;
import com.algolia.search.responses.SearchRuleResult;
import com.algolia.search.responses.SearchSynonymResult;
import com.algolia.search.responses.TaskStatus;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class APIClient {
    protected final AlgoliaHttpClient httpClient;
    protected final APIClientConfiguration configuration;

    APIClient(AlgoliaHttpClient httpClient, APIClientConfiguration configuration) {
        this.httpClient = httpClient;
        this.configuration = configuration;
    }

    public void close() throws AlgoliaException {
        this.httpClient.close();
    }

    public List<Index.Attributes> listIndices() throws AlgoliaException {
        return this.listIndices(RequestOptions.empty);
    }

    public List<Index.Attributes> listIndices(@Nonnull RequestOptions requestOptions) throws AlgoliaException {
        Indices result = this.httpClient.requestWithRetry(new AlgoliaRequest<Indices>(HttpMethod.GET, true, Arrays.asList("1", "indexes"), requestOptions, Indices.class));
        return result.getItems();
    }

    public <T> Index<T> initIndex(@Nonnull String name, @Nonnull Class<T> klass) {
        return new Index<T>(name, klass, this);
    }

    public Index<?> initIndex(@Nonnull String name) {
        return new Index<Object>(name, Object.class, this);
    }

    public List<Log> getLogs() throws AlgoliaException {
        return this.getLogs(RequestOptions.empty);
    }

    public List<Log> getLogs(@Nonnull RequestOptions requestOptions) throws AlgoliaException {
        Logs result = this.httpClient.requestWithRetry(new AlgoliaRequest<Logs>(HttpMethod.GET, false, Arrays.asList("1", "logs"), requestOptions, Logs.class));
        return result.getLogs();
    }

    public List<Log> getLogs(@Nonnull Integer offset, @Nonnull Integer length, @Nonnull LogType logType) throws AlgoliaException {
        return this.getLogs(offset, length, logType, RequestOptions.empty);
    }

    public List<Log> getLogs(@Nonnull Integer offset, @Nonnull Integer length, @Nonnull LogType logType, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"offset must be >= 0, was %s", (Object)offset);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"length must be >= 0, was %s", (Object)length);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("offset", offset.toString());
        parameters.put("length", length.toString());
        parameters.put("type", logType.getName());
        Logs result = this.httpClient.requestWithRetry(new AlgoliaRequest<Logs>(HttpMethod.GET, false, Arrays.asList("1", "logs"), requestOptions, Logs.class).setParameters(parameters));
        return result.getLogs();
    }

    @Deprecated
    public List<ApiKey> listKeys() throws AlgoliaException {
        return this.listApiKeys();
    }

    public List<ApiKey> listApiKeys() throws AlgoliaException {
        return this.listApiKeys(RequestOptions.empty);
    }

    public List<ApiKey> listApiKeys(@Nonnull RequestOptions requestOptions) throws AlgoliaException {
        ApiKeys result = this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKeys>(HttpMethod.GET, false, Arrays.asList("1", "keys"), requestOptions, ApiKeys.class));
        return result.getKeys();
    }

    @Deprecated
    public Optional<ApiKey> getKey(@Nonnull String key) throws AlgoliaException {
        return this.getApiKey(key);
    }

    public Optional<ApiKey> getApiKey(@Nonnull String key) throws AlgoliaException {
        return this.getApiKey(key, RequestOptions.empty);
    }

    public Optional<ApiKey> getApiKey(@Nonnull String key, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return Optional.ofNullable(this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKey>(HttpMethod.GET, false, Arrays.asList("1", "keys", key), requestOptions, ApiKey.class)));
    }

    @Deprecated
    public DeleteKey deleteKey(@Nonnull String key) throws AlgoliaException {
        return this.deleteApiKey(key);
    }

    public DeleteKey deleteApiKey(@Nonnull String key) throws AlgoliaException {
        return this.deleteApiKey(key, RequestOptions.empty);
    }

    public DeleteKey deleteApiKey(@Nonnull String key, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<DeleteKey>(HttpMethod.DELETE, false, Arrays.asList("1", "keys", key), requestOptions, DeleteKey.class));
    }

    @Deprecated
    public CreateUpdateKey addKey(@Nonnull ApiKey key) throws AlgoliaException {
        return this.addApiKey(key);
    }

    public CreateUpdateKey addApiKey(@Nonnull ApiKey key) throws AlgoliaException {
        return this.addApiKey(key, RequestOptions.empty);
    }

    public CreateUpdateKey addApiKey(@Nonnull ApiKey key, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.POST, false, Arrays.asList("1", "keys"), requestOptions, CreateUpdateKey.class).setData(key));
    }

    @Deprecated
    public CreateUpdateKey updateKey(@Nonnull String keyName, @Nonnull ApiKey key) throws AlgoliaException {
        return this.updateApiKey(keyName, key);
    }

    public CreateUpdateKey updateApiKey(@Nonnull String keyName, @Nonnull ApiKey key) throws AlgoliaException {
        return this.updateApiKey(keyName, key, RequestOptions.empty);
    }

    public CreateUpdateKey updateApiKey(@Nonnull String keyName, @Nonnull ApiKey key, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.PUT, false, Arrays.asList("1", "keys", keyName), requestOptions, CreateUpdateKey.class).setData(key));
    }

    public String generateSecuredApiKey(@Nonnull String privateApiKey, @Nonnull Query query) throws AlgoliaException {
        return this.generateSecuredApiKey(privateApiKey, query, null);
    }

    public String generateSecuredApiKey(@Nonnull String privateApiKey, @Nonnull Query query, String userToken) throws AlgoliaException {
        return Utils.generateSecuredApiKey(privateApiKey, query, userToken);
    }

    public <T> void waitTask(@Nonnull GenericTask<T> task, long timeToWait) throws AlgoliaException {
        this.waitTask(task, timeToWait, RequestOptions.empty);
    }

    public <T> void waitTask(@Nonnull GenericTask<T> task, long timeToWait, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        Preconditions.checkArgument((timeToWait >= 0L ? 1 : 0) != 0, (String)"timeToWait must be >= 0, was %s", (long)timeToWait);
        TaskStatus status;
        while (!Objects.equals("published", (status = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskStatus>(HttpMethod.GET, false, Arrays.asList("1", "indexes", task.getIndexName(), "task", task.getTaskIDToWaitFor().toString()), requestOptions, TaskStatus.class))).getStatus())) {
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timeToWait = (timeToWait *= 2L) > 10000L ? 10000L : timeToWait;
        }
        return;
    }

    public TasksMultipleIndex batch(@Nonnull List<BatchOperation> operations) throws AlgoliaException {
        return this.batch(operations, RequestOptions.empty);
    }

    public TasksMultipleIndex batch(@Nonnull List<BatchOperation> operations, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        boolean atLeastOneHaveIndexNameNull = operations.stream().anyMatch(o -> o.getIndexName() == null);
        if (atLeastOneHaveIndexNameNull) {
            throw new AlgoliaException("All batch operations must have an index name set");
        }
        TasksMultipleIndex request = this.httpClient.requestWithRetry(new AlgoliaRequest<TasksMultipleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", "*", "batch"), requestOptions, TasksMultipleIndex.class).setData(new BatchOperations(operations)));
        return request.setAPIClient(this);
    }

    public MultiQueriesResult multipleQueries(@Nonnull List<IndexQuery> queries) throws AlgoliaException {
        return this.multipleQueries(queries, RequestOptions.empty);
    }

    public MultiQueriesResult multipleQueries(@Nonnull List<IndexQuery> queries, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.multipleQueries(queries, MultiQueriesStrategy.NONE, requestOptions);
    }

    public MultiQueriesResult multipleQueries(@Nonnull List<IndexQuery> queries, @Nonnull MultiQueriesStrategy strategy, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<MultiQueriesResult>(HttpMethod.POST, true, Arrays.asList("1", "indexes", "*", "queries"), requestOptions, MultiQueriesResult.class).setData(new MultipleQueriesRequests(queries)).setParameters((Map<String, String>)ImmutableMap.of((Object)"strategy", (Object)strategy.getName())));
    }

    Task moveIndex(String srcIndexName, String dstIndexName, RequestOptions requestOptions) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", srcIndexName, "operation"), requestOptions, Task.class).setData(new OperationOnIndex("move", dstIndexName)));
        return result.setAPIClient(this).setIndex(srcIndexName);
    }

    Task copyIndex(String srcIndexName, String dstIndexName, RequestOptions requestOptions) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", srcIndexName, "operation"), requestOptions, Task.class).setData(new OperationOnIndex("copy", dstIndexName)));
        return result.setAPIClient(this).setIndex(srcIndexName);
    }

    Task deleteIndex(String indexName, RequestOptions requestOptions) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName), requestOptions, Task.class));
        return result.setAPIClient(this).setIndex(indexName);
    }

    <T> TaskIndexing addObject(String indexName, T object, RequestOptions requestOptions) throws AlgoliaException {
        TaskIndexing result = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskIndexing>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName), requestOptions, TaskIndexing.class).setData(object));
        return result.setAPIClient(this).setIndex(indexName);
    }

    <T> TaskIndexing addObject(String indexName, String objectID, T object, RequestOptions requestOptions) throws AlgoliaException {
        TaskIndexing result = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskIndexing>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, objectID), requestOptions, TaskIndexing.class).setData(object));
        return result.setAPIClient(this).setIndex(indexName);
    }

    <T> Optional<T> getObject(String indexName, String objectID, Class<T> klass, RequestOptions requestOptions) throws AlgoliaException {
        return Optional.ofNullable(this.httpClient.requestWithRetry(new AlgoliaRequest<T>(HttpMethod.GET, true, Arrays.asList("1", "indexes", indexName, objectID), requestOptions, klass)));
    }

    <T> TaskSingleIndex addObjects(String indexName, List<T> objects, RequestOptions requestOptions) throws AlgoliaException {
        return this.batchSingleIndex(indexName, objects.stream().map(BatchAddObjectOperation::new).collect(Collectors.toList()), requestOptions).setAPIClient(this).setIndex(indexName);
    }

    private TaskSingleIndex batchSingleIndex(String indexName, List<BatchOperation> operations, RequestOptions requestOptions) throws AlgoliaException {
        TaskSingleIndex result = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskSingleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "batch"), requestOptions, TaskSingleIndex.class).setData(new Batch(operations)));
        return result.setAPIClient(this).setIndex(indexName);
    }

    <T> Task saveObject(String indexName, String objectID, T object, RequestOptions requestOptions) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, objectID), requestOptions, Task.class).setData(object));
        return result.setAPIClient(this).setIndex(indexName);
    }

    <T> TaskSingleIndex saveObjects(String indexName, List<T> objects, RequestOptions requestOptions) throws AlgoliaException {
        return this.batchSingleIndex(indexName, objects.stream().map(BatchUpdateObjectOperation::new).collect(Collectors.toList()), requestOptions).setAPIClient(this).setIndex(indexName);
    }

    Task deleteObject(String indexName, String objectID, RequestOptions requestOptions) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName, objectID), requestOptions, Task.class));
        return result.setAPIClient(this).setIndex(indexName);
    }

    TaskSingleIndex deleteObjects(String indexName, List<String> objectIDs, RequestOptions requestOptions) throws AlgoliaException {
        return this.batchSingleIndex(indexName, objectIDs.stream().map(BatchDeleteObjectOperation::new).collect(Collectors.toList()), requestOptions).setAPIClient(this).setIndex(indexName);
    }

    Task clearIndex(String indexName, RequestOptions requestOptions) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "clear"), requestOptions, Task.class));
        return result.setAPIClient(this).setIndex(indexName);
    }

    <T> List<T> getObjects(String indexName, List<String> objectIDs, Class<T> klass, RequestOptions requestOptions) throws AlgoliaException {
        Requests requests = new Requests(objectIDs.stream().map(o -> new Requests.Request().setIndexName(indexName).setObjectID((String)o)).collect(Collectors.toList()));
        AlgoliaRequest<Results> algoliaRequest = new AlgoliaRequest<Results>(HttpMethod.POST, true, Arrays.asList("1", "indexes", "*", "objects"), requestOptions, Results.class, klass);
        return this.httpClient.requestWithRetry(algoliaRequest.setData(requests)).getResults();
    }

    <T> List<T> getObjects(String indexName, List<String> objectIDs, List<String> attributesToRetrieve, Class<T> klass, RequestOptions requestOptions) throws AlgoliaException {
        String encodedAttributesToRetrieve = String.join((CharSequence)",", attributesToRetrieve);
        Requests requests = new Requests(objectIDs.stream().map(o -> new Requests.Request().setIndexName(indexName).setObjectID((String)o).setAttributesToRetrieve(encodedAttributesToRetrieve)).collect(Collectors.toList()));
        AlgoliaRequest<Results> algoliaRequest = new AlgoliaRequest<Results>(HttpMethod.POST, true, Arrays.asList("1", "indexes", "*", "objects"), requestOptions, Results.class, klass);
        return this.httpClient.requestWithRetry(algoliaRequest.setData(requests)).getResults();
    }

    IndexSettings getSettings(String indexName, RequestOptions requestOptions) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<IndexSettings>(HttpMethod.GET, true, Arrays.asList("1", "indexes", indexName, "settings"), requestOptions, IndexSettings.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"getVersion", (Object)"2")));
    }

    Task setSettings(String indexName, IndexSettings settings, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, "settings"), requestOptions, Task.class).setData(settings).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString())));
        return result.setAPIClient(this).setIndex(indexName);
    }

    List<ApiKey> listKeys(String indexName, RequestOptions requestOptions) throws AlgoliaException {
        ApiKeys result = this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKeys>(HttpMethod.GET, false, Arrays.asList("1", "indexes", indexName, "keys"), requestOptions, ApiKeys.class));
        return result.getKeys();
    }

    Optional<ApiKey> getKey(String indexName, String key, RequestOptions requestOptions) throws AlgoliaException {
        return Optional.ofNullable(this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKey>(HttpMethod.GET, false, Arrays.asList("1", "indexes", indexName, "keys", key), requestOptions, ApiKey.class)));
    }

    DeleteKey deleteKey(String indexName, String key, RequestOptions requestOptions) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<DeleteKey>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName, "keys", key), requestOptions, DeleteKey.class));
    }

    CreateUpdateKey addKey(String indexName, ApiKey key, RequestOptions requestOptions) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "keys"), requestOptions, CreateUpdateKey.class).setData(key));
    }

    CreateUpdateKey updateKey(String indexName, String keyName, ApiKey key, RequestOptions requestOptions) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, "keys", keyName), requestOptions, CreateUpdateKey.class).setData(key));
    }

    <T> SearchResult<T> search(String indexName, Query query, Class<T> klass, RequestOptions requestOptions) throws AlgoliaException {
        AlgoliaRequest<SearchResult> algoliaRequest = new AlgoliaRequest<SearchResult>(HttpMethod.POST, true, Arrays.asList("1", "indexes", indexName, "query"), requestOptions, SearchResult.class, klass);
        SearchResult result = this.httpClient.requestWithRetry(algoliaRequest.setData(query));
        if (result == null) {
            throw new AlgoliaIndexNotFoundException(indexName + " does not exist");
        }
        return result;
    }

    TaskSingleIndex batch(String indexName, List<BatchOperation> operations, RequestOptions requestOptions) throws AlgoliaException {
        boolean onSameIndex = operations.stream().allMatch(o -> Objects.equals(null, o.getIndexName()));
        if (!onSameIndex) {
            throw new AlgoliaException("All operations are not on the same index");
        }
        TaskSingleIndex result = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskSingleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "batch"), requestOptions, TaskSingleIndex.class).setData(new BatchOperations(operations)));
        return result.setAPIClient(this).setIndex(indexName);
    }

    TaskSingleIndex partialUpdateObject(String indexName, PartialUpdateOperation operation, Boolean createIfNotExists, RequestOptions requestOptions) throws AlgoliaException {
        TaskSingleIndex result = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskSingleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, operation.getObjectID(), "partial"), requestOptions, TaskSingleIndex.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"createIfNotExists", (Object)createIfNotExists.toString())).setData(operation.toSerialize()));
        return result.setAPIClient(this).setIndex(indexName);
    }

    TaskSingleIndex partialUpdateObject(String indexName, String objectID, Object object, RequestOptions requestOptions) throws AlgoliaException {
        TaskSingleIndex result = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskSingleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, objectID, "partial"), requestOptions, TaskSingleIndex.class).setData(object));
        return result.setAPIClient(this).setIndex(indexName);
    }

    Task saveSynonym(String indexName, String synonymID, AbstractSynonym content, Boolean forwardToReplicas, Boolean replaceExistingSynonyms, RequestOptions requestOptions) throws AlgoliaException {
        Task task = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, "synonyms", synonymID), requestOptions, Task.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString(), (Object)"replaceExistingSynonyms", (Object)replaceExistingSynonyms.toString())).setData(content));
        return task.setAPIClient(this).setIndex(indexName);
    }

    Optional<AbstractSynonym> getSynonym(String indexName, String synonymID, RequestOptions requestOptions) throws AlgoliaException {
        return Optional.ofNullable(this.httpClient.requestWithRetry(new AlgoliaRequest<AbstractSynonym>(HttpMethod.GET, false, Arrays.asList("1", "indexes", indexName, "synonyms", synonymID), requestOptions, AbstractSynonym.class)));
    }

    Task deleteSynonym(String indexName, String synonymID, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        Task task = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName, "synonyms", synonymID), requestOptions, Task.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString())));
        return task.setAPIClient(this).setIndex(indexName);
    }

    Task clearSynonyms(String indexName, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        Task task = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "synonyms", "clear"), requestOptions, Task.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString())));
        return task.setAPIClient(this).setIndex(indexName);
    }

    SearchSynonymResult searchSynonyms(String indexName, SynonymQuery query, RequestOptions requestOptions) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<SearchSynonymResult>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "synonyms", "search"), requestOptions, SearchSynonymResult.class).setData(query));
    }

    Task batchSynonyms(String indexName, List<AbstractSynonym> synonyms, Boolean forwardToReplicas, Boolean replaceExistingSynonyms, RequestOptions requestOptions) throws AlgoliaException {
        Task task = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "synonyms", "batch"), requestOptions, Task.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString(), (Object)"replaceExistingSynonyms", (Object)replaceExistingSynonyms.toString())).setData(synonyms));
        return task.setAPIClient(this).setIndex(indexName);
    }

    void deleteByQuery(String indexName, Query query, int batchSize, RequestOptions requestOptions) throws AlgoliaException {
        query = query.setAttributesToRetrieve(Collections.singletonList("objectID")).setAttributesToHighlight(Collections.emptyList()).setAttributesToSnippet(Collections.emptyList()).setHitsPerPage(1000).setDistinct(Distinct.of(false));
        ArrayList<String> objectToDelete = new ArrayList<String>(batchSize);
        for (ObjectID o : new IndexIterable<ObjectID>(this, indexName, query, requestOptions, ObjectID.class)) {
            objectToDelete.add(o.getObjectID());
            while (objectToDelete.size() >= batchSize) {
                List<String> subList = objectToDelete.subList(0, batchSize);
                this.deleteObjects(indexName, subList, requestOptions).waitForCompletion();
                subList.clear();
            }
        }
        if (!objectToDelete.isEmpty()) {
            this.deleteObjects(indexName, objectToDelete, requestOptions).waitForCompletion();
        }
    }

    Task deleteBy(String indexName, Query query, RequestOptions requestOptions) throws AlgoliaException {
        query = query == null ? new Query() : query;
        AlgoliaRequest<Task> algoliaRequest = new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "deleteByQuery"), requestOptions, Task.class).setData(query);
        return this.httpClient.requestWithRetry(algoliaRequest).setIndex(indexName).setAPIClient(this);
    }

    TaskSingleIndex partialUpdateObjects(String indexName, List<Object> objects, RequestOptions requestOptions) throws AlgoliaException {
        TaskSingleIndex task = this.batch(indexName, objects.stream().map(BatchPartialUpdateObjectOperation::new).collect(Collectors.toList()), requestOptions);
        return task.setAPIClient(this).setIndex(indexName);
    }

    <T> BrowseResult<T> browse(String indexName, Query query, String cursor, Class<T> klass, RequestOptions requestOptions) throws AlgoliaException {
        AlgoliaRequest<BrowseResult> algoliaRequest = new AlgoliaRequest<BrowseResult>(HttpMethod.POST, true, Arrays.asList("1", "indexes", indexName, "browse"), requestOptions, BrowseResult.class, klass).setData(query.setCursor(cursor));
        return this.httpClient.requestWithRetry(algoliaRequest);
    }

    SearchFacetResult searchForFacetValues(String indexName, String facetName, String facetQuery, Query query, RequestOptions requestOptions) throws AlgoliaException {
        query = query == null ? new Query() : query;
        query = query.addCustomParameter("facetQuery", facetQuery);
        AlgoliaRequest<SearchFacetResult> algoliaRequest = new AlgoliaRequest<SearchFacetResult>(HttpMethod.POST, true, Arrays.asList("1", "indexes", indexName, "facets", facetName, "query"), requestOptions, SearchFacetResult.class).setData(query);
        return this.httpClient.requestWithRetry(algoliaRequest);
    }

    Task saveRule(String indexName, String ruleId, Rule queryRule, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        Task task = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, "rules", ruleId), requestOptions, Task.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString())).setData(queryRule));
        return task.setAPIClient(this).setIndex(indexName);
    }

    Optional<Rule> getRule(String indexName, String queryRulesID, RequestOptions requestOptions) throws AlgoliaException {
        return Optional.ofNullable(this.httpClient.requestWithRetry(new AlgoliaRequest<Rule>(HttpMethod.GET, false, Arrays.asList("1", "indexes", indexName, "rules", queryRulesID), requestOptions, Rule.class)));
    }

    Task deleteRule(String indexName, String queryRulesID, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        Task task = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName, "rules", queryRulesID), requestOptions, Task.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString())));
        return task.setAPIClient(this).setIndex(indexName);
    }

    Task clearRules(String indexName, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        Task task = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "rules", "clear"), requestOptions, Task.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString())));
        return task.setAPIClient(this).setIndex(indexName);
    }

    SearchRuleResult searchRules(String indexName, RuleQuery query, RequestOptions requestOptions) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<SearchRuleResult>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "rules", "search"), requestOptions, SearchRuleResult.class).setData(query));
    }

    Task batchRules(String indexName, List<Rule> queryRules, Boolean forwardToReplicas, Boolean clearExistingRules, RequestOptions requestOptions) throws AlgoliaException {
        Task task = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "rules", "batch"), requestOptions, Task.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString(), (Object)"clearExistingRules", (Object)clearExistingRules.toString())).setData(queryRules));
        return task.setAPIClient(this).setIndex(indexName);
    }

    private static class ObjectID {
        private String objectID;

        private ObjectID() {
        }

        public String getObjectID() {
            return this.objectID;
        }

        public ObjectID setObjectID(String objectID) {
            this.objectID = objectID;
            return this;
        }
    }
}

