/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClientConfiguration;
import com.algolia.search.ApacheHttpClient;
import com.algolia.search.AsyncAPIClientConfiguration;
import com.algolia.search.http.AlgoliaRequest;
import com.algolia.search.http.AsyncAlgoliaHttpClient;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import net.javacrumbs.futureconverter.java8guava.FutureConverter;

class AsyncHttpClient
extends AsyncAlgoliaHttpClient {
    private final ApacheHttpClient client;
    private final ListeningExecutorService service;

    AsyncHttpClient(AsyncAPIClientConfiguration configuration) {
        this.service = MoreExecutors.listeningDecorator((ExecutorService)configuration.getExecutorService());
        this.client = new ApacheHttpClient((APIClientConfiguration)configuration);
    }

    public <T> CompletableFuture<T> requestWithRetry(@Nonnull AlgoliaRequest<T> request) {
        return FutureConverter.toCompletableFuture((ListenableFuture)this.service.submit(() -> this.client.requestWithRetry(request)));
    }
}

