/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.models.synonyms;

import com.algolia.search.com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Synonym
implements Serializable {
    private String objectID;
    private String type;
    private List<String> synonyms;
    private String input;
    private String word;
    private List<String> corrections;
    private String placeholder;
    private List<String> replacements;

    public static Synonym createSynonym(String objectID, List<String> synonyms) {
        return new Synonym().setObjectID(objectID).setSynonyms(synonyms).setType("synonym");
    }

    public static Synonym createOneWaySynonym(String objectID, String input, List<String> synonyms) {
        return new Synonym().setObjectID(objectID).setInput(input).setSynonyms(synonyms).setType("oneWaySynonym");
    }

    public static Synonym createPlaceHolder(String objectID, String placeholder, List<String> replacements) {
        return new Synonym().setObjectID(objectID).setReplacements(replacements).setPlaceholder(placeholder).setType("placeholder");
    }

    public static Synonym createAltCorrection1(String objectID, String word, List<String> corrections) {
        return new Synonym().setObjectID(objectID).setWord(word).setCorrections(corrections).setType("altCorrection1");
    }

    public static Synonym createAltCorrection2(String objectID, String word, List<String> corrections) {
        return new Synonym().setObjectID(objectID).setWord(word).setCorrections(corrections).setType("altCorrection2");
    }

    public String getObjectID() {
        return this.objectID;
    }

    public Synonym setObjectID(String objectID) {
        this.objectID = objectID;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Synonym setType(String type) {
        this.type = type;
        return this;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public Synonym setSynonyms(List<String> synonyms) {
        this.synonyms = synonyms;
        return this;
    }

    public String getInput() {
        return this.input;
    }

    public Synonym setInput(String input) {
        this.input = input;
        return this;
    }

    public String getWord() {
        return this.word;
    }

    public Synonym setWord(String word) {
        this.word = word;
        return this;
    }

    public List<String> getCorrections() {
        return this.corrections;
    }

    public Synonym setCorrections(List<String> corrections) {
        this.corrections = corrections;
        return this;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public Synonym setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public List<String> getReplacements() {
        return this.replacements;
    }

    public Synonym setReplacements(List<String> replacements) {
        this.replacements = replacements;
        return this;
    }
}

