/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.InsightsClient;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.javax.annotation.Nonnull;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.insights.InsightsEvent;
import com.algolia.search.models.insights.InsightsResult;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class UserInsightsClient {
    private final String userToken;
    private final InsightsClient insightsClient;

    public UserInsightsClient(String userToken, InsightsClient insightsClient) {
        this.userToken = userToken;
        this.insightsClient = insightsClient;
    }

    public InsightsResult clickedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters) {
        return LaunderThrowable.await(this.clickedFiltersAsync(eventName, indexName, filters));
    }

    public InsightsResult clickedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.clickedFiltersAsync(eventName, indexName, filters, requestOptions));
    }

    public CompletableFuture<InsightsResult> clickedFiltersAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters) {
        return this.clickedFiltersAsync(eventName, indexName, filters, null);
    }

    public CompletableFuture<InsightsResult> clickedFiltersAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters, RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("click").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setFilters(filters);
        return this.insightsClient.sendEventAsync(event, requestOptions);
    }

    public InsightsResult clickedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs) {
        return LaunderThrowable.await(this.clickedObjectIDsAsync(eventName, indexName, objectIDs));
    }

    public InsightsResult clickedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.clickedObjectIDsAsync(eventName, indexName, objectIDs, requestOptions));
    }

    public CompletableFuture<InsightsResult> clickedObjectIDsAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs) {
        return this.clickedObjectIDsAsync(eventName, indexName, objectIDs, null);
    }

    public CompletableFuture<InsightsResult> clickedObjectIDsAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("click").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs);
        return this.insightsClient.sendEventAsync(event, requestOptions);
    }

    public InsightsResult clickedObjectIDsAfterSearch(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull List<Long> positions, @Nonnull String queryID) {
        return LaunderThrowable.await(this.clickedObjectIDsAfterSearchAsync(eventName, indexName, objectIDs, positions, queryID));
    }

    public InsightsResult clickedObjectIDsAfterSearch(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull List<Long> positions, @Nonnull String queryID, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.clickedObjectIDsAfterSearchAsync(eventName, indexName, objectIDs, positions, queryID, requestOptions));
    }

    public CompletableFuture<InsightsResult> clickedObjectIDsAfterSearchAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull List<Long> positions, @Nonnull String queryID) {
        return this.clickedObjectIDsAfterSearchAsync(eventName, indexName, objectIDs, positions, queryID, null);
    }

    public CompletableFuture<InsightsResult> clickedObjectIDsAfterSearchAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull List<Long> positions, @Nonnull String queryID, RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("click").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs).setPositions(positions).setQueryID(queryID);
        return this.insightsClient.sendEventAsync(event, requestOptions);
    }

    public InsightsResult convertedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs) {
        return LaunderThrowable.await(this.convertedObjectIDsAsync(eventName, indexName, objectIDs));
    }

    public InsightsResult convertedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.convertedObjectIDsAsync(eventName, indexName, objectIDs, requestOptions));
    }

    public CompletableFuture<InsightsResult> convertedObjectIDsAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs) {
        return this.convertedObjectIDsAsync(eventName, indexName, objectIDs, null);
    }

    public CompletableFuture<InsightsResult> convertedObjectIDsAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("conversion").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs);
        return this.insightsClient.sendEventAsync(event, requestOptions);
    }

    public InsightsResult convertedObjectIDsAfterSearch(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull String queryID) {
        return LaunderThrowable.await(this.convertedObjectIDsAfterSearchAsync(eventName, indexName, objectIDs, queryID));
    }

    public InsightsResult convertedObjectIDsAfterSearch(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull String queryID, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.convertedObjectIDsAfterSearchAsync(eventName, indexName, objectIDs, queryID, requestOptions));
    }

    public CompletableFuture<InsightsResult> convertedObjectIDsAfterSearchAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull String queryID) {
        return this.convertedObjectIDsAfterSearchAsync(eventName, indexName, objectIDs, queryID, null);
    }

    public CompletableFuture<InsightsResult> convertedObjectIDsAfterSearchAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, @Nonnull String queryID, RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("conversion").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs).setQueryID(queryID);
        return this.insightsClient.sendEventAsync(event, requestOptions);
    }

    public InsightsResult convertedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters) {
        return LaunderThrowable.await(this.convertedFiltersAsync(eventName, indexName, filters));
    }

    public InsightsResult convertedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.convertedFiltersAsync(eventName, indexName, filters, requestOptions));
    }

    public CompletableFuture<InsightsResult> convertedFiltersAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters) {
        InsightsEvent event = new InsightsEvent().setEventType("conversion").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setFilters(filters);
        return this.insightsClient.sendEventAsync(event, null);
    }

    public CompletableFuture<InsightsResult> convertedFiltersAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters, RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("conversion").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setFilters(filters);
        return this.insightsClient.sendEventAsync(event, requestOptions);
    }

    public InsightsResult viewedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters) {
        return LaunderThrowable.await(this.viewedFiltersAsync(eventName, indexName, filters));
    }

    public InsightsResult viewedFilters(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.viewedFiltersAsync(eventName, indexName, filters, requestOptions));
    }

    public CompletableFuture<InsightsResult> viewedFiltersAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters) {
        return this.viewedFiltersAsync(eventName, indexName, filters, null);
    }

    public CompletableFuture<InsightsResult> viewedFiltersAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> filters, RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("view").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setFilters(filters);
        return this.insightsClient.sendEventAsync(event, requestOptions);
    }

    public InsightsResult viewedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs) {
        return LaunderThrowable.await(this.viewedObjectIDsAsync(eventName, indexName, objectIDs));
    }

    public InsightsResult viewedObjectIDs(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.viewedObjectIDsAsync(eventName, indexName, objectIDs, requestOptions));
    }

    public CompletableFuture<InsightsResult> viewedObjectIDsAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs) {
        return this.viewedObjectIDsAsync(eventName, indexName, objectIDs, null);
    }

    public CompletableFuture<InsightsResult> viewedObjectIDsAsync(@Nonnull String eventName, @Nonnull String indexName, @Nonnull List<String> objectIDs, RequestOptions requestOptions) {
        InsightsEvent event = new InsightsEvent().setEventType("view").setUserToken(this.userToken).setEventName(eventName).setIndex(indexName).setObjectIDs(objectIDs);
        return this.insightsClient.sendEventAsync(event, requestOptions);
    }
}

