/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.TaskStatusResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;

class TaskUtils {
    private TaskUtils() {
        throw new IllegalStateException("Utility class");
    }

    static void waitTask(long taskId, long timeToWait, RequestOptions requestOptions, BiFunction<Long, RequestOptions, CompletableFuture<TaskStatusResponse>> getTaskAsync) {
        while (true) {
            TaskStatusResponse response;
            try {
                response = getTaskAsync.apply(taskId, requestOptions).get();
            }
            catch (InterruptedException | ExecutionException e) {
                break;
            }
            if (Objects.equals("published", response.getStatus())) {
                return;
            }
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            timeToWait *= 2L;
            timeToWait = Math.min(timeToWait, 10000L);
        }
    }
}

