/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SearchClientBase;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.javax.annotation.Nonnull;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.indexing.BatchOperation;
import com.algolia.search.models.indexing.BatchRequest;
import com.algolia.search.models.indexing.MultipleGetObject;
import com.algolia.search.models.indexing.MultipleGetObjectsRequest;
import com.algolia.search.models.indexing.MultipleGetObjectsResponse;
import com.algolia.search.models.indexing.MultipleIndexBatchIndexingResponse;
import com.algolia.search.models.indexing.MultipleQueriesRequest;
import com.algolia.search.models.indexing.MultipleQueriesResponse;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public interface SearchClientMultipleOperations
extends SearchClientBase {
    default public <T> MultipleGetObjectsResponse<T> multipleGetObjects(List<MultipleGetObject> queries, Class<T> clazz) {
        return this.multipleGetObjects(queries, clazz, null);
    }

    default public <T> MultipleGetObjectsResponse<T> multipleGetObjects(List<MultipleGetObject> queries, Class<T> clazz, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.multipleGetObjectsAsync(queries, clazz, requestOptions));
    }

    default public <T> CompletableFuture<MultipleGetObjectsResponse<T>> multipleGetObjectsAsync(List<MultipleGetObject> queries, Class<T> clazz) {
        return this.multipleGetObjectsAsync(queries, clazz, null);
    }

    default public <T> CompletableFuture<MultipleGetObjectsResponse<T>> multipleGetObjectsAsync(List<MultipleGetObject> queries, Class<T> clazz, RequestOptions requestOptions) {
        Objects.requireNonNull(queries, "Queries is required");
        Objects.requireNonNull(clazz, "Class is required");
        MultipleGetObjectsRequest request = new MultipleGetObjectsRequest(queries);
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/*/objects", CallType.READ, request, MultipleGetObjectsResponse.class, clazz, requestOptions).thenComposeAsync(resp -> {
            CompletableFuture<MultipleGetObjectsResponse> r = new CompletableFuture<MultipleGetObjectsResponse>();
            r.complete((MultipleGetObjectsResponse)resp);
            return r;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public <T> MultipleIndexBatchIndexingResponse multipleBatch(@Nonnull List<BatchOperation<T>> operations) {
        return LaunderThrowable.await(this.multipleBatchAsync(operations, null));
    }

    default public <T> MultipleIndexBatchIndexingResponse multipleBatch(@Nonnull List<BatchOperation<T>> operations, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.multipleBatchAsync(operations, requestOptions));
    }

    default public <T> CompletableFuture<MultipleIndexBatchIndexingResponse> multipleBatchAsync(@Nonnull List<BatchOperation<T>> operations) {
        return this.multipleBatchAsync(operations, null);
    }

    default public <T> CompletableFuture<MultipleIndexBatchIndexingResponse> multipleBatchAsync(@Nonnull List<BatchOperation<T>> operations, RequestOptions requestOptions) {
        Objects.requireNonNull(operations, "Operations are required");
        BatchRequest<T> request = new BatchRequest<T>(operations);
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/*/batch", CallType.WRITE, request, MultipleIndexBatchIndexingResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public <T> MultipleQueriesResponse<T> multipleQueries(@Nonnull MultipleQueriesRequest request, @Nonnull Class<T> clazz) {
        return LaunderThrowable.await(this.multipleQueriesAsync(request, clazz, null));
    }

    default public <T> MultipleQueriesResponse<T> multipleQueries(@Nonnull MultipleQueriesRequest request, @Nonnull Class<T> clazz, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.multipleQueriesAsync(request, clazz, requestOptions));
    }

    default public <T> CompletableFuture<MultipleQueriesResponse<T>> multipleQueriesAsync(@Nonnull MultipleQueriesRequest request, @Nonnull Class<T> clazz) {
        return this.multipleQueriesAsync(request, clazz, null);
    }

    default public <T> CompletableFuture<MultipleQueriesResponse<T>> multipleQueriesAsync(@Nonnull MultipleQueriesRequest request, @Nonnull Class<T> clazz, RequestOptions requestOptions) {
        Objects.requireNonNull(request, "Request is required");
        Objects.requireNonNull(clazz, "A Class is required");
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/*/queries", CallType.READ, request, MultipleQueriesResponse.class, clazz, requestOptions).thenComposeAsync(resp -> {
            CompletableFuture<MultipleQueriesResponse> r = new CompletableFuture<MultipleQueriesResponse>();
            r.complete((MultipleQueriesResponse)resp);
            return r;
        }, (Executor)this.getConfig().getExecutor());
    }
}

