/*
 * Decompiled with CFR 0.152.
 */
package com.alexnederlof.jasperreport;

import com.alexnederlof.jasperreport.CompileTask;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRJdtCompiler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

@Mojo(defaultPhase=LifecyclePhase.PROCESS_RESOURCES, name="jasper", requiresDependencyResolution=ResolutionScope.COMPILE)
public class JasperReporter
extends AbstractMojo {
    static final String ERROR_JRE_COMPILE_ERROR = "Some Jasper reports could not be compiled. See log above for details.";
    @Parameter(defaultValue="net.sf.jasperreports.engine.design.JRJdtCompiler", required=true)
    private String compiler;
    @Parameter(defaultValue="${project.build.outputDirectory}/jasper")
    private File outputDirectory;
    @Parameter(defaultValue="src/main/jasperreports")
    private File sourceDirectory;
    @Parameter(defaultValue=".jrxml")
    private String sourceFileExt;
    @Parameter(defaultValue=".jasper")
    private String outputFileExt;
    @Parameter(defaultValue="true")
    private boolean xmlValidation;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="4")
    private int numberOfThreads;
    @Parameter(property="project.compileClasspathElements")
    private List<String> classpathElements;
    @Parameter
    private Map<String, String> additionalProperties;
    @Parameter(defaultValue="true")
    private boolean failOnMissingSourceDirectory = true;
    @Parameter(defaultValue="org.codehaus.plexus.compiler.util.scan.StaleSourceScanner")
    private String sourceScanner = StaleSourceScanner.class.getName();
    @Parameter
    private String additionalClasspath;
    private Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        this.log = this.getLog();
        if (this.verbose) {
            this.logConfiguration(this.log);
        }
        this.checkOutDirWritable(this.outputDirectory);
        SuffixMapping mapping = new SuffixMapping(this.sourceFileExt, this.outputFileExt);
        Set<File> sources = this.jrxmlFilesToCompile((SourceMapping)mapping);
        if (sources.isEmpty()) {
            this.log.info((CharSequence)"Nothing to compile - all Jasper reports are up to date");
        } else {
            this.log.info((CharSequence)("Compiling " + sources.size() + " Jasper reports design files."));
            List<CompileTask> tasks = this.generateTasks(sources, (SourceMapping)mapping);
            if (tasks.isEmpty()) {
                this.log.info((CharSequence)"Nothing to compile");
                return;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClassLoader(classLoader));
            try {
                this.configureJasper();
                this.executeTasks(tasks);
            }
            finally {
                if (classLoader != null) {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            }
        }
    }

    protected Set<File> jrxmlFilesToCompile(SourceMapping mapping) throws MojoExecutionException {
        if (!this.sourceDirectory.isDirectory()) {
            String message = this.sourceDirectory.getName() + " is not a directory";
            if (this.failOnMissingSourceDirectory) {
                throw new IllegalArgumentException(message);
            }
            this.log.warn((CharSequence)(message + ", skip JasperReports reports compiling."));
            return Collections.emptySet();
        }
        try {
            SourceInclusionScanner scanner = this.createSourceInclusionScanner();
            scanner.addSourceMapping(mapping);
            return scanner.getIncludedSources(this.sourceDirectory, this.outputDirectory);
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + this.sourceDirectory + "'.", (Exception)((Object)e));
        }
    }

    private void logConfiguration(Log log) {
        log.info((CharSequence)"Generating Jasper reports");
        log.info((CharSequence)("Output dir: " + this.outputDirectory.getAbsolutePath()));
        log.info((CharSequence)("Source dir: " + this.sourceDirectory.getAbsolutePath()));
        log.info((CharSequence)("Output ext: " + this.outputFileExt));
        log.info((CharSequence)("Source ext: " + this.sourceFileExt));
        log.info((CharSequence)("Addition properties: " + this.additionalProperties));
        log.info((CharSequence)("XML Validation: " + this.xmlValidation));
        log.info((CharSequence)("JasperReports Compiler: " + this.compiler));
        log.info((CharSequence)("Number of threads: " + this.numberOfThreads));
        log.info((CharSequence)("classpathElements: " + this.classpathElements));
        log.info((CharSequence)("additionalClasspath: " + this.additionalClasspath));
        log.info((CharSequence)("Source Scanner: " + this.sourceScanner));
    }

    private void checkOutDirWritable(File outputDirectory) throws MojoExecutionException {
        if (!outputDirectory.exists()) {
            this.checkIfOutputCanBeCreated();
            this.checkIfOutputDirIsWritable();
            if (this.verbose) {
                this.log.info((CharSequence)"Output dir check OK");
            }
        } else if (!outputDirectory.canWrite()) {
            throw new MojoExecutionException("The output dir exists but was not writable. Try running maven with the 'clean' goal.");
        }
    }

    private void configureJasper() {
        DefaultJasperReportsContext jrContext = DefaultJasperReportsContext.getInstance();
        jrContext.setProperty("net.sf.jasperreports.compiler.xml.validation", String.valueOf(this.xmlValidation));
        jrContext.setProperty("net.sf.jasperreports.compiler.", this.compiler == null ? JRJdtCompiler.class.getName() : this.compiler);
        jrContext.setProperty("net.sf.jasperreports.compiler.keep.java.file", Boolean.FALSE.toString());
        if (this.additionalProperties != null) {
            this.configureAdditionalProperties(JRPropertiesUtil.getInstance((JasperReportsContext)jrContext));
        }
    }

    private ClassLoader getClassLoader(ClassLoader classLoader) throws MojoExecutionException {
        ArrayList<URL> classpath = new ArrayList<URL>();
        if (this.classpathElements != null) {
            for (String element : this.classpathElements) {
                try {
                    File f = new File(element);
                    classpath.add(f.toURI().toURL());
                    this.log.debug((CharSequence)("Added to classpath " + element));
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error setting classpath " + element + " " + e.getMessage());
                }
            }
        }
        if (this.additionalClasspath != null) {
            for (String element : this.additionalClasspath.split("[;]")) {
                try {
                    File f = new File(element);
                    classpath.add(f.toURI().toURL());
                    this.log.debug((CharSequence)("Added additionalClasspath to classpath " + element));
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error setting classpath " + element + " " + e.getMessage());
                }
            }
        }
        URL[] urls = classpath.toArray(new URL[classpath.size()]);
        return new URLClassLoader(urls, classLoader);
    }

    private void configureAdditionalProperties(JRPropertiesUtil propertiesUtil) {
        for (Map.Entry<String, String> additionalProperty : this.additionalProperties.entrySet()) {
            propertiesUtil.setProperty(additionalProperty.getKey(), additionalProperty.getValue());
        }
    }

    private void checkIfOutputCanBeCreated() throws MojoExecutionException {
        if (!this.outputDirectory.mkdirs()) {
            throw new MojoExecutionException((Object)this, "Output folder could not be created", "Outputfolder " + this.outputDirectory.getAbsolutePath() + " is not a folder");
        }
    }

    private void checkIfOutputDirIsWritable() throws MojoExecutionException {
        if (!this.outputDirectory.canWrite()) {
            throw new MojoExecutionException((Object)this, "Could not write to output folder", "Could not write to output folder: " + this.outputDirectory.getAbsolutePath());
        }
    }

    private String getRelativePath(String root, File file) throws MojoExecutionException {
        try {
            return file.getCanonicalPath().substring(root.length() + 1);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not getCanonicalPath from file " + file, (Exception)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<CompileTask> generateTasks(Set<File> sources, SourceMapping mapping) throws MojoExecutionException {
        LinkedList<CompileTask> tasks = new LinkedList<CompileTask>();
        try {
            String root = this.sourceDirectory.getCanonicalPath();
            for (File src : sources) {
                String srcName = this.getRelativePath(root, src);
                try {
                    File destination = (File)mapping.getTargetFiles(this.outputDirectory, srcName).iterator().next();
                    this.createDestination(destination.getParentFile());
                    tasks.add(new CompileTask(src, destination, this.log, this.verbose));
                }
                catch (InclusionScanException e) {
                    throw new MojoExecutionException("Error compiling report design : " + src, (Exception)((Object)e));
                    return tasks;
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not getCanonicalPath from source directory " + this.sourceDirectory, (Exception)e);
        }
    }

    private void createDestination(File destinationDirectory) throws MojoExecutionException {
        if (!destinationDirectory.exists()) {
            if (destinationDirectory.mkdirs()) {
                this.log.debug((CharSequence)("Created directory " + destinationDirectory.getName()));
            } else {
                throw new MojoExecutionException("Could not create directory " + destinationDirectory.getName());
            }
        }
    }

    private void executeTasks(List<CompileTask> tasks) throws MojoExecutionException {
        try {
            long t1 = System.currentTimeMillis();
            List<Future<Void>> output = Executors.newFixedThreadPool(this.numberOfThreads).invokeAll(tasks);
            long time = System.currentTimeMillis() - t1;
            this.log.info((CharSequence)("Generated " + output.size() + " jasper reports in " + (double)time / 1000.0 + " seconds"));
            this.checkForExceptions(output);
        }
        catch (InterruptedException e) {
            this.log.error((CharSequence)"Failed to compile Japser reports: Interrupted!", (Throwable)e);
            throw new MojoExecutionException("Error while compiling Jasper reports", (Exception)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof JRException) {
                throw new MojoExecutionException(ERROR_JRE_COMPILE_ERROR, (Exception)e);
            }
            throw new MojoExecutionException("Error while compiling Jasper reports", (Exception)e);
        }
    }

    private void checkForExceptions(List<Future<Void>> output) throws InterruptedException, ExecutionException {
        for (Future<Void> future : output) {
            future.get();
        }
    }

    private SourceInclusionScanner createSourceInclusionScanner() throws MojoExecutionException {
        if (this.sourceScanner.equals(StaleSourceScanner.class.getName())) {
            return new StaleSourceScanner();
        }
        if (this.sourceScanner.equals(SimpleSourceInclusionScanner.class.getName())) {
            return new SimpleSourceInclusionScanner(Collections.singleton("**/*" + this.sourceFileExt), Collections.emptySet());
        }
        throw new MojoExecutionException("sourceScanner not supported: '" + this.sourceScanner + "'.");
    }
}

