/*
 * Decompiled with CFR 0.152.
 */
package com.alexnederlof.jasperreport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import org.apache.maven.plugin.logging.Log;

public class CompileTask
implements Callable<Void> {
    private final File source;
    private final File destFolder;
    private final String sourceExtension;
    private final String outExtension;
    private final Log log;
    private final boolean verbose;

    public CompileTask(File source, File destFolder, String sourceExtension, String outExtension, Log log, boolean verbose) {
        this.source = source;
        this.destFolder = destFolder;
        this.sourceExtension = sourceExtension;
        this.outExtension = outExtension;
        this.log = log;
        this.verbose = verbose;
    }

    @Override
    public Void call() throws Exception {
        File out = null;
        try {
            if (this.source.getAbsolutePath().endsWith(this.sourceExtension)) {
                String newFilename = this.getNewFilename();
                out = new File(this.destFolder, newFilename);
                JasperCompileManager.compileReportToStream((InputStream)new FileInputStream(this.source), (OutputStream)new FileOutputStream(out));
                if (this.verbose) {
                    this.log.info((CharSequence)("Compiling " + newFilename));
                }
            }
        }
        catch (Exception e) {
            this.cleanUpAndThrowError(out, e);
        }
        return null;
    }

    private void cleanUpAndThrowError(File out, Exception e) throws JRException {
        this.log.error((CharSequence)("Could not compile " + this.source.getName()), (Throwable)e);
        if (out != null && out.exists()) {
            out.delete();
        }
        throw new JRException("Could not compile " + this.source.getName(), (Throwable)e);
    }

    private String getNewFilename() {
        return this.source.getName().substring(0, this.source.getName().lastIndexOf(this.sourceExtension)) + this.outExtension;
    }
}

