/*
 * Decompiled with CFR 0.152.
 */
package com.alexkasko.springjdbc.iterable;

import com.alexkasko.springjdbc.iterable.CloseableIterator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.InvalidResultSetAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;

class StatementCloseableIterator<T>
implements CloseableIterator<T> {
    private static final Log logger = LogFactory.getLog(StatementCloseableIterator.class);
    private final DataSource ds;
    private final Connection conn;
    private final Statement stmt;
    private final ResultSet wrappedRs;
    private final ResultSet rsToUse;
    private final RowMapper<T> mapper;
    private State state = State.NOT_READY;
    private T next;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private int rowNum = 0;

    StatementCloseableIterator(DataSource ds, Connection conn, Statement stmt, ResultSet wrappedRs, ResultSet rsToUse, RowMapper<T> mapper) {
        this.ds = ds;
        this.conn = conn;
        this.stmt = stmt;
        this.wrappedRs = wrappedRs;
        this.rsToUse = rsToUse;
        this.mapper = mapper;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        return this.next;
    }

    @Override
    public final boolean hasNext() {
        if (this.state == State.FAILED) {
            throw new IllegalStateException();
        }
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        JdbcUtils.closeResultSet((ResultSet)this.wrappedRs);
        JdbcUtils.closeStatement((Statement)this.stmt);
        DataSourceUtils.releaseConnection((Connection)this.conn, (DataSource)this.ds);
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed.get()) {
            logger.warn((Object)("GC level message: iterator wasn't closed: [" + this + "]"));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResultSetCloseableIterator");
        sb.append("{ds=").append(this.ds);
        sb.append(", conn=").append(this.conn);
        sb.append(", stmt=").append(this.stmt);
        sb.append(", wrappedRs=").append(this.wrappedRs);
        sb.append(", rsToUse=").append(this.rsToUse);
        sb.append(", mapper=").append(this.mapper);
        sb.append(", closed=").append(this.closed);
        sb.append(", rowNum=").append(this.rowNum);
        sb.append('}');
        return sb.toString();
    }

    private T computeNext() {
        try {
            return this.computeNextInternal();
        }
        catch (SQLException e) {
            throw new InvalidResultSetAccessException(e);
        }
    }

    private T computeNextInternal() throws SQLException {
        if (this.closed.get()) {
            return this.endOfData();
        }
        if (this.rsToUse.next()) {
            return (T)this.mapper.mapRow(this.rsToUse, this.rowNum++);
        }
        this.close();
        return this.endOfData();
    }

    private T endOfData() {
        this.state = State.DONE;
        return null;
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

