/*
 * Decompiled with CFR 0.152.
 */
package com.alexecollins.maven.plugin;

import com.alexecollins.maven.plugin.AbstractScriptMojo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.mozilla.javascript.Context;

public class ExecuteMojo
extends AbstractScriptMojo {
    public String language = null;
    public String engine = null;
    public String script = null;
    public File scriptFile = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.execute2();
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void execute2() throws Exception {
        if (this.script == null && this.scriptFile == null) {
            throw new MojoFailureException("either script or scriptFile must be provided");
        }
        if (this.script != null && this.scriptFile != null) {
            throw new MojoFailureException("only one of script of scriptFile may be provided, but NOT both");
        }
        if (this.language == null && this.scriptFile != null) {
            try {
                this.language = BSFManager.getLangFromFilename((String)this.scriptFile.getName());
            }
            catch (BSFException e) {
                // empty catch block
            }
            int i = this.scriptFile.getName().indexOf(".");
            if (this.language == null && i >= 0) {
                this.language = this.scriptFile.getName().substring(i + 1);
            }
        }
        if (this.language == null) {
            this.language = "beanshell";
        }
        if (this.engine != null) {
            BSFManager.registerScriptingEngine((String)this.language, (String)this.engine, (String[])new String[]{this.language});
        }
        BSFManager mgr = new BSFManager();
        if (this.language.equals("javascript")) {
            Context.enter();
        }
        mgr.loadScriptingEngine(this.language);
        try {
            for (Map.Entry<String, Object> entry : this.getBeans().entrySet()) {
                mgr.declareBean(entry.getKey(), entry.getValue(), entry.getValue().getClass());
            }
        }
        catch (BSFException e) {
            if (!e.getMessage().contains("does not support")) {
                throw e;
            }
            this.getLog().warn((CharSequence)e.getMessage());
        }
        this.getLog().info((CharSequence)("executing " + this.language + " script"));
        if (this.script == null) {
            String l;
            BufferedReader in = new BufferedReader(new FileReader(this.scriptFile));
            StringBuilder s = new StringBuilder();
            while ((l = in.readLine()) != null) {
                s.append(l).append('\n');
            }
            this.script = s.toString();
        }
        mgr.eval(this.language, String.valueOf(this.scriptFile), 0, 0, (Object)this.script);
    }
}

