/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.views;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.CreateViewNode;
import com.akiban.sql.parser.FromSubquery;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.SQLParser;
import com.akiban.sql.parser.SQLParserContext;
import com.akiban.sql.parser.StatementNode;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.Visitor;

public class ViewDefinition {
    private CreateViewNode definition;
    private FromSubquery subquery;

    public ViewDefinition(String sql, SQLParser parser) throws StandardException {
        this(parser.parseStatement(sql), (SQLParserContext)parser);
    }

    public ViewDefinition(StatementNode parsed, SQLParserContext parserContext) throws StandardException {
        if (parsed.getNodeType() != 130) {
            throw new StandardException("Parsed statement was not a view");
        }
        this.definition = (CreateViewNode)parsed;
        this.subquery = (FromSubquery)parserContext.getNodeFactory().getNode(136, this.definition.getParsedQueryExpression(), this.definition.getOrderByList(), this.definition.getOffset(), this.definition.getFetchFirst(), this.getName().getTableName(), this.definition.getResultColumns(), null, parserContext);
    }

    public TableName getName() {
        return this.definition.getObjectName();
    }

    public String getQueryExpression() {
        return this.definition.getQueryExpression();
    }

    public ResultColumnList getResultColumns() {
        ResultColumnList rcl = this.subquery.getResultColumns();
        if (rcl == null) {
            rcl = this.subquery.getSubquery().getResultColumns();
        }
        return rcl;
    }

    public FromSubquery getSubquery() {
        return this.subquery;
    }

    public FromSubquery copySubquery(SQLParserContext parserContext) throws StandardException {
        return (FromSubquery)parserContext.getNodeFactory().copyNode(this.subquery, parserContext);
    }

    @Deprecated
    public FromSubquery getSubquery(Visitor binder) throws StandardException {
        this.subquery = (FromSubquery)this.subquery.accept(binder);
        return this.copySubquery(this.subquery.getParserContext());
    }
}

