/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.UnaryOperatorNode;
import com.akiban.sql.parser.ValueNode;

public class XMLUnaryOperatorNode
extends UnaryOperatorNode {
    private OperatorType operatorType;
    private Object[] additionalArgs;

    @Override
    public void init(Object operand, Object operatorType, Object addedArgs) throws StandardException {
        this.operand = (ValueNode)operand;
        this.operatorType = (OperatorType)((Object)operatorType);
        this.operator = this.operatorType.operator;
        this.methodName = this.operatorType.methodName;
        this.resultInterfaceType = this.operatorType.resultType;
        this.receiverInterfaceType = this.operatorType.argType;
        this.additionalArgs = (Object[])addedArgs;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        XMLUnaryOperatorNode other = (XMLUnaryOperatorNode)node;
        this.operatorType = other.operatorType;
        this.additionalArgs = other.additionalArgs;
    }

    public static enum OperatorType {
        PARSE("xmlparse", "XMLParse", "XMLDataValue", "StringDataValue"),
        SERIALIZE("xmlserialize", "XMLSerialize", "StringDataValue", "XMLDataValue");

        String operator;
        String methodName;
        String resultType;
        String argType;

        private OperatorType(String operator, String methodName, String resultType, String argType) {
            this.operator = operator;
            this.methodName = methodName;
            this.resultType = resultType;
            this.argType = argType;
        }
    }
}

