/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumn;
import com.akiban.sql.parser.ResultSetNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.types.DataTypeDescriptor;

public class VirtualColumnNode
extends ValueNode {
    private ResultSetNode sourceResultSet;
    private ResultColumn sourceColumn;
    int columnId;

    @Override
    public void init(Object sourceResultSet, Object sourceColumn, Object columnId) throws StandardException {
        ResultColumn source = (ResultColumn)sourceColumn;
        this.sourceResultSet = (ResultSetNode)sourceResultSet;
        this.sourceColumn = source;
        this.columnId = (Integer)columnId;
        this.setType(source.getType());
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        VirtualColumnNode other = (VirtualColumnNode)node;
        this.sourceResultSet = (ResultSetNode)this.getNodeFactory().copyNode(other.sourceResultSet, this.getParserContext());
        this.sourceColumn = (ResultColumn)this.getNodeFactory().copyNode(other.sourceColumn, this.getParserContext());
        this.columnId = other.columnId;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "sourceColumn: ");
        this.sourceColumn.treePrint(depth + 1);
        this.printLabel(depth, "sourceResultSet: ");
        this.sourceResultSet.treePrint(depth + 1);
    }

    public ResultSetNode getSourceResultSet() {
        return this.sourceResultSet;
    }

    public ResultColumn getSourceColumn() {
        return this.sourceColumn;
    }

    @Override
    public String getTableName() {
        return this.sourceColumn.getTableName();
    }

    @Override
    public String getSchemaName() throws StandardException {
        return this.sourceColumn.getSchemaName();
    }

    @Override
    public DataTypeDescriptor getType() {
        return this.sourceColumn.getType();
    }

    @Override
    public void setType(DataTypeDescriptor dtd) throws StandardException {
        this.sourceColumn.setType(dtd);
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            VirtualColumnNode other = (VirtualColumnNode)o;
            return this.sourceColumn.isEquivalent(other.sourceColumn);
        }
        return false;
    }
}

