/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.UnaryOperatorNode;

public class UnaryArithmeticOperatorNode
extends UnaryOperatorNode {
    private OperatorType operatorType;

    @Override
    public void init(Object operand) throws StandardException {
        switch (this.getNodeType()) {
            case 30: {
                this.operatorType = OperatorType.PLUS;
                break;
            }
            case 29: {
                this.operatorType = OperatorType.MINUS;
                break;
            }
            case 189: {
                this.operatorType = OperatorType.SQRT;
                break;
            }
            case 188: {
                this.operatorType = OperatorType.ABSOLUTE;
                break;
            }
            default: {
                assert (false) : "init for UnaryArithmeticOperator called with wrong nodeType = " + this.getNodeType();
                break;
            }
        }
        this.init(operand, this.operatorType.operator, this.operatorType.methodName);
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        UnaryArithmeticOperatorNode other = (UnaryArithmeticOperatorNode)node;
        this.operatorType = other.operatorType;
    }

    public static enum OperatorType {
        PLUS("+", "plus"),
        MINUS("-", "minus"),
        SQRT("SQRT", "sqrt"),
        ABSOLUTE("ABS", "absolute");

        String operator;
        String methodName;

        private OperatorType(String operator, String methodName) {
            this.operator = operator;
            this.methodName = methodName;
        }
    }
}

