/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;

public class TernaryOperatorNode
extends ValueNode {
    protected String operator;
    protected String methodName;
    protected OperatorType operatorType;
    protected ValueNode receiver;
    protected ValueNode leftOperand;
    protected ValueNode rightOperand;
    protected String resultInterfaceType;
    protected String receiverInterfaceType;
    protected String leftInterfaceType;
    protected String rightInterfaceType;
    public static final int YEAR_INTERVAL = 0;
    public static final int QUARTER_INTERVAL = 1;
    public static final int MONTH_INTERVAL = 2;
    public static final int WEEK_INTERVAL = 3;
    public static final int DAY_INTERVAL = 4;
    public static final int HOUR_INTERVAL = 5;
    public static final int MINUTE_INTERVAL = 6;
    public static final int SECOND_INTERVAL = 7;
    public static final int FRAC_SECOND_INTERVAL = 8;

    @Override
    public void init(Object receiver, Object leftOperand, Object rightOperand, Object operatorType, Object trimType) {
        this.receiver = (ValueNode)receiver;
        this.leftOperand = (ValueNode)leftOperand;
        this.rightOperand = (ValueNode)rightOperand;
        this.operatorType = (OperatorType)((Object)operatorType);
        this.operator = this.operatorType.operator;
        this.methodName = this.operatorType.methodName;
        this.resultInterfaceType = this.operatorType.resultType;
        this.receiverInterfaceType = this.operatorType.argTypes[0];
        this.leftInterfaceType = this.operatorType.argTypes[1];
        this.rightInterfaceType = this.operatorType.argTypes[2];
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        TernaryOperatorNode other = (TernaryOperatorNode)node;
        this.operator = other.operator;
        this.methodName = other.methodName;
        this.operatorType = other.operatorType;
        this.receiver = (ValueNode)this.getNodeFactory().copyNode(other.receiver, this.getParserContext());
        this.leftOperand = (ValueNode)this.getNodeFactory().copyNode(other.leftOperand, this.getParserContext());
        this.rightOperand = (ValueNode)this.getNodeFactory().copyNode(other.rightOperand, this.getParserContext());
        this.resultInterfaceType = other.resultInterfaceType;
        this.receiverInterfaceType = other.receiverInterfaceType;
        this.leftInterfaceType = other.leftInterfaceType;
        this.rightInterfaceType = other.rightInterfaceType;
    }

    @Override
    public String toString() {
        return "operator: " + this.operator + "\n" + "methodName: " + this.methodName + "\n" + "resultInterfaceType: " + this.resultInterfaceType + "\n" + "receiverInterfaceType: " + this.receiverInterfaceType + "\n" + "leftInterfaceType: " + this.leftInterfaceType + "\n" + "rightInterfaceType: " + this.rightInterfaceType + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.receiver != null) {
            this.printLabel(depth, "receiver: ");
            this.receiver.treePrint(depth + 1);
        }
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.rightOperand != null) {
            this.printLabel(depth, "rightOperand: ");
            this.rightOperand.treePrint(depth + 1);
        }
    }

    public String getOperator() {
        return this.operator;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public ValueNode getReceiver() {
        return this.receiver;
    }

    public void setReceiver(ValueNode receiver) {
        this.receiver = receiver;
    }

    public void setLeftOperand(ValueNode newLeftOperand) {
        this.leftOperand = newLeftOperand;
    }

    public ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperand(ValueNode newRightOperand) {
        this.rightOperand = newRightOperand;
    }

    public ValueNode getRightOperand() {
        return this.rightOperand;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.receiver != null) {
            this.receiver = (ValueNode)this.receiver.accept(v);
        }
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
        if (this.rightOperand != null) {
            this.rightOperand = (ValueNode)this.rightOperand.accept(v);
        }
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            TernaryOperatorNode other = (TernaryOperatorNode)o;
            return other.methodName.equals(this.methodName) && other.receiver.isEquivalent(this.receiver) && other.leftOperand.isEquivalent(this.leftOperand) && (this.rightOperand == null && other.rightOperand == null || other.rightOperand != null && other.rightOperand.isEquivalent(this.rightOperand));
        }
        return false;
    }

    public static enum OperatorType {
        LOCATE("LOCATE", "locate", "NumberDataValue", new String[]{"StringDataValue", "StringDataValue", "NumberDataValue"}),
        SUBSTRING("substring", "substring", "ConcatableDataValue", new String[]{"ConcatableDataValue", "NumberDataValue", "NumberDataValue"}),
        LIKE("like", "like", "BooleanDataValue", new String[]{"DataValueDescriptor", "DataValueDescriptor", "DataValueDescriptor"}),
        TIMESTAMPADD("TIMESTAMPADD", "timestampAdd", "DateTimeDataValue", new String[]{"DateTimeDataValue", "java.lang.Integer", "NumberDataValue"}),
        TIMESTAMPDIFF("TIMESTAMPDIFF", "timestampDiff", "NumberDataValue", new String[]{"java.lang.Integer", "DateTimeDataValue", "DateTimeDataValue"});

        String operator;
        String methodName;
        String resultType;
        String[] argTypes;

        private OperatorType(String operator, String methodName, String resultType, String[] argTypes) {
            this.operator = operator;
            this.methodName = methodName;
            this.resultType = resultType;
            this.argTypes = argTypes;
        }
    }
}

