/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.parser.CharStream;
import java.io.EOFException;
import java.io.IOException;

public class StringCharStream
implements CharStream {
    private static final IOException EOF = new EOFException();
    private String string;
    private int beginIndex;
    private int currentIndex;
    private int currentLine;
    private int currentColumn;
    private int beginLine;
    private int beginColumn;
    private int endLine;
    private int endColumn;

    public StringCharStream(String string) {
        this.init(string);
    }

    public void ReInit(String string) {
        this.init(string);
    }

    private void init(String string) {
        this.string = string;
        this.currentIndex = 0;
        this.beginIndex = 0;
        this.endColumn = 1;
        this.endLine = 1;
        this.beginColumn = 1;
        this.beginLine = 1;
        this.currentColumn = 1;
        this.currentLine = 1;
    }

    @Override
    public char BeginToken() throws IOException {
        this.beginIndex = this.currentIndex;
        this.beginLine = this.currentLine;
        this.beginColumn = this.currentColumn;
        return this.readChar();
    }

    @Override
    public char readChar() throws IOException {
        if (this.currentIndex >= this.string.length()) {
            throw EOF;
        }
        return this.advance();
    }

    @Override
    public void backup(int amount) {
        int target = this.currentIndex - amount;
        assert (target >= this.beginIndex);
        this.currentIndex = this.beginIndex;
        this.currentLine = this.beginLine;
        this.currentColumn = this.beginColumn;
        while (this.currentIndex < target) {
            this.advance();
        }
    }

    private char advance() {
        this.endLine = this.currentLine;
        this.endColumn = this.currentColumn++;
        char ch = this.string.charAt(this.currentIndex++);
        switch (ch) {
            case '\r': {
                if (this.currentIndex < this.string.length() && this.string.charAt(this.currentIndex) == '\n') break;
            }
            case '\n': {
                ++this.currentLine;
                this.currentColumn = 1;
                break;
            }
            case '\t': {
                this.endColumn += 8 - (this.endColumn & 7);
                this.currentColumn = this.endColumn + 1;
                break;
            }
            default: {
                ++this.currentColumn;
            }
        }
        return ch;
    }

    @Override
    public int getBeginOffset() {
        return this.beginIndex;
    }

    @Override
    public int getEndOffset() {
        return this.currentIndex - 1;
    }

    @Override
    public int getBeginLine() {
        return this.beginLine;
    }

    @Override
    public int getBeginColumn() {
        return this.beginColumn;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    @Override
    public int getLine() {
        return this.getEndLine();
    }

    @Override
    public int getColumn() {
        return this.getEndColumn();
    }

    @Override
    public String GetImage() {
        return this.string.substring(this.beginIndex, this.currentIndex);
    }

    @Override
    public char[] GetSuffix(int len) {
        char[] result = new char[len];
        this.string.getChars(this.currentIndex - len, this.currentIndex, result, 0);
        return result;
    }

    @Override
    public void Done() {
    }
}

