/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DMLModStatementNode;
import com.akiban.sql.parser.OrderByList;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;
import java.util.Properties;

public final class InsertNode
extends DMLModStatementNode {
    private ResultColumnList targetColumnList;
    private Properties targetProperties;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;

    @Override
    public void init(Object targetName, Object insertColumns, Object queryExpression, Object targetProperties, Object orderByList, Object offset, Object fetchFirst, Object returningList) {
        super.init(queryExpression, InsertNode.getStatementType((Properties)targetProperties));
        this.setTarget((QueryTreeNode)targetName);
        this.targetColumnList = (ResultColumnList)insertColumns;
        this.targetProperties = (Properties)targetProperties;
        this.orderByList = (OrderByList)orderByList;
        this.offset = (ValueNode)offset;
        this.fetchFirst = (ValueNode)fetchFirst;
        this.returningColumnList = (ResultColumnList)returningList;
        this.getResultSetNode().setInsertSource();
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        InsertNode other = (InsertNode)node;
        this.targetColumnList = (ResultColumnList)this.getNodeFactory().copyNode(other.targetColumnList, this.getParserContext());
        this.targetProperties = other.targetProperties;
        this.orderByList = (OrderByList)this.getNodeFactory().copyNode(other.orderByList, this.getParserContext());
        this.offset = (ValueNode)this.getNodeFactory().copyNode(other.offset, this.getParserContext());
        this.fetchFirst = (ValueNode)this.getNodeFactory().copyNode(other.fetchFirst, this.getParserContext());
    }

    @Override
    public String statementToString() {
        return "INSERT";
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.targetColumnList != null) {
            this.printLabel(depth, "targetColumnList: ");
            this.targetColumnList.treePrint(depth + 1);
        }
        if (this.orderByList != null) {
            this.printLabel(depth, "orderByList: ");
            this.orderByList.treePrint(depth + 1);
        }
    }

    @Override
    protected int getStatementType() {
        return 1;
    }

    static int getStatementType(Properties targetProperties) {
        String insertMode;
        int retval = 1;
        String string = insertMode = targetProperties == null ? null : targetProperties.getProperty("insertMode");
        if (insertMode != null && "REPLACE".equalsIgnoreCase(insertMode)) {
            retval = 2;
        }
        return retval;
    }

    public ResultColumnList getTargetColumnList() {
        return this.targetColumnList;
    }

    public Properties getTargetProperties() {
        return this.targetProperties;
    }

    public OrderByList getOrderByList() {
        return this.orderByList;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public ValueNode getFetchFirst() {
        return this.fetchFirst;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.targetColumnList != null) {
            this.targetColumnList.accept(v);
        }
    }
}

