/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.TableName;

public class IndexColumn
extends QueryTreeNode {
    private TableName tableName;
    private String columnName;
    private boolean ascending = true;

    @Override
    public void init(Object columnName, Object ascending) {
        this.tableName = null;
        this.columnName = (String)columnName;
        this.ascending = (Boolean)ascending;
    }

    @Override
    public void init(Object tableName, Object columnName, Object ascending) {
        this.tableName = (TableName)tableName;
        this.columnName = (String)columnName;
        this.ascending = (Boolean)ascending;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        IndexColumn other = (IndexColumn)node;
        this.tableName = (TableName)this.getNodeFactory().copyNode(other.tableName, this.getParserContext());
        this.columnName = other.columnName;
        this.ascending = other.ascending;
    }

    @Override
    public String toString() {
        return "columnName: " + this.columnName + "\n" + "tableName: " + (this.tableName != null ? this.tableName.toString() : "null") + "\n" + (this.ascending ? "ascending" : "descending") + "\n" + super.toString();
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isPartOfGroupIndex() {
        return this.tableName != null;
    }

    public boolean isAscending() {
        return this.ascending;
    }
}

