/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DMLStatementNode;
import com.akiban.sql.parser.IsolationLevel;
import com.akiban.sql.parser.OrderByList;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;
import java.util.List;

public class CursorNode
extends DMLStatementNode {
    private String name;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private String statementType;
    private UpdateMode updateMode;
    private IsolationLevel scanIsolationLevel = IsolationLevel.UNSPECIFIED_ISOLATION_LEVEL;
    private List<String> updatableColumns;

    @Override
    public void init(Object statementType, Object resultSet, Object name, Object orderByList, Object offset, Object fetchFirst, Object updateMode, Object updatableColumns) {
        this.init(resultSet);
        this.name = (String)name;
        this.statementType = (String)statementType;
        this.orderByList = (OrderByList)orderByList;
        this.offset = (ValueNode)offset;
        this.fetchFirst = (ValueNode)fetchFirst;
        this.updateMode = (UpdateMode)((Object)updateMode);
        this.updatableColumns = (List)updatableColumns;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        CursorNode other = (CursorNode)node;
        this.name = other.name;
        this.orderByList = (OrderByList)this.getNodeFactory().copyNode(other.orderByList, this.getParserContext());
        this.offset = (ValueNode)this.getNodeFactory().copyNode(other.offset, this.getParserContext());
        this.fetchFirst = (ValueNode)this.getNodeFactory().copyNode(other.fetchFirst, this.getParserContext());
        this.statementType = other.statementType;
        this.updateMode = other.updateMode;
        this.scanIsolationLevel = other.scanIsolationLevel;
        this.updatableColumns = other.updatableColumns;
    }

    public void setScanIsolationLevel(IsolationLevel isolationLevel) {
        this.scanIsolationLevel = isolationLevel;
    }

    @Override
    public String toString() {
        return "name: " + this.name + "\n" + "updateMode: " + (Object)((Object)this.updateMode) + "\n" + super.toString();
    }

    @Override
    public String statementToString() {
        return this.statementType;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.orderByList != null) {
            this.printLabel(depth, "orderByList: ");
            this.orderByList.treePrint(depth + 1);
        }
        if (this.offset != null) {
            this.printLabel(depth, "offset: ");
            this.offset.treePrint(depth + 1);
        }
        if (this.fetchFirst != null) {
            this.printLabel(depth, "fetchFirst: ");
            this.fetchFirst.treePrint(depth + 1);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.orderByList != null) {
            this.orderByList = (OrderByList)this.orderByList.accept(v);
        }
        if (this.offset != null) {
            this.offset = (ValueNode)this.offset.accept(v);
        }
        if (this.fetchFirst != null) {
            this.fetchFirst = (ValueNode)this.fetchFirst.accept(v);
        }
    }

    public String getName() {
        return this.name;
    }

    public OrderByList getOrderByList() {
        return this.orderByList;
    }

    public ValueNode getOffsetClause() {
        return this.offset;
    }

    public ValueNode getFetchFirstClause() {
        return this.fetchFirst;
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public IsolationLevel getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    public List<String> getUpdatableColumns() {
        return this.updatableColumns;
    }

    public static enum UpdateMode {
        UNSPECIFIED,
        READ_ONLY,
        UPDATE;

    }
}

