/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DDLStatementNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.types.AliasInfo;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.RoutineAliasInfo;
import com.akiban.sql.types.SynonymAliasInfo;
import com.akiban.sql.types.UDTAliasInfo;
import java.util.Arrays;
import java.util.List;

public class CreateAliasNode
extends DDLStatementNode {
    public static final int PARAMETER_ARRAY = 0;
    public static final int TABLE_NAME = 1;
    public static final int DYNAMIC_RESULT_SET_COUNT = 2;
    public static final int LANGUAGE = 3;
    public static final int EXTERNAL_NAME = 4;
    public static final int PARAMETER_STYLE = 5;
    public static final int SQL_CONTROL = 6;
    public static final int DETERMINISTIC = 7;
    public static final int NULL_ON_NULL_INPUT = 8;
    public static final int RETURN_TYPE = 9;
    public static final int ROUTINE_SECURITY_DEFINER = 10;
    public static final int INLINE_DEFINITION = 11;
    public static final int ROUTINE_ELEMENT_COUNT = 12;
    private String javaClassName;
    private String methodName;
    private boolean createOrReplace;
    private AliasInfo.Type aliasType;
    private AliasInfo aliasInfo;
    private String definition;

    @Override
    public void init(Object aliasName, Object targetObject, Object methodName, Object aliasSpecificInfo, Object aliasType, Object createOrReplace) throws StandardException {
        TableName qn = (TableName)aliasName;
        this.aliasType = (AliasInfo.Type)((Object)aliasType);
        this.createOrReplace = (Boolean)createOrReplace;
        this.initAndCheck(qn);
        switch (this.aliasType) {
            case UDT: {
                this.javaClassName = (String)targetObject;
                this.aliasInfo = new UDTAliasInfo();
                this.implicitCreateSchema = true;
                break;
            }
            case PROCEDURE: 
            case FUNCTION: {
                Integer drso;
                Object[] routineElements = (Object[])aliasSpecificInfo;
                Object[] parameters = (Object[])routineElements[0];
                int paramCount = ((List)parameters[0]).size();
                String[] names = null;
                DataTypeDescriptor[] types = null;
                int[] modes = null;
                if (paramCount != 0) {
                    names = new String[paramCount];
                    ((List)parameters[0]).toArray(names);
                    types = new DataTypeDescriptor[paramCount];
                    ((List)parameters[1]).toArray(types);
                    modes = new int[paramCount];
                    for (int i = 0; i < paramCount; ++i) {
                        int currentMode;
                        modes[i] = currentMode = ((Integer)((List)parameters[2]).get(i)).intValue();
                    }
                    if (paramCount > 1) {
                        Object[] dupNameCheck = new String[paramCount];
                        System.arraycopy(names, 0, dupNameCheck, 0, paramCount);
                        Arrays.sort(dupNameCheck);
                        for (int dnc = 1; dnc < dupNameCheck.length; ++dnc) {
                            if (((String)dupNameCheck[dnc]).equals("") || !((String)dupNameCheck[dnc]).equals(dupNameCheck[dnc - 1])) continue;
                            throw new StandardException("Duplicate parameter name");
                        }
                    }
                }
                int drs = (drso = (Integer)routineElements[2]) == null ? 0 : drso;
                RoutineAliasInfo.SQLAllowed sqlAllowed = (RoutineAliasInfo.SQLAllowed)((Object)routineElements[6]);
                Boolean isDeterministicO = (Boolean)routineElements[7];
                boolean isDeterministic = isDeterministicO == null ? false : isDeterministicO;
                Boolean definersRightsO = (Boolean)routineElements[10];
                boolean definersRights = definersRightsO == null ? false : definersRightsO;
                Boolean calledOnNullInputO = (Boolean)routineElements[8];
                boolean calledOnNullInput = calledOnNullInputO == null ? false : calledOnNullInputO;
                DataTypeDescriptor returnType = (DataTypeDescriptor)routineElements[9];
                String language = (String)routineElements[3];
                String pstyle = (String)routineElements[5];
                this.definition = (String)routineElements[11];
                this.javaClassName = (String)targetObject;
                this.methodName = (String)methodName;
                this.aliasInfo = new RoutineAliasInfo(this.methodName, paramCount, names, types, modes, drs, language, pstyle, sqlAllowed, isDeterministic, definersRights, calledOnNullInput, returnType);
                this.implicitCreateSchema = true;
                break;
            }
            case SYNONYM: {
                String targetSchema = null;
                this.implicitCreateSchema = true;
                TableName t = (TableName)targetObject;
                if (t.getSchemaName() != null) {
                    targetSchema = t.getSchemaName();
                }
                this.aliasInfo = new SynonymAliasInfo(targetSchema, t.getTableName());
                break;
            }
            default: {
                assert (false) : "Unexpected value for aliasType " + aliasType;
                break;
            }
        }
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getExternalName() {
        if (this.javaClassName == null) {
            return this.methodName;
        }
        if (this.methodName == null) {
            return this.javaClassName;
        }
        return this.javaClassName + "." + this.methodName;
    }

    public boolean isCreateOrReplace() {
        return this.createOrReplace;
    }

    public AliasInfo.Type getAliasType() {
        return this.aliasType;
    }

    public AliasInfo getAliasInfo() {
        return this.aliasInfo;
    }

    public String getDefinition() {
        return this.definition;
    }

    @Override
    public String toString() {
        return "aliasType: " + (Object)((Object)this.aliasType) + "\n" + "aliasInfo: " + this.aliasInfo + "\n" + "createOrReplace: " + this.createOrReplace + "\n" + (this.definition != null ? "definition: " + this.definition + "\n" : "javaClassName: " + this.javaClassName + "\n" + "methodName: " + this.methodName + "\n") + super.toString();
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        CreateAliasNode other = (CreateAliasNode)node;
        this.javaClassName = other.javaClassName;
        this.methodName = other.methodName;
        this.definition = other.definition;
        this.aliasType = other.aliasType;
        this.aliasInfo = other.aliasInfo;
    }

    @Override
    public String statementToString() {
        switch (this.aliasType) {
            case UDT: {
                return "CREATE TYPE";
            }
            case PROCEDURE: {
                return "CREATE PROCEDURE";
            }
            case SYNONYM: {
                return "CREATE SYNONYM";
            }
        }
        return "CREATE FUNCTION";
    }
}

