/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.BinaryComparisonOperatorNode;
import com.akiban.sql.parser.QueryTreeNode;

public class BinaryRelationalOperatorNode
extends BinaryComparisonOperatorNode {
    public static final int EQUALS_RELOP = 1;
    public static final int NOT_EQUALS_RELOP = 2;
    public static final int GREATER_THAN_RELOP = 3;
    public static final int GREATER_EQUALS_RELOP = 4;
    public static final int LESS_THAN_RELOP = 5;
    public static final int LESS_EQUALS_RELOP = 6;
    public static final int IS_NULL_RELOP = 7;
    public static final int IS_NOT_NULL_RELOP = 8;
    private int operatorType;

    @Override
    public void init(Object leftOperand, Object rightOperand) {
        String methodName = "";
        String operatorName = "";
        switch (this.getNodeType()) {
            case 41: {
                methodName = "equals";
                operatorName = "=";
                this.operatorType = 1;
                break;
            }
            case 42: {
                methodName = "greaterOrEquals";
                operatorName = ">=";
                this.operatorType = 4;
                break;
            }
            case 43: {
                methodName = "greaterThan";
                operatorName = ">";
                this.operatorType = 3;
                break;
            }
            case 44: {
                methodName = "lessOrEquals";
                operatorName = "<=";
                this.operatorType = 6;
                break;
            }
            case 45: {
                methodName = "lessThan";
                operatorName = "<";
                this.operatorType = 5;
                break;
            }
            case 47: {
                methodName = "notEquals";
                operatorName = "<>";
                this.operatorType = 2;
                break;
            }
            default: {
                assert (false) : "init for BinaryRelationalOperator called with wrong nodeType = " + this.getNodeType();
                break;
            }
        }
        super.init(leftOperand, rightOperand, operatorName, methodName);
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        BinaryRelationalOperatorNode other = (BinaryRelationalOperatorNode)node;
        this.operatorType = other.operatorType;
    }

    public int getOperatorType() {
        return this.operatorType;
    }
}

