/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.compiler;

import com.akiban.sql.StandardException;
import com.akiban.sql.compiler.TypeCompiler;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.TypeId;

public class IntervalTypeCompiler
extends TypeCompiler {
    protected IntervalTypeCompiler(TypeId typeId) {
        super(typeId);
    }

    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (otherType.isStringTypeId() && !otherType.isLongConcatableTypeId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == otherType.getTypeFormatId();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return null;
    }

    @Override
    public String getPrimitiveMethodName() {
        return null;
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dtd) {
        TypeId typeId = dtd.getTypeId();
        if (typeId == TypeId.INTERVAL_YEAR_ID) {
            return dtd.getPrecision();
        }
        if (typeId == TypeId.INTERVAL_MONTH_ID) {
            return dtd.getPrecision();
        }
        if (typeId == TypeId.INTERVAL_YEAR_MONTH_ID) {
            return dtd.getPrecision() + 1 + 2;
        }
        if (typeId == TypeId.INTERVAL_DAY_ID) {
            return dtd.getPrecision();
        }
        if (typeId == TypeId.INTERVAL_HOUR_ID) {
            return dtd.getPrecision();
        }
        if (typeId == TypeId.INTERVAL_MINUTE_ID) {
            return dtd.getPrecision();
        }
        if (typeId == TypeId.INTERVAL_SECOND_ID) {
            if (dtd.getScale() > 0) {
                return dtd.getPrecision() + 1 + dtd.getScale();
            }
            return dtd.getPrecision();
        }
        if (typeId == TypeId.INTERVAL_DAY_HOUR_ID) {
            return dtd.getPrecision() + 1 + 2;
        }
        if (typeId == TypeId.INTERVAL_DAY_MINUTE_ID) {
            return dtd.getPrecision() + 1 + 2 + 1 + 2;
        }
        if (typeId == TypeId.INTERVAL_DAY_SECOND_ID) {
            if (dtd.getScale() > 0) {
                return dtd.getPrecision() + 1 + 2 + 1 + 2 + 1 + 2 + 1 + dtd.getScale();
            }
            return dtd.getPrecision() + 1 + 2 + 1 + 2 + 1 + 2;
        }
        if (typeId == TypeId.INTERVAL_HOUR_MINUTE_ID) {
            return dtd.getPrecision() + 1 + 2;
        }
        if (typeId == TypeId.INTERVAL_HOUR_SECOND_ID) {
            if (dtd.getScale() > 0) {
                return dtd.getPrecision() + 1 + 2 + 1 + 2 + 1 + dtd.getScale();
            }
            return dtd.getPrecision() + 1 + 2 + 1 + 2;
        }
        if (typeId == TypeId.INTERVAL_MINUTE_SECOND_ID) {
            if (dtd.getScale() > 0) {
                return dtd.getPrecision() + 1 + 2 + 1 + dtd.getScale();
            }
            return dtd.getPrecision() + 1 + 2;
        }
        assert (false) : "unexpected typeId in getCastToCharWidth() - " + typeId;
        return 0;
    }

    @Override
    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor leftType, DataTypeDescriptor rightType, String operator) throws StandardException {
        boolean nullable;
        TypeId rightTypeId = rightType.getTypeId();
        TypeId leftTypeId = leftType.getTypeId();
        boolean bl = nullable = leftType.isNullable() || rightType.isNullable();
        if (operator.equals("+") || operator.equals("-")) {
            DataTypeDescriptor varcharType;
            TypeId datetimeType = rightTypeId;
            if (datetimeType.isDateTimeTimeStampTypeId() && leftTypeId.isIntervalTypeId() || (datetimeType = leftTypeId).isDateTimeTimeStampTypeID() && rightTypeId.isIntervalTypeId()) {
                return IntervalTypeCompiler.getTypeCompiler(datetimeType).resolveArithmeticOperation(rightType, leftType, operator);
            }
            int typeFormatId = 0;
            if (leftTypeId.isIntervalTypeId() && rightTypeId.isIntervalTypeId()) {
                if (leftTypeId == rightTypeId) {
                    return leftType.getNullabilityType(nullable);
                }
                typeFormatId = leftTypeId.getTypeFormatId();
                if (typeFormatId == rightTypeId.getTypeFormatId()) {
                    return new DataTypeDescriptor(typeFormatId == 25 ? TypeId.INTERVAL_SECOND_ID : TypeId.INTERVAL_MONTH_ID, nullable);
                }
            }
            if ((varcharType = leftType).getTypeId().isStringTypeId() && rightTypeId.isIntervalTypeId() || (varcharType = rightType).getTypeId().isStringTypeId() && leftTypeId.isIntervalTypeId() && operator.equals("+")) {
                return new DataTypeDescriptor(varcharType.getPrecision() > 10 ? TypeId.DATETIME_ID : TypeId.DATE_ID, nullable);
            }
        } else if (operator.equals("*") || operator.equals("/") || operator.equals("div")) {
            TypeId intervalId = null;
            intervalId = leftTypeId;
            if (intervalId.isIntervalTypeId() && (rightTypeId.isNumericTypeId() || rightTypeId.isStringTypeId()) || (intervalId = rightTypeId).isIntervalTypeId() && (leftTypeId.isNumericTypeId() || leftTypeId.isStringTypeId()) && operator.equals("*")) {
                return new DataTypeDescriptor(intervalId, nullable);
            }
        }
        return super.resolveArithmeticOperation(leftType, rightType, operator);
    }
}

