/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.compiler;

import com.akiban.sql.compiler.TypeCompiler;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.TypeId;

public class BitTypeCompiler
extends TypeCompiler {
    protected BitTypeCompiler(TypeId typeId) {
        super(typeId);
    }

    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (otherType.isAnsiUDT()) {
            return false;
        }
        return otherType.isBitTypeId() || otherType.isBlobTypeId() || otherType.userType();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        if (otherType.isBlobTypeId()) {
            return false;
        }
        return otherType.isBitTypeId();
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "byte[]";
    }

    @Override
    public String getPrimitiveMethodName() {
        return "getBytes";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return dts.getMaximumWidth();
    }
}

